/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.operation;

import com.yahoo.elide.ElideResponse;
import com.yahoo.elide.async.models.AsyncAPI;
import com.yahoo.elide.async.models.AsyncQuery;
import com.yahoo.elide.async.operation.AsyncQueryOperation;
import com.yahoo.elide.async.service.AsyncExecutorService;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.exceptions.InvalidOperationException;
import com.yahoo.elide.core.security.User;
import com.yahoo.elide.graphql.QueryRunner;
import java.net.URISyntaxException;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLAsyncQueryOperation
extends AsyncQueryOperation {
    private static final Logger log = LoggerFactory.getLogger(GraphQLAsyncQueryOperation.class);

    public GraphQLAsyncQueryOperation(AsyncExecutorService service, AsyncAPI queryObj, RequestScope scope) {
        super(service, queryObj, scope);
    }

    @Override
    public ElideResponse execute(AsyncAPI queryObj, RequestScope scope) throws URISyntaxException {
        User user = scope.getUser();
        String apiVersion = scope.getApiVersion();
        QueryRunner runner = this.getService().getRunners().get(apiVersion);
        if (runner == null) {
            throw new InvalidOperationException("Invalid API Version");
        }
        UUID requestUUID = UUID.fromString(queryObj.getRequestId());
        ElideResponse response = runner.run("", queryObj.getQuery(), user, requestUUID, scope.getRequestHeaders());
        log.debug("GRAPHQL_V1_0 getResponseCode: {}, GRAPHQL_V1_0 getBody: {}", (Object)response.getResponseCode(), (Object)response.getBody());
        return response;
    }

    @Override
    public Integer calculateRecordCount(AsyncQuery queryObj, ElideResponse response) {
        Integer count = 0;
        if (response.getResponseCode() == 200) {
            count = GraphQLAsyncQueryOperation.safeJsonPathLength(response.getBody(), "$..edges.length()");
        }
        return count;
    }
}

