/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.operation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.elide.Elide;
import com.yahoo.elide.async.export.formatter.TableExportFormatter;
import com.yahoo.elide.async.export.validator.NoRelationshipsProjectionValidator;
import com.yahoo.elide.async.models.AsyncAPI;
import com.yahoo.elide.async.models.TableExport;
import com.yahoo.elide.async.operation.TableExportOperation;
import com.yahoo.elide.async.service.AsyncExecutorService;
import com.yahoo.elide.async.service.storageengine.ResultStorageEngine;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.datastore.DataStoreTransaction;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.core.security.User;
import com.yahoo.elide.graphql.GraphQLRequestScope;
import com.yahoo.elide.graphql.QueryRunner;
import com.yahoo.elide.graphql.parser.GraphQLEntityProjectionMaker;
import com.yahoo.elide.graphql.parser.GraphQLProjectionInfo;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLTableExportOperation
extends TableExportOperation {
    private static final Logger log = LoggerFactory.getLogger(GraphQLTableExportOperation.class);

    public GraphQLTableExportOperation(TableExportFormatter formatter, AsyncExecutorService service, AsyncAPI export, RequestScope scope, ResultStorageEngine engine) {
        super(formatter, service, export, scope, engine, Arrays.asList(new NoRelationshipsProjectionValidator()));
    }

    @Override
    public RequestScope getRequestScope(TableExport export, RequestScope scope, DataStoreTransaction tx, Map<String, List<String>> additionalRequestHeaders) {
        UUID requestId = UUID.fromString(export.getRequestId());
        User user = scope.getUser();
        String apiVersion = scope.getApiVersion();
        return new GraphQLRequestScope("", tx, user, apiVersion, this.getService().getElide().getElideSettings(), null, requestId, additionalRequestHeaders);
    }

    @Override
    public Collection<EntityProjection> getProjections(TableExport export, RequestScope scope) {
        GraphQLProjectionInfo projectionInfo;
        try {
            String graphQLDocument = export.getQuery();
            Elide elide = this.getService().getElide();
            ObjectMapper mapper = elide.getMapper().getObjectMapper();
            JsonNode node = QueryRunner.getTopLevelNode((ObjectMapper)mapper, (String)graphQLDocument);
            Map variables = QueryRunner.extractVariables((ObjectMapper)mapper, (JsonNode)node);
            String queryString = QueryRunner.extractQuery((JsonNode)node);
            projectionInfo = new GraphQLEntityProjectionMaker(elide.getElideSettings(), variables, scope.getApiVersion()).make(queryString);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return projectionInfo.getProjections().values();
    }
}

