/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.operation;

import com.yahoo.elide.Elide;
import com.yahoo.elide.ElideResponse;
import com.yahoo.elide.async.models.AsyncAPI;
import com.yahoo.elide.async.models.AsyncQuery;
import com.yahoo.elide.async.operation.AsyncQueryOperation;
import com.yahoo.elide.async.service.AsyncExecutorService;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.security.User;
import java.net.URISyntaxException;
import java.util.UUID;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONAPIAsyncQueryOperation
extends AsyncQueryOperation {
    private static final Logger log = LoggerFactory.getLogger(JSONAPIAsyncQueryOperation.class);

    public JSONAPIAsyncQueryOperation(AsyncExecutorService service, AsyncAPI queryObj, RequestScope scope) {
        super(service, queryObj, scope);
    }

    @Override
    public ElideResponse execute(AsyncAPI queryObj, RequestScope scope) throws URISyntaxException {
        Elide elide = this.getService().getElide();
        User user = scope.getUser();
        String apiVersion = scope.getApiVersion();
        UUID requestUUID = UUID.fromString(queryObj.getRequestId());
        URIBuilder uri = new URIBuilder(queryObj.getQuery());
        MultivaluedMap<String, String> queryParams = JSONAPIAsyncQueryOperation.getQueryParams(uri);
        log.debug("Extracted QueryParams from AsyncQuery Object: {}", queryParams);
        ElideResponse response = elide.get("", JSONAPIAsyncQueryOperation.getPath(uri), queryParams, scope.getRequestHeaders(), user, apiVersion, requestUUID);
        log.debug("JSONAPI_V1_0 getResponseCode: {}, JSONAPI_V1_0 getBody: {}", (Object)response.getResponseCode(), (Object)response.getBody());
        return response;
    }

    public static MultivaluedMap<String, String> getQueryParams(URIBuilder uri) {
        MultivaluedHashMap queryParams = new MultivaluedHashMap();
        for (NameValuePair queryParam : uri.getQueryParams()) {
            queryParams.add((Object)queryParam.getName(), (Object)queryParam.getValue());
        }
        return queryParams;
    }

    public static String getPath(URIBuilder uri) {
        return uri.getPath();
    }

    @Override
    public Integer calculateRecordCount(AsyncQuery queryObj, ElideResponse response) {
        Integer count = null;
        if (response.getResponseCode() == 200) {
            count = JSONAPIAsyncQueryOperation.safeJsonPathLength(response.getBody(), "$.data.length()");
        }
        return count;
    }
}

