/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.resources;

import com.yahoo.elide.async.service.storageengine.ResultStorageEngine;
import io.reactivex.Observable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Path(value="/")
public class ExportApiEndpoint {
    private static final Logger log = LoggerFactory.getLogger(ExportApiEndpoint.class);
    protected final ExportApiProperties exportApiProperties;
    protected final ResultStorageEngine resultStorageEngine;

    @Inject
    public ExportApiEndpoint(@Named(value="resultStorageEngine") ResultStorageEngine resultStorageEngine, @Named(value="exportApiProperties") ExportApiProperties exportApiProperties) {
        this.resultStorageEngine = resultStorageEngine;
        this.exportApiProperties = exportApiProperties;
    }

    @GET
    @Path(value="/{asyncQueryId}")
    public void get(@PathParam(value="asyncQueryId") String asyncQueryId, @Context HttpServletResponse httpServletResponse, @Suspended AsyncResponse asyncResponse) {
        asyncResponse.setTimeout((long)this.exportApiProperties.getMaxDownloadTimeSeconds().intValue(), TimeUnit.SECONDS);
        asyncResponse.setTimeoutHandler(async -> {
            Response.ResponseBuilder resp = Response.status((Response.Status)Response.Status.REQUEST_TIMEOUT).entity((Object)"Timed out.");
            async.resume((Object)resp.build());
        });
        this.exportApiProperties.getExecutor().submit(() -> {
            Observable<String> observableResults = this.resultStorageEngine.getResultsByID(asyncQueryId);
            StreamingOutput streamingOutput = outputStream -> observableResults.subscribe(resultString -> outputStream.write(resultString.concat(System.lineSeparator()).getBytes()), error -> {
                String message = error.getMessage();
                try {
                    log.debug(message);
                    if (message != null && message.equals("Unable to retrieve results.")) {
                        httpServletResponse.sendError(404, asyncQueryId + " Not Found");
                    } else {
                        httpServletResponse.sendError(500);
                    }
                }
                catch (IllegalStateException e) {
                    outputStream.write("Error Occured....".concat(System.lineSeparator()).getBytes());
                    log.debug(e.getMessage());
                }
                finally {
                    outputStream.flush();
                    outputStream.close();
                }
            }, () -> {
                outputStream.flush();
                outputStream.close();
            });
            asyncResponse.resume((Object)Response.ok((Object)streamingOutput, (String)"application/octet-stream").header("Content-Disposition", (Object)("attachment; filename=" + asyncQueryId)).build());
        });
    }

    public static class ExportApiProperties {
        private ExecutorService executor;
        private Integer maxDownloadTimeSeconds;

        public ExecutorService getExecutor() {
            return this.executor;
        }

        public Integer getMaxDownloadTimeSeconds() {
            return this.maxDownloadTimeSeconds;
        }

        public void setExecutor(ExecutorService executor) {
            this.executor = executor;
        }

        public void setMaxDownloadTimeSeconds(Integer maxDownloadTimeSeconds) {
            this.maxDownloadTimeSeconds = maxDownloadTimeSeconds;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExportApiProperties)) {
                return false;
            }
            ExportApiProperties other = (ExportApiProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$maxDownloadTimeSeconds = this.getMaxDownloadTimeSeconds();
            Integer other$maxDownloadTimeSeconds = other.getMaxDownloadTimeSeconds();
            if (this$maxDownloadTimeSeconds == null ? other$maxDownloadTimeSeconds != null : !((Object)this$maxDownloadTimeSeconds).equals(other$maxDownloadTimeSeconds)) {
                return false;
            }
            ExecutorService this$executor = this.getExecutor();
            ExecutorService other$executor = other.getExecutor();
            return !(this$executor == null ? other$executor != null : !this$executor.equals(other$executor));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ExportApiProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $maxDownloadTimeSeconds = this.getMaxDownloadTimeSeconds();
            result = result * 59 + ($maxDownloadTimeSeconds == null ? 43 : ((Object)$maxDownloadTimeSeconds).hashCode());
            ExecutorService $executor = this.getExecutor();
            result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
            return result;
        }

        public String toString() {
            return "ExportApiEndpoint.ExportApiProperties(executor=" + this.getExecutor() + ", maxDownloadTimeSeconds=" + this.getMaxDownloadTimeSeconds() + ")";
        }

        public ExportApiProperties(ExecutorService executor, Integer maxDownloadTimeSeconds) {
            this.executor = executor;
            this.maxDownloadTimeSeconds = maxDownloadTimeSeconds;
        }
    }
}

