/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.service.storageengine;

import com.yahoo.elide.async.models.FileExtensionType;
import com.yahoo.elide.async.models.TableExport;
import com.yahoo.elide.async.models.TableExportResult;
import com.yahoo.elide.async.service.storageengine.ResultStorageEngine;
import io.reactivex.Observable;
import java.util.Iterator;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.UnifiedJedis;

@Singleton
public class RedisResultStorageEngine
implements ResultStorageEngine {
    private static final Logger log = LoggerFactory.getLogger(RedisResultStorageEngine.class);
    private UnifiedJedis jedis;
    private boolean enableExtension;
    private long expirationSeconds;
    private long batchSize;

    public RedisResultStorageEngine(UnifiedJedis jedis, boolean enableExtension, long expirationSeconds, long batchSize) {
        this.jedis = jedis;
        this.enableExtension = enableExtension;
        this.expirationSeconds = expirationSeconds;
        this.batchSize = batchSize;
    }

    @Override
    public TableExportResult storeResults(TableExport tableExport, Observable<String> result) {
        log.debug("store TableExportResults for Download");
        String extension = this.isExtensionEnabled() ? tableExport.getResultType().getFileExtensionType().getExtension() : FileExtensionType.NONE.getExtension();
        TableExportResult exportResult = new TableExportResult();
        String key = tableExport.getId() + extension;
        result.map(record -> record).subscribe(recordCharArray -> this.jedis.rpush(key, new String[]{recordCharArray}), throwable -> {
            StringBuilder message = new StringBuilder();
            message.append(throwable.getClass().getCanonicalName()).append(" : ");
            message.append(throwable.getMessage());
            exportResult.setMessage(message.toString());
            throw new IllegalStateException("Unable to store results.", (Throwable)throwable);
        });
        this.jedis.expire(key, this.expirationSeconds);
        return exportResult;
    }

    @Override
    public Observable<String> getResultsByID(final String tableExportID) {
        log.debug("getTableExportResultsByID");
        final long recordCount = this.jedis.llen(tableExportID);
        if (recordCount == 0L) {
            throw new IllegalStateException("Unable to retrieve results.");
        }
        final long[] recordRead = new long[]{0L};
        return Observable.fromIterable(() -> new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return recordRead[0] < recordCount;
            }

            @Override
            public String next() {
                StringBuilder record = new StringBuilder();
                long end = recordRead[0] + RedisResultStorageEngine.this.batchSize - 1L;
                if (end >= recordCount) {
                    end = recordCount - 1L;
                }
                for (String str : RedisResultStorageEngine.this.jedis.lrange(tableExportID, recordRead[0], end)) {
                    record.append(str).append(System.lineSeparator());
                }
                recordRead[0] = end + 1L;
                return record.substring(0, record.length() - System.lineSeparator().length());
            }
        });
    }

    @Override
    public boolean isExtensionEnabled() {
        return this.enableExtension;
    }

    public UnifiedJedis getJedis() {
        return this.jedis;
    }

    public boolean isEnableExtension() {
        return this.enableExtension;
    }

    public long getExpirationSeconds() {
        return this.expirationSeconds;
    }

    public long getBatchSize() {
        return this.batchSize;
    }

    public void setJedis(UnifiedJedis jedis) {
        this.jedis = jedis;
    }

    public void setEnableExtension(boolean enableExtension) {
        this.enableExtension = enableExtension;
    }

    public void setExpirationSeconds(long expirationSeconds) {
        this.expirationSeconds = expirationSeconds;
    }

    public void setBatchSize(long batchSize) {
        this.batchSize = batchSize;
    }
}

