/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.metadata;

import com.github.jknack.handlebars.EscapingStrategy;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.HandlebarsException;
import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.Template;
import com.yahoo.elide.core.request.Argument;
import com.yahoo.elide.core.utils.TypeHelper;
import com.yahoo.elide.datastores.aggregation.metadata.ColumnSubContext;
import com.yahoo.elide.datastores.aggregation.metadata.MetaDataStore;
import com.yahoo.elide.datastores.aggregation.metadata.PhysicalRefColumnContext;
import com.yahoo.elide.datastores.aggregation.metadata.TableSubContext;
import com.yahoo.elide.datastores.aggregation.query.ColumnProjection;
import com.yahoo.elide.datastores.aggregation.query.Queryable;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.dialects.SQLDialect;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.metadata.SQLJoin;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ColumnContext
extends HashMap<String, Object> {
    public static final String COL_PREFIX = "$$column";
    public static final String TBL_PREFIX = "$$table";
    public static final String ARGS_KEY = "args";
    public static final String EXPR_KEY = "expr";
    public static final String PERIOD = ".";
    protected final MetaDataStore metaDataStore;
    protected final Queryable queryable;
    protected final String alias;
    protected final ColumnProjection column;
    protected final Map<String, Argument> tableArguments;
    private final Handlebars handlebars = new Handlebars().with(EscapingStrategy.NOOP).with((value, next) -> {
        if (value instanceof Argument) {
            return ((Argument)value).getValue();
        }
        return next.format(value);
    }).registerHelper("sql", this::resolveSQLHandlebar);

    @Override
    public Object get(Object key) {
        String keyStr = key.toString();
        if (keyStr.lastIndexOf(36) == 0) {
            return this.resolvePhysicalReference(this, keyStr);
        }
        if (keyStr.equals(TBL_PREFIX)) {
            return TableSubContext.tableSubContextBuilder().tableArguments(this.tableArguments).build();
        }
        if (keyStr.equals(COL_PREFIX)) {
            return ColumnSubContext.columnSubContextBuilder().queryable(this.getQueryable()).alias(this.getAlias()).metaDataStore(this.getMetaDataStore()).column(this.getColumn()).tableArguments(this.getTableArguments()).build();
        }
        if (this.queryable.hasJoin(keyStr)) {
            return this.getJoinContext(keyStr);
        }
        Object value = this.getOrDefault(key, null);
        if (value != null) {
            return value;
        }
        ColumnProjection column = this.getQueryable().getSource().getColumnProjection(keyStr);
        if (column != null) {
            ColumnProjection newColumn = column.withArguments(ColumnContext.mergedArgumentMap(column.getArguments(), this.getColumn().getArguments()));
            return this.getNewContext(this, newColumn).resolve(newColumn.getExpression());
        }
        throw new HandlebarsException(new Throwable("Couldn't find: " + keyStr));
    }

    protected String resolvePhysicalReference(ColumnContext context, String key) {
        String resolvedExpr = context.getAlias() + PERIOD + key.substring(1);
        return ColumnContext.applyQuotes(resolvedExpr, context.getQueryable().getDialect());
    }

    protected ColumnContext getJoinContext(String key) {
        SQLJoin sqlJoin = this.queryable.getJoin(key);
        String joinExpression = sqlJoin.getJoinExpression();
        PhysicalRefColumnContext context = PhysicalRefColumnContext.physicalRefContextBuilder().queryable(this.getQueryable()).metaDataStore(this.getMetaDataStore()).column(this.getColumn()).tableArguments(this.getTableArguments()).build();
        String resolvedJoinExpr = context.resolve(joinExpression);
        String joinAlias = ColumnProjection.createSafeAlias(TypeHelper.appendAlias((String)this.alias, (String)key), resolvedJoinExpr);
        Queryable joinQueryable = (Queryable)this.metaDataStore.getTable(sqlJoin.getJoinTableType());
        ColumnContext joinCtx = ColumnContext.builder().queryable(joinQueryable).alias(joinAlias).metaDataStore(this.metaDataStore).column(this.column).tableArguments(ColumnContext.mergedArgumentMap(joinQueryable.getArguments(), this.getTableArguments())).build();
        return joinCtx;
    }

    protected ColumnContext getNewContext(ColumnContext context, ColumnProjection newColumn) {
        return ColumnContext.builder().queryable(context.getQueryable()).alias(context.getAlias()).metaDataStore(context.getMetaDataStore()).column(newColumn).tableArguments(context.getTableArguments()).build();
    }

    public String resolve(String expression) {
        try {
            Template template = this.handlebars.compileInline(expression);
            return template.apply((Object)this);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    private Object resolveSQLHandlebar(Object context, Options options) throws UnsupportedEncodingException {
        String from = (String)options.hash("from");
        String columnName = (String)options.hash("column");
        int argsIndex = columnName.indexOf(91);
        String invokedColumnName = columnName;
        ColumnContext currentCtx = (ColumnContext)context;
        ColumnContext invokedCtx = StringUtils.isBlank((CharSequence)from) ? currentCtx : (ColumnContext)currentCtx.get(from);
        HashMap<String, Argument> pinnedArgs = new HashMap();
        if (argsIndex >= 0) {
            pinnedArgs = Argument.getArgumentMapFromString((String)columnName.substring(argsIndex));
            invokedColumnName = columnName.substring(0, argsIndex);
        }
        if (invokedColumnName.lastIndexOf(36) == 0) {
            return this.resolvePhysicalReference(invokedCtx, invokedColumnName);
        }
        ColumnProjection column = invokedCtx.getQueryable().getSource().getColumnProjection(invokedColumnName);
        if (column != null) {
            ColumnProjection newColumn = column.withArguments(ColumnContext.mergedArgumentMap(column.getArguments(), invokedCtx.getColumn().getArguments(), pinnedArgs));
            return this.getNewContext(invokedCtx, newColumn).resolve(newColumn.getExpression());
        }
        throw new HandlebarsException(new Throwable("Couldn't find: " + invokedColumnName));
    }

    public static Map<String, Argument> mergedArgumentMap(Map<String, Argument> referencedObjectArgs, Map<String, Argument> callingObjectArgs, Map<String, Argument> fixedArgs) {
        HashMap<String, Argument> columnArgMap = new HashMap<String, Argument>();
        referencedObjectArgs.forEach((argName, arg) -> {
            if (fixedArgs.containsKey(argName)) {
                columnArgMap.put((String)argName, (Argument)fixedArgs.get(argName));
            } else if (callingObjectArgs.containsKey(argName)) {
                columnArgMap.put((String)argName, (Argument)callingObjectArgs.get(argName));
            } else {
                columnArgMap.put((String)argName, (Argument)arg);
            }
        });
        return columnArgMap;
    }

    public static Map<String, Argument> mergedArgumentMap(Map<String, Argument> referencedObjectArgs, Map<String, Argument> callingObjectArgs) {
        return ColumnContext.mergedArgumentMap(referencedObjectArgs, callingObjectArgs, Collections.emptyMap());
    }

    private static String applyQuotes(String str, char beginQuote, char endQuote) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        if (str.contains(PERIOD)) {
            return beginQuote + str.trim().replace(PERIOD, endQuote + PERIOD + beginQuote) + endQuote;
        }
        return beginQuote + str.trim() + endQuote;
    }

    public static String applyQuotes(String str, SQLDialect dialect) {
        return ColumnContext.applyQuotes(str, dialect.getBeginQuote(), dialect.getEndQuote());
    }

    ColumnContext(MetaDataStore metaDataStore, Queryable queryable, String alias, ColumnProjection column, Map<String, Argument> tableArguments) {
        this.metaDataStore = metaDataStore;
        this.queryable = queryable;
        this.alias = alias;
        this.column = column;
        this.tableArguments = tableArguments;
    }

    public static ColumnContextBuilder builder() {
        return new ColumnContextBuilder();
    }

    public MetaDataStore getMetaDataStore() {
        return this.metaDataStore;
    }

    public Queryable getQueryable() {
        return this.queryable;
    }

    public String getAlias() {
        return this.alias;
    }

    public ColumnProjection getColumn() {
        return this.column;
    }

    public Map<String, Argument> getTableArguments() {
        return this.tableArguments;
    }

    public Handlebars getHandlebars() {
        return this.handlebars;
    }

    @Override
    public String toString() {
        return "ColumnContext(metaDataStore=" + this.getMetaDataStore() + ", queryable=" + this.getQueryable() + ", alias=" + this.getAlias() + ", column=" + this.getColumn() + ", tableArguments=" + this.getTableArguments() + ", handlebars=" + this.getHandlebars() + ")";
    }

    public static class ColumnContextBuilder {
        private MetaDataStore metaDataStore;
        private Queryable queryable;
        private String alias;
        private ColumnProjection column;
        private Map<String, Argument> tableArguments;

        ColumnContextBuilder() {
        }

        public ColumnContextBuilder metaDataStore(MetaDataStore metaDataStore) {
            this.metaDataStore = metaDataStore;
            return this;
        }

        public ColumnContextBuilder queryable(Queryable queryable) {
            this.queryable = queryable;
            return this;
        }

        public ColumnContextBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public ColumnContextBuilder column(ColumnProjection column) {
            this.column = column;
            return this;
        }

        public ColumnContextBuilder tableArguments(Map<String, Argument> tableArguments) {
            this.tableArguments = tableArguments;
            return this;
        }

        public ColumnContext build() {
            return new ColumnContext(this.metaDataStore, this.queryable, this.alias, this.column, this.tableArguments);
        }

        public String toString() {
            return "ColumnContext.ColumnContextBuilder(metaDataStore=" + this.metaDataStore + ", queryable=" + this.queryable + ", alias=" + this.alias + ", column=" + this.column + ", tableArguments=" + this.tableArguments + ")";
        }
    }
}

