/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.metadata;

import com.yahoo.elide.core.request.Argument;
import com.yahoo.elide.datastores.aggregation.metadata.ColumnContext;
import com.yahoo.elide.datastores.aggregation.metadata.MetaDataStore;
import com.yahoo.elide.datastores.aggregation.query.ColumnProjection;
import com.yahoo.elide.datastores.aggregation.query.Queryable;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.metadata.SQLJoin;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class PhysicalRefColumnContext
extends ColumnContext {
    private static final String HANDLEBAR_PREFIX = "{{";
    private static final String HANDLEBAR_SUFFIX = "}}";

    public PhysicalRefColumnContext(MetaDataStore metaDataStore, Queryable queryable, String alias, ColumnProjection column, Map<String, Argument> tableArguments) {
        super(metaDataStore, queryable, alias, column, tableArguments);
    }

    @Override
    protected ColumnContext getNewContext(ColumnContext context, ColumnProjection newColumn) {
        return PhysicalRefColumnContext.physicalRefContextBuilder().queryable(context.getQueryable()).alias(context.getAlias()).metaDataStore(context.getMetaDataStore()).column(newColumn).tableArguments(context.getTableArguments()).build();
    }

    @Override
    protected ColumnContext getJoinContext(String key) {
        SQLJoin sqlJoin = this.queryable.getJoin(key);
        Queryable joinQueryable = (Queryable)this.metaDataStore.getTable(sqlJoin.getJoinTableType());
        String joinPath = StringUtils.isBlank((CharSequence)this.alias) ? key : this.alias + "." + key;
        PhysicalRefColumnContext joinCtx = PhysicalRefColumnContext.physicalRefContextBuilder().queryable(joinQueryable).alias(joinPath).metaDataStore(this.metaDataStore).column(this.column).tableArguments(PhysicalRefColumnContext.mergedArgumentMap(joinQueryable.getArguments(), this.getTableArguments())).build();
        return joinCtx;
    }

    @Override
    protected String resolvePhysicalReference(ColumnContext context, String keyStr) {
        return StringUtils.isBlank((CharSequence)context.getAlias()) ? HANDLEBAR_PREFIX + keyStr + HANDLEBAR_SUFFIX : HANDLEBAR_PREFIX + context.getAlias() + "." + keyStr + HANDLEBAR_SUFFIX;
    }

    public static PhysicalRefColumnContextBuilder physicalRefContextBuilder() {
        return new PhysicalRefColumnContextBuilder();
    }

    @Override
    public String toString() {
        return "PhysicalRefColumnContext()";
    }

    public static class PhysicalRefColumnContextBuilder {
        private MetaDataStore metaDataStore;
        private Queryable queryable;
        private String alias;
        private ColumnProjection column;
        private Map<String, Argument> tableArguments;

        PhysicalRefColumnContextBuilder() {
        }

        public PhysicalRefColumnContextBuilder metaDataStore(MetaDataStore metaDataStore) {
            this.metaDataStore = metaDataStore;
            return this;
        }

        public PhysicalRefColumnContextBuilder queryable(Queryable queryable) {
            this.queryable = queryable;
            return this;
        }

        public PhysicalRefColumnContextBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public PhysicalRefColumnContextBuilder column(ColumnProjection column) {
            this.column = column;
            return this;
        }

        public PhysicalRefColumnContextBuilder tableArguments(Map<String, Argument> tableArguments) {
            this.tableArguments = tableArguments;
            return this;
        }

        public PhysicalRefColumnContext build() {
            return new PhysicalRefColumnContext(this.metaDataStore, this.queryable, this.alias, this.column, this.tableArguments);
        }

        public String toString() {
            return "PhysicalRefColumnContext.PhysicalRefColumnContextBuilder(metaDataStore=" + this.metaDataStore + ", queryable=" + this.queryable + ", alias=" + this.alias + ", column=" + this.column + ", tableArguments=" + this.tableArguments + ")";
        }
    }
}

