/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.query;

import com.google.common.collect.Streams;
import com.yahoo.elide.datastores.aggregation.metadata.MetaDataStore;
import com.yahoo.elide.datastores.aggregation.query.DimensionProjection;
import com.yahoo.elide.datastores.aggregation.query.MetricProjection;
import com.yahoo.elide.datastores.aggregation.query.Queryable;
import com.yahoo.elide.datastores.aggregation.query.TimeDimensionProjection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;

public final class QueryPlan
implements Queryable {
    @NonNull
    private final Queryable source;
    @NonNull
    private final List<MetricProjection> metricProjections;
    @NonNull
    private final List<DimensionProjection> dimensionProjections;
    @NonNull
    private final List<TimeDimensionProjection> timeDimensionProjections;

    public QueryPlan merge(QueryPlan other, MetaDataStore metaDataStore) {
        QueryPlan self = this;
        if (other == null) {
            return this;
        }
        while (other.nestDepth() > self.nestDepth()) {
            self = self.nest(metaDataStore);
        }
        while (self.nestDepth() > other.nestDepth()) {
            other = other.nest(metaDataStore);
        }
        assert (self.isNested() || this.getSource().equals(other.getSource()));
        Set metrics = Streams.concat((Stream[])new Stream[]{other.metricProjections.stream(), self.metricProjections.stream()}).collect(Collectors.toCollection(LinkedHashSet::new));
        Set timeDimensions = Streams.concat((Stream[])new Stream[]{other.timeDimensionProjections.stream(), self.timeDimensionProjections.stream()}).collect(Collectors.toCollection(LinkedHashSet::new));
        Set dimensions = Streams.concat((Stream[])new Stream[]{other.dimensionProjections.stream(), self.dimensionProjections.stream()}).collect(Collectors.toCollection(LinkedHashSet::new));
        if (!self.isNested()) {
            return QueryPlan.builder().source(self.getSource()).metricProjections(metrics).dimensionProjections(dimensions).timeDimensionProjections(timeDimensions).build();
        }
        QueryPlan mergedSource = ((QueryPlan)self.getSource()).merge((QueryPlan)other.getSource(), metaDataStore);
        return QueryPlan.builder().source(mergedSource).metricProjections(metrics).dimensionProjections(dimensions).timeDimensionProjections(timeDimensions).build();
    }

    public boolean canNest(MetaDataStore metaDataStore) {
        return this.getColumnProjections().stream().allMatch(projection -> projection.canNest(this.source, metaDataStore));
    }

    public QueryPlan nest(MetaDataStore metaDataStore) {
        if (!this.canNest(metaDataStore)) {
            throw new UnsupportedOperationException("Cannot nest this query plan");
        }
        Set nestedMetrics = this.metricProjections.stream().map(projection -> projection.nest(this.source, metaDataStore, false)).collect(Collectors.toCollection(LinkedHashSet::new));
        Set nestedDimensions = this.dimensionProjections.stream().map(projection -> projection.nest(this.source, metaDataStore, false)).collect(Collectors.toCollection(LinkedHashSet::new));
        Set nestedTimeDimensions = this.timeDimensionProjections.stream().map(projection -> projection.nest(this.source, metaDataStore, false)).collect(Collectors.toCollection(LinkedHashSet::new));
        QueryPlan inner = QueryPlan.builder().source(this.getSource()).metricProjections(nestedMetrics.stream().map(Pair::getRight).flatMap(Collection::stream).map(MetricProjection.class::cast).collect(Collectors.toCollection(LinkedHashSet::new))).dimensionProjections(nestedDimensions.stream().map(Pair::getRight).flatMap(Collection::stream).map(DimensionProjection.class::cast).collect(Collectors.toCollection(LinkedHashSet::new))).timeDimensionProjections(nestedTimeDimensions.stream().map(Pair::getRight).flatMap(Collection::stream).map(TimeDimensionProjection.class::cast).collect(Collectors.toCollection(LinkedHashSet::new))).build();
        return QueryPlan.builder().source(inner).metricProjections(nestedMetrics.stream().map(Pair::getLeft).map(MetricProjection.class::cast).collect(Collectors.toCollection(LinkedHashSet::new))).dimensionProjections(nestedDimensions.stream().map(Pair::getLeft).map(DimensionProjection.class::cast).collect(Collectors.toCollection(LinkedHashSet::new))).timeDimensionProjections(nestedTimeDimensions.stream().map(Pair::getLeft).map(TimeDimensionProjection.class::cast).collect(Collectors.toCollection(LinkedHashSet::new))).build();
    }

    QueryPlan(@NonNull Queryable source, @NonNull List<MetricProjection> metricProjections, @NonNull List<DimensionProjection> dimensionProjections, @NonNull List<TimeDimensionProjection> timeDimensionProjections) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (metricProjections == null) {
            throw new NullPointerException("metricProjections is marked non-null but is null");
        }
        if (dimensionProjections == null) {
            throw new NullPointerException("dimensionProjections is marked non-null but is null");
        }
        if (timeDimensionProjections == null) {
            throw new NullPointerException("timeDimensionProjections is marked non-null but is null");
        }
        this.source = source;
        this.metricProjections = metricProjections;
        this.dimensionProjections = dimensionProjections;
        this.timeDimensionProjections = timeDimensionProjections;
    }

    public static QueryPlanBuilder builder() {
        return new QueryPlanBuilder();
    }

    @Override
    @NonNull
    public Queryable getSource() {
        return this.source;
    }

    @Override
    @NonNull
    public List<MetricProjection> getMetricProjections() {
        return this.metricProjections;
    }

    @Override
    @NonNull
    public List<DimensionProjection> getDimensionProjections() {
        return this.dimensionProjections;
    }

    @Override
    @NonNull
    public List<TimeDimensionProjection> getTimeDimensionProjections() {
        return this.timeDimensionProjections;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryPlan)) {
            return false;
        }
        QueryPlan other = (QueryPlan)o;
        Queryable this$source = this.getSource();
        Queryable other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        List<MetricProjection> this$metricProjections = this.getMetricProjections();
        List<MetricProjection> other$metricProjections = other.getMetricProjections();
        if (this$metricProjections == null ? other$metricProjections != null : !((Object)this$metricProjections).equals(other$metricProjections)) {
            return false;
        }
        List<DimensionProjection> this$dimensionProjections = this.getDimensionProjections();
        List<DimensionProjection> other$dimensionProjections = other.getDimensionProjections();
        if (this$dimensionProjections == null ? other$dimensionProjections != null : !((Object)this$dimensionProjections).equals(other$dimensionProjections)) {
            return false;
        }
        List<TimeDimensionProjection> this$timeDimensionProjections = this.getTimeDimensionProjections();
        List<TimeDimensionProjection> other$timeDimensionProjections = other.getTimeDimensionProjections();
        return !(this$timeDimensionProjections == null ? other$timeDimensionProjections != null : !((Object)this$timeDimensionProjections).equals(other$timeDimensionProjections));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Queryable $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        List<MetricProjection> $metricProjections = this.getMetricProjections();
        result = result * 59 + ($metricProjections == null ? 43 : ((Object)$metricProjections).hashCode());
        List<DimensionProjection> $dimensionProjections = this.getDimensionProjections();
        result = result * 59 + ($dimensionProjections == null ? 43 : ((Object)$dimensionProjections).hashCode());
        List<TimeDimensionProjection> $timeDimensionProjections = this.getTimeDimensionProjections();
        result = result * 59 + ($timeDimensionProjections == null ? 43 : ((Object)$timeDimensionProjections).hashCode());
        return result;
    }

    public String toString() {
        return "QueryPlan(source=" + this.getSource() + ", metricProjections=" + this.getMetricProjections() + ", dimensionProjections=" + this.getDimensionProjections() + ", timeDimensionProjections=" + this.getTimeDimensionProjections() + ")";
    }

    public static class QueryPlanBuilder {
        private Queryable source;
        private ArrayList<MetricProjection> metricProjections;
        private ArrayList<DimensionProjection> dimensionProjections;
        private ArrayList<TimeDimensionProjection> timeDimensionProjections;

        QueryPlanBuilder() {
        }

        public QueryPlanBuilder source(@NonNull Queryable source) {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            this.source = source;
            return this;
        }

        public QueryPlanBuilder metricProjection(MetricProjection metricProjection) {
            if (this.metricProjections == null) {
                this.metricProjections = new ArrayList();
            }
            this.metricProjections.add(metricProjection);
            return this;
        }

        public QueryPlanBuilder metricProjections(Collection<? extends MetricProjection> metricProjections) {
            if (metricProjections == null) {
                throw new NullPointerException("metricProjections cannot be null");
            }
            if (this.metricProjections == null) {
                this.metricProjections = new ArrayList();
            }
            this.metricProjections.addAll(metricProjections);
            return this;
        }

        public QueryPlanBuilder clearMetricProjections() {
            if (this.metricProjections != null) {
                this.metricProjections.clear();
            }
            return this;
        }

        public QueryPlanBuilder dimensionProjection(DimensionProjection dimensionProjection) {
            if (this.dimensionProjections == null) {
                this.dimensionProjections = new ArrayList();
            }
            this.dimensionProjections.add(dimensionProjection);
            return this;
        }

        public QueryPlanBuilder dimensionProjections(Collection<? extends DimensionProjection> dimensionProjections) {
            if (dimensionProjections == null) {
                throw new NullPointerException("dimensionProjections cannot be null");
            }
            if (this.dimensionProjections == null) {
                this.dimensionProjections = new ArrayList();
            }
            this.dimensionProjections.addAll(dimensionProjections);
            return this;
        }

        public QueryPlanBuilder clearDimensionProjections() {
            if (this.dimensionProjections != null) {
                this.dimensionProjections.clear();
            }
            return this;
        }

        public QueryPlanBuilder timeDimensionProjection(TimeDimensionProjection timeDimensionProjection) {
            if (this.timeDimensionProjections == null) {
                this.timeDimensionProjections = new ArrayList();
            }
            this.timeDimensionProjections.add(timeDimensionProjection);
            return this;
        }

        public QueryPlanBuilder timeDimensionProjections(Collection<? extends TimeDimensionProjection> timeDimensionProjections) {
            if (timeDimensionProjections == null) {
                throw new NullPointerException("timeDimensionProjections cannot be null");
            }
            if (this.timeDimensionProjections == null) {
                this.timeDimensionProjections = new ArrayList();
            }
            this.timeDimensionProjections.addAll(timeDimensionProjections);
            return this;
        }

        public QueryPlanBuilder clearTimeDimensionProjections() {
            if (this.timeDimensionProjections != null) {
                this.timeDimensionProjections.clear();
            }
            return this;
        }

        public QueryPlan build() {
            List<TimeDimensionProjection> timeDimensionProjections;
            List<DimensionProjection> dimensionProjections;
            List<MetricProjection> metricProjections;
            switch (this.metricProjections == null ? 0 : this.metricProjections.size()) {
                case 0: {
                    metricProjections = Collections.emptyList();
                    break;
                }
                case 1: {
                    metricProjections = Collections.singletonList(this.metricProjections.get(0));
                    break;
                }
                default: {
                    metricProjections = Collections.unmodifiableList(new ArrayList<MetricProjection>(this.metricProjections));
                }
            }
            switch (this.dimensionProjections == null ? 0 : this.dimensionProjections.size()) {
                case 0: {
                    dimensionProjections = Collections.emptyList();
                    break;
                }
                case 1: {
                    dimensionProjections = Collections.singletonList(this.dimensionProjections.get(0));
                    break;
                }
                default: {
                    dimensionProjections = Collections.unmodifiableList(new ArrayList<DimensionProjection>(this.dimensionProjections));
                }
            }
            switch (this.timeDimensionProjections == null ? 0 : this.timeDimensionProjections.size()) {
                case 0: {
                    timeDimensionProjections = Collections.emptyList();
                    break;
                }
                case 1: {
                    timeDimensionProjections = Collections.singletonList(this.timeDimensionProjections.get(0));
                    break;
                }
                default: {
                    timeDimensionProjections = Collections.unmodifiableList(new ArrayList<TimeDimensionProjection>(this.timeDimensionProjections));
                }
            }
            return new QueryPlan(this.source, metricProjections, dimensionProjections, timeDimensionProjections);
        }

        public String toString() {
            return "QueryPlan.QueryPlanBuilder(source=" + this.source + ", metricProjections=" + this.metricProjections + ", dimensionProjections=" + this.dimensionProjections + ", timeDimensionProjections=" + this.timeDimensionProjections + ")";
        }
    }
}

