/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.queryengines.sql.expression;

import com.yahoo.elide.datastores.aggregation.core.JoinPath;
import com.yahoo.elide.datastores.aggregation.query.Queryable;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.Reference;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.ReferenceVisitor;
import lombok.NonNull;

public final class JoinReference
implements Reference {
    @NonNull
    private final Reference reference;
    @NonNull
    private final Queryable source;
    @NonNull
    private final JoinPath path;

    @Override
    public <T> T accept(ReferenceVisitor<T> visitor) {
        return visitor.visitJoinReference(this);
    }

    JoinReference(@NonNull Reference reference, @NonNull Queryable source, @NonNull JoinPath path) {
        if (reference == null) {
            throw new NullPointerException("reference is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        this.reference = reference;
        this.source = source;
        this.path = path;
    }

    public static JoinReferenceBuilder builder() {
        return new JoinReferenceBuilder();
    }

    @NonNull
    public Reference getReference() {
        return this.reference;
    }

    @NonNull
    public Queryable getSource() {
        return this.source;
    }

    @NonNull
    public JoinPath getPath() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JoinReference)) {
            return false;
        }
        JoinReference other = (JoinReference)o;
        Reference this$reference = this.getReference();
        Reference other$reference = other.getReference();
        if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
            return false;
        }
        Queryable this$source = this.getSource();
        Queryable other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        JoinPath this$path = this.getPath();
        JoinPath other$path = other.getPath();
        return !(this$path == null ? other$path != null : !((Object)((Object)this$path)).equals((Object)other$path));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Reference $reference = this.getReference();
        result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
        Queryable $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        JoinPath $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : ((Object)((Object)$path)).hashCode());
        return result;
    }

    public String toString() {
        return "JoinReference(reference=" + this.getReference() + ", source=" + this.getSource() + ", path=" + this.getPath() + ")";
    }

    public static class JoinReferenceBuilder {
        private Reference reference;
        private Queryable source;
        private JoinPath path;

        JoinReferenceBuilder() {
        }

        public JoinReferenceBuilder reference(@NonNull Reference reference) {
            if (reference == null) {
                throw new NullPointerException("reference is marked non-null but is null");
            }
            this.reference = reference;
            return this;
        }

        public JoinReferenceBuilder source(@NonNull Queryable source) {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            this.source = source;
            return this;
        }

        public JoinReferenceBuilder path(@NonNull JoinPath path) {
            if (path == null) {
                throw new NullPointerException("path is marked non-null but is null");
            }
            this.path = path;
            return this;
        }

        public JoinReference build() {
            return new JoinReference(this.reference, this.source, this.path);
        }

        public String toString() {
            return "JoinReference.JoinReferenceBuilder(reference=" + this.reference + ", source=" + this.source + ", path=" + this.path + ")";
        }
    }
}

