/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.timegrains;

import com.yahoo.elide.core.utils.coerce.converters.ElideTypeConverter;
import com.yahoo.elide.core.utils.coerce.converters.Serde;
import com.yahoo.elide.datastores.aggregation.metadata.enums.TimeGrain;
import com.yahoo.elide.datastores.aggregation.timegrains.Time;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class Day
extends Time {
    public static final String FORMAT = "yyyy-MM-dd";

    public Day(Date date) {
        super(date, true, true, true, false, false, false, Day.getSerializer(TimeGrain.DAY));
    }

    public Day(LocalDateTime date) {
        super(date, true, true, true, false, false, false, Day.getSerializer(TimeGrain.DAY));
    }

    @ElideTypeConverter(type=Day.class, name="Day")
    public static class DaySerde
    implements Serde<Object, Day> {
        public Day deserialize(Object val) {
            if (val instanceof Date) {
                return new Day((Date)val);
            }
            LocalDate localDate = LocalDate.parse(val.toString(), DateTimeFormatter.ISO_LOCAL_DATE);
            LocalDateTime localDateTime = localDate.atTime(0, 0);
            return new Day(localDateTime);
        }

        public String serialize(Day val) {
            return val.serializer.format(val);
        }
    }
}

