/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.jpa;

import com.yahoo.elide.core.datastore.DataStoreTransaction;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.datastores.jpa.transaction.JpaTransaction;
import com.yahoo.elide.datastores.jpql.JPQLDataStore;
import com.yahoo.elide.datastores.jpql.porting.QueryLogger;
import com.yahoo.elide.datastores.jpql.query.DefaultQueryLogger;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.EntityType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaDataStore
implements JPQLDataStore {
    private static final Logger log = LoggerFactory.getLogger(JpaDataStore.class);
    public static final QueryLogger DEFAULT_LOGGER = new DefaultQueryLogger();
    protected final EntityManagerSupplier entityManagerSupplier;
    protected final JpaTransactionSupplier readTransactionSupplier;
    protected final JpaTransactionSupplier writeTransactionSupplier;
    protected final Set<Type<?>> modelsToBind;
    protected final QueryLogger logger;

    public JpaDataStore(EntityManagerSupplier entityManagerSupplier, JpaTransactionSupplier readTransactionSupplier, JpaTransactionSupplier writeTransactionSupplier, QueryLogger logger, Type<?> ... models) {
        this.entityManagerSupplier = entityManagerSupplier;
        this.readTransactionSupplier = readTransactionSupplier;
        this.writeTransactionSupplier = writeTransactionSupplier;
        this.logger = logger;
        this.modelsToBind = new HashSet();
        for (Type<?> model : models) {
            this.modelsToBind.add(model);
        }
    }

    public JpaDataStore(EntityManagerSupplier entityManagerSupplier, JpaTransactionSupplier readTransactionSupplier, JpaTransactionSupplier writeTransactionSupplier, Type<?> ... models) {
        this(entityManagerSupplier, readTransactionSupplier, writeTransactionSupplier, DEFAULT_LOGGER, models);
    }

    public JpaDataStore(EntityManagerSupplier entityManagerSupplier, JpaTransactionSupplier transactionSupplier, Type<?> ... models) {
        this(entityManagerSupplier, transactionSupplier, transactionSupplier, models);
    }

    public void populateEntityDictionary(EntityDictionary dictionary) {
        if (!this.modelsToBind.isEmpty()) {
            this.modelsToBind.forEach(model -> this.bindEntityClass((Type)model, dictionary));
            return;
        }
        for (EntityType type : this.entityManagerSupplier.get().getMetamodel().getEntities()) {
            try {
                ClassType mappedClass = ClassType.of((Class)type.getJavaType());
                dictionary.lookupEntityClass((Type)mappedClass);
                this.bindEntityClass((Type)mappedClass, dictionary);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public DataStoreTransaction beginReadTransaction() {
        EntityManager entityManager = this.entityManagerSupplier.get();
        JpaTransaction transaction = this.readTransactionSupplier.get(entityManager);
        transaction.begin();
        return transaction;
    }

    public DataStoreTransaction beginTransaction() {
        EntityManager entityManager = this.entityManagerSupplier.get();
        JpaTransaction transaction = this.writeTransactionSupplier.get(entityManager);
        transaction.begin();
        return transaction;
    }

    @FunctionalInterface
    public static interface JpaTransactionSupplier {
        public JpaTransaction get(EntityManager var1);
    }

    @FunctionalInterface
    public static interface EntityManagerSupplier {
        public EntityManager get();
    }
}

