/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.noop;

import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.datastore.DataStoreIterable;
import com.yahoo.elide.core.datastore.DataStoreIterableBuilder;
import com.yahoo.elide.core.datastore.DataStoreTransaction;
import com.yahoo.elide.core.request.EntityProjection;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoopTransaction
implements DataStoreTransaction {
    private static final Logger log = LoggerFactory.getLogger(NoopTransaction.class);

    public <T> void save(T entity, RequestScope scope) {
    }

    public <T> void delete(T entity, RequestScope scope) {
    }

    public void flush(RequestScope scope) {
    }

    public void commit(RequestScope scope) {
    }

    public <T> void createObject(T entity, RequestScope scope) {
    }

    public <T> T loadObject(EntityProjection projection, Serializable id, RequestScope scope) {
        Object entity;
        try {
            entity = projection.getType().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error("Could not load object {} through NoopStore", (Object)projection.getType(), (Object)e);
            throw new RuntimeException(e);
        }
        String uuid = scope.getUUIDFor(entity);
        new PersistentResource(entity, uuid, scope).setId(id.toString());
        return (T)entity;
    }

    public <T> DataStoreIterable<T> loadObjects(EntityProjection projection, RequestScope scope) {
        return new DataStoreIterableBuilder(Collections.singletonList(this.loadObject(projection, Long.valueOf(1L), scope))).build();
    }

    public void close() throws IOException {
    }

    public void cancel(RequestScope scope) {
    }
}

