/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.core;

import com.yammer.metrics.core.HealthCheck;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class HealthCheckRegistry {
    private final ConcurrentMap<String, HealthCheck> healthChecks = new ConcurrentHashMap<String, HealthCheck>();

    public void register(HealthCheck healthCheck) {
        this.healthChecks.putIfAbsent(healthCheck.name(), healthCheck);
    }

    public void unregister(String name) {
        this.healthChecks.remove(name);
    }

    public Map<String, HealthCheck.Result> runHealthChecks() {
        TreeMap<String, HealthCheck.Result> results = new TreeMap<String, HealthCheck.Result>();
        for (Map.Entry entry : this.healthChecks.entrySet()) {
            HealthCheck.Result result = ((HealthCheck)entry.getValue()).execute();
            results.put((String)entry.getKey(), result);
        }
        return results;
    }
}

