/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.core;

public class MetricName
implements Comparable<MetricName> {
    private final String group;
    private final String type;
    private final String name;
    private final String scope;
    private final String mbeanName;

    public MetricName(Class<?> klass, String name) {
        this(klass, name, null);
    }

    public MetricName(String group, String type, String name) {
        this(group, type, name, null);
    }

    public MetricName(Class<?> klass, String name, String scope) {
        this(klass.getPackage() == null ? "" : klass.getPackage().getName(), klass.getSimpleName().replaceAll("\\$$", ""), name, scope);
    }

    public MetricName(String group, String type, String name, String scope) {
        this(group, type, name, scope, MetricName.createMBeanName(group, type, name, scope));
    }

    public MetricName(String group, String type, String name, String scope, String mbeanName) {
        if (group == null || type == null) {
            throw new IllegalArgumentException("Both group and type need to be specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name needs to be specified");
        }
        this.group = group;
        this.type = type;
        this.name = name;
        this.scope = scope;
        this.mbeanName = mbeanName;
    }

    public String getGroup() {
        return this.group;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getScope() {
        return this.scope;
    }

    public boolean hasScope() {
        return this.scope != null;
    }

    public String getMBeanName() {
        return this.mbeanName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricName that = (MetricName)o;
        return this.mbeanName.equals(that.mbeanName);
    }

    public int hashCode() {
        return this.mbeanName.hashCode();
    }

    public String toString() {
        return this.mbeanName;
    }

    private static String createMBeanName(String group, String type, String name, String scope) {
        StringBuilder mbeanNameBuilder = new StringBuilder();
        mbeanNameBuilder.append(group);
        mbeanNameBuilder.append(":type=");
        mbeanNameBuilder.append(type);
        if (scope != null) {
            mbeanNameBuilder.append(",scope=");
            mbeanNameBuilder.append(scope);
        }
        if (name.length() > 0) {
            mbeanNameBuilder.append(",name=");
            mbeanNameBuilder.append(name);
        }
        return mbeanNameBuilder.toString();
    }

    @Override
    public int compareTo(MetricName o) {
        return this.mbeanName.compareTo(o.mbeanName);
    }
}

