/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.core;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.MonitorInfo;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadInfo;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class VirtualMachineMetrics {
    private VirtualMachineMetrics() {
    }

    public static double heapUsage() {
        MemoryUsage bean = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        return (double)bean.getUsed() / (double)bean.getMax();
    }

    public static double nonHeapUsage() {
        MemoryUsage bean = ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
        return (double)bean.getUsed() / (double)bean.getMax();
    }

    public static Map<String, Double> memoryPoolUsage() {
        TreeMap<String, Double> pools = new TreeMap<String, Double>();
        for (MemoryPoolMXBean bean : ManagementFactory.getMemoryPoolMXBeans()) {
            double max = bean.getUsage().getMax() == -1L ? (double)bean.getUsage().getCommitted() : (double)bean.getUsage().getMax();
            pools.put(bean.getName(), (double)bean.getUsage().getUsed() / max);
        }
        return pools;
    }

    public static double fileDescriptorUsage() {
        try {
            OperatingSystemMXBean bean = ManagementFactory.getOperatingSystemMXBean();
            Method getOpenFileDescriptorCount = bean.getClass().getDeclaredMethod("getOpenFileDescriptorCount", new Class[0]);
            getOpenFileDescriptorCount.setAccessible(true);
            Long openFds = (Long)getOpenFileDescriptorCount.invoke((Object)bean, new Object[0]);
            Method getMaxFileDescriptorCount = bean.getClass().getDeclaredMethod("getMaxFileDescriptorCount", new Class[0]);
            getMaxFileDescriptorCount.setAccessible(true);
            Long maxFds = (Long)getMaxFileDescriptorCount.invoke((Object)bean, new Object[0]);
            return openFds.doubleValue() / maxFds.doubleValue();
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public static String vmVersion() {
        return System.getProperty("java.runtime.version");
    }

    public static String vmName() {
        return System.getProperty("java.vm.name");
    }

    public static long uptime() {
        return ManagementFactory.getRuntimeMXBean().getUptime() / 1000L;
    }

    public static long threadCount() {
        return ManagementFactory.getThreadMXBean().getThreadCount();
    }

    public static long daemonThreadCount() {
        return ManagementFactory.getThreadMXBean().getDaemonThreadCount();
    }

    public static Map<String, GarbageCollector> garbageCollectors() {
        HashMap<String, GarbageCollector> gcs = new HashMap<String, GarbageCollector>();
        for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
            gcs.put(bean.getName(), new GarbageCollector(bean.getCollectionCount(), bean.getCollectionTime()));
        }
        return gcs;
    }

    public static Set<String> deadlockedThreads() {
        long[] threadIds = ManagementFactory.getThreadMXBean().findDeadlockedThreads();
        if (threadIds != null) {
            ThreadInfo[] infos;
            HashSet<String> threads = new HashSet<String>();
            for (ThreadInfo info : infos = ManagementFactory.getThreadMXBean().getThreadInfo(threadIds, 100)) {
                StringBuilder stackTrace = new StringBuilder();
                for (StackTraceElement element : info.getStackTrace()) {
                    stackTrace.append("\t at ").append(element.toString()).append('\n');
                }
                threads.add(String.format("%s locked on %s (owned by %s):\n%s", info.getThreadName(), info.getLockName(), info.getLockOwnerName(), stackTrace.toString()));
            }
            return threads;
        }
        return Collections.emptySet();
    }

    public static Map<Thread.State, Double> threadStatePercentages() {
        HashMap<Thread.State, Double> conditions = new HashMap<Thread.State, Double>();
        for (Thread.State state : Thread.State.values()) {
            conditions.put(state, 0.0);
        }
        long[] allThreadIds = ManagementFactory.getThreadMXBean().getAllThreadIds();
        ThreadInfo[] allThreads = ManagementFactory.getThreadMXBean().getThreadInfo(allThreadIds);
        int liveCount = 0;
        for (ThreadInfo info : allThreads) {
            if (info == null) continue;
            Thread.State state = info.getThreadState();
            conditions.put(state, (Double)conditions.get((Object)state) + 1.0);
            ++liveCount;
        }
        for (Thread.State state : new ArrayList(conditions.keySet())) {
            conditions.put(state, (Double)conditions.get((Object)state) / (double)liveCount);
        }
        return conditions;
    }

    public static void threadDump(OutputStream out) throws IOException {
        ThreadInfo[] threads = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true);
        PrintWriter writer = new PrintWriter(out, true);
        for (int ti = threads.length - 1; ti > 0; --ti) {
            ThreadInfo t = threads[ti];
            writer.printf("%s id=%d state=%s", new Object[]{t.getThreadName(), t.getThreadId(), t.getThreadState()});
            LockInfo lock = t.getLockInfo();
            if (lock != null && t.getThreadState() != Thread.State.BLOCKED) {
                writer.printf("\n    - waiting on <0x%08x> (a %s)", lock.getIdentityHashCode(), lock.getClassName());
                writer.printf("\n    - locked <0x%08x> (a %s)", lock.getIdentityHashCode(), lock.getClassName());
            } else if (lock != null && t.getThreadState() == Thread.State.BLOCKED) {
                writer.printf("\n    - waiting to lock <0x%08x> (a %s)", lock.getIdentityHashCode(), lock.getClassName());
            }
            if (t.isSuspended()) {
                writer.print(" (suspended)");
            }
            if (t.isInNative()) {
                writer.print(" (running in native)");
            }
            writer.println();
            if (t.getLockOwnerName() != null) {
                writer.printf("     owned by %s id=%d\n", t.getLockOwnerName(), t.getLockOwnerId());
            }
            StackTraceElement[] elements = t.getStackTrace();
            MonitorInfo[] monitors = t.getLockedMonitors();
            for (int i = 0; i < elements.length; ++i) {
                StackTraceElement element = elements[i];
                writer.printf("    at %s\n", element);
                for (int j = 1; j < monitors.length; ++j) {
                    MonitorInfo monitor = monitors[j];
                    if (monitor.getLockedStackDepth() != i) continue;
                    writer.printf("      - locked %s\n", monitor);
                }
            }
            writer.println();
            LockInfo[] locks = t.getLockedSynchronizers();
            if (locks.length <= 0) continue;
            writer.printf("    Locked synchronizers: count = %d\n", locks.length);
            for (LockInfo l : locks) {
                writer.printf("      - %s\n", l);
            }
            writer.println();
        }
        writer.println();
        writer.flush();
    }

    public static class GarbageCollector {
        private final long runs;
        private final long timeMS;

        public GarbageCollector(long runs, long timeMS) {
            this.runs = runs;
            this.timeMS = timeMS;
        }

        public long getRuns() {
            return this.runs;
        }

        public long getTime(TimeUnit unit) {
            return unit.convert(this.timeMS, TimeUnit.MILLISECONDS);
        }
    }
}

