/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.reporting;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Clock;
import com.yammer.metrics.core.CounterMetric;
import com.yammer.metrics.core.GaugeMetric;
import com.yammer.metrics.core.HistogramMetric;
import com.yammer.metrics.core.Metered;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsProcessor;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.TimerMetric;
import com.yammer.metrics.reporting.AbstractPollingReporter;
import com.yammer.metrics.util.MetricPredicate;
import com.yammer.metrics.util.Utils;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class ConsoleReporter
extends AbstractPollingReporter
implements MetricsProcessor<PrintStream> {
    private final PrintStream out;
    private final MetricPredicate predicate;
    private final Clock clock;
    private final TimeZone timeZone;
    private final Locale locale;

    public static void enable(long period, TimeUnit unit) {
        ConsoleReporter.enable(Metrics.defaultRegistry(), period, unit);
    }

    public static void enable(MetricsRegistry metricsRegistry, long period, TimeUnit unit) {
        ConsoleReporter reporter = new ConsoleReporter(metricsRegistry, System.out, MetricPredicate.ALL);
        reporter.start(period, unit);
    }

    public ConsoleReporter(PrintStream out) {
        this(Metrics.defaultRegistry(), out, MetricPredicate.ALL);
    }

    public ConsoleReporter(MetricsRegistry metricsRegistry, PrintStream out, MetricPredicate predicate) {
        this(metricsRegistry, out, predicate, Clock.DEFAULT, TimeZone.getDefault());
    }

    public ConsoleReporter(MetricsRegistry metricsRegistry, PrintStream out, MetricPredicate predicate, Clock clock, TimeZone timeZone) {
        this(metricsRegistry, out, predicate, clock, timeZone, Locale.getDefault());
    }

    public ConsoleReporter(MetricsRegistry metricsRegistry, PrintStream out, MetricPredicate predicate, Clock clock, TimeZone timeZone, Locale locale) {
        super(metricsRegistry, "console-reporter");
        this.out = out;
        this.predicate = predicate;
        this.clock = clock;
        this.timeZone = timeZone;
        this.locale = locale;
    }

    @Override
    public void run() {
        try {
            DateFormat format = DateFormat.getDateTimeInstance(3, 2, this.locale);
            format.setTimeZone(this.timeZone);
            String dateTime = format.format(new Date(this.clock.time()));
            this.out.print(dateTime);
            this.out.print(' ');
            for (int i = 0; i < 80 - dateTime.length() - 1; ++i) {
                this.out.print('=');
            }
            this.out.println();
            for (Map.Entry<String, Map<MetricName, Metric>> entry : Utils.sortAndFilterMetrics(this.metricsRegistry.allMetrics(), this.predicate).entrySet()) {
                this.out.print(entry.getKey());
                this.out.println(':');
                for (Map.Entry<MetricName, Metric> subEntry : entry.getValue().entrySet()) {
                    this.out.print("  ");
                    this.out.print(subEntry.getKey().getName());
                    this.out.println(':');
                    subEntry.getValue().processWith(this, subEntry.getKey(), this.out);
                    this.out.println();
                }
                this.out.println();
            }
            this.out.println();
            this.out.flush();
        }
        catch (Exception e) {
            e.printStackTrace(this.out);
        }
    }

    @Override
    public void processGauge(MetricName name, GaugeMetric<?> gauge, PrintStream stream) {
        stream.printf(this.locale, "    value = %s\n", gauge.value());
    }

    @Override
    public void processCounter(MetricName name, CounterMetric counter, PrintStream stream) {
        stream.printf(this.locale, "    count = %d\n", counter.count());
    }

    @Override
    public void processMeter(MetricName name, Metered meter, PrintStream stream) {
        String unit = this.abbrev(meter.rateUnit());
        stream.printf(this.locale, "             count = %d\n", meter.count());
        stream.printf(this.locale, "         mean rate = %2.2f %s/%s\n", meter.meanRate(), meter.eventType(), unit);
        stream.printf(this.locale, "     1-minute rate = %2.2f %s/%s\n", meter.oneMinuteRate(), meter.eventType(), unit);
        stream.printf(this.locale, "     5-minute rate = %2.2f %s/%s\n", meter.fiveMinuteRate(), meter.eventType(), unit);
        stream.printf(this.locale, "    15-minute rate = %2.2f %s/%s\n", meter.fifteenMinuteRate(), meter.eventType(), unit);
    }

    @Override
    public void processHistogram(MetricName name, HistogramMetric histogram, PrintStream stream) {
        Double[] percentiles = histogram.percentiles(0.5, 0.75, 0.95, 0.98, 0.99, 0.999);
        stream.printf(this.locale, "               min = %2.2f\n", histogram.min());
        stream.printf(this.locale, "               max = %2.2f\n", histogram.max());
        stream.printf(this.locale, "              mean = %2.2f\n", histogram.mean());
        stream.printf(this.locale, "            stddev = %2.2f\n", histogram.stdDev());
        stream.printf(this.locale, "            median = %2.2f\n", percentiles[0]);
        stream.printf(this.locale, "              75%% <= %2.2f\n", percentiles[1]);
        stream.printf(this.locale, "              95%% <= %2.2f\n", percentiles[2]);
        stream.printf(this.locale, "              98%% <= %2.2f\n", percentiles[3]);
        stream.printf(this.locale, "              99%% <= %2.2f\n", percentiles[4]);
        stream.printf(this.locale, "            99.9%% <= %2.2f\n", percentiles[5]);
    }

    @Override
    public void processTimer(MetricName name, TimerMetric timer, PrintStream stream) {
        this.processMeter(name, (Metered)timer, stream);
        String durationUnit = this.abbrev(timer.durationUnit());
        Double[] percentiles = timer.percentiles(0.5, 0.75, 0.95, 0.98, 0.99, 0.999);
        stream.printf(this.locale, "               min = %2.2f%s\n", timer.min(), durationUnit);
        stream.printf(this.locale, "               max = %2.2f%s\n", timer.max(), durationUnit);
        stream.printf(this.locale, "              mean = %2.2f%s\n", timer.mean(), durationUnit);
        stream.printf(this.locale, "            stddev = %2.2f%s\n", timer.stdDev(), durationUnit);
        stream.printf(this.locale, "            median = %2.2f%s\n", percentiles[0], durationUnit);
        stream.printf(this.locale, "              75%% <= %2.2f%s\n", percentiles[1], durationUnit);
        stream.printf(this.locale, "              95%% <= %2.2f%s\n", percentiles[2], durationUnit);
        stream.printf(this.locale, "              98%% <= %2.2f%s\n", percentiles[3], durationUnit);
        stream.printf(this.locale, "              99%% <= %2.2f%s\n", percentiles[4], durationUnit);
        stream.printf(this.locale, "            99.9%% <= %2.2f%s\n", percentiles[5], durationUnit);
    }

    private String abbrev(TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "us";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "m";
            }
            case HOURS: {
                return "h";
            }
            case DAYS: {
                return "d";
            }
        }
        throw new IllegalArgumentException("Unrecognized TimeUnit: " + (Object)((Object)unit));
    }
}

