/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.reporting;

import com.yammer.metrics.core.Clock;
import com.yammer.metrics.core.CounterMetric;
import com.yammer.metrics.core.GaugeMetric;
import com.yammer.metrics.core.HistogramMetric;
import com.yammer.metrics.core.Metered;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsProcessor;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.TimerMetric;
import com.yammer.metrics.reporting.AbstractPollingReporter;
import com.yammer.metrics.util.MetricPredicate;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class CsvReporter
extends AbstractPollingReporter
implements MetricsProcessor<Context> {
    private final MetricPredicate predicate;
    private final File outputDir;
    private final Map<MetricName, PrintStream> streamMap;
    private final Clock clock;
    private long startTime;

    public CsvReporter(File outputDir, MetricsRegistry metricsRegistry, MetricPredicate predicate) throws Exception {
        this(outputDir, metricsRegistry, predicate, Clock.DEFAULT);
    }

    public CsvReporter(File outputDir, MetricsRegistry metricsRegistry, MetricPredicate predicate, Clock clock) throws Exception {
        super(metricsRegistry, "csv-reporter");
        this.outputDir = outputDir;
        this.predicate = predicate;
        this.streamMap = new HashMap<MetricName, PrintStream>();
        this.startTime = 0L;
        this.clock = clock;
    }

    public CsvReporter(File outputDir, MetricsRegistry metricsRegistry) throws Exception {
        this(outputDir, metricsRegistry, MetricPredicate.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrintStream getPrintStream(MetricName metricName, String header) throws IOException {
        PrintStream stream;
        Map<MetricName, PrintStream> map = this.streamMap;
        synchronized (map) {
            stream = this.streamMap.get(metricName);
            if (stream == null) {
                stream = this.createStreamForMetric(metricName);
                this.streamMap.put(metricName, stream);
                stream.println(header);
            }
        }
        return stream;
    }

    protected PrintStream createStreamForMetric(MetricName metricName) throws IOException {
        File newFile = new File(this.outputDir, metricName.getName() + ".csv");
        if (newFile.createNewFile()) {
            return new PrintStream(new FileOutputStream(newFile));
        }
        throw new IOException("Unable to create " + newFile);
    }

    @Override
    public void run() {
        final long time = (this.clock.time() - this.startTime) / 1000L;
        Set<Map.Entry<MetricName, Metric>> metrics = this.metricsRegistry.allMetrics().entrySet();
        try {
            for (Map.Entry<MetricName, Metric> entry : metrics) {
                Metric metric;
                final MetricName metricName = entry.getKey();
                if (!this.predicate.matches(metricName, metric = entry.getValue())) continue;
                Context context = new Context(){

                    @Override
                    public PrintStream getStream(String header) throws IOException {
                        PrintStream stream = CsvReporter.this.getPrintStream(metricName, header);
                        stream.print(time);
                        stream.print(',');
                        return stream;
                    }
                };
                metric.processWith(this, entry.getKey(), context);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processMeter(MetricName name, Metered meter, Context context) throws IOException {
        PrintStream stream = context.getStream("# time,count,1 min rate,mean rate,5 min rate,15 min rate");
        stream.append("" + meter.count() + ',' + meter.oneMinuteRate() + ',' + meter.meanRate() + ',' + meter.fiveMinuteRate() + ',' + meter.fifteenMinuteRate()).println();
        stream.flush();
    }

    @Override
    public void processCounter(MetricName name, CounterMetric counter, Context context) throws IOException {
        PrintStream stream = context.getStream("# time,count");
        stream.println(counter.count());
        stream.flush();
    }

    @Override
    public void processHistogram(MetricName name, HistogramMetric histogram, Context context) throws IOException {
        PrintStream stream = context.getStream("# time,min,max,mean,median,stddev,90%,95%,99%");
        Double[] percentiles = histogram.percentiles(0.5, 0.9, 0.95, 0.99);
        stream.append("" + histogram.min() + ',' + histogram.max() + ',' + histogram.mean() + ',' + percentiles[0] + ',' + histogram.stdDev() + ',' + percentiles[1] + ',' + percentiles[2] + ',' + percentiles[3]).println();
        stream.println();
        stream.flush();
    }

    @Override
    public void processTimer(MetricName name, TimerMetric timer, Context context) throws IOException {
        PrintStream stream = context.getStream("# time,min,max,mean,median,stddev,90%,95%,99%");
        Double[] percentiles = timer.percentiles(0.5, 0.9, 0.95, 0.99);
        stream.append("" + timer.min() + ',' + timer.max() + ',' + timer.mean() + ',' + percentiles[0] + ',' + timer.stdDev() + ',' + percentiles[1] + ',' + percentiles[2] + ',' + percentiles[3]).println();
        stream.flush();
    }

    @Override
    public void processGauge(MetricName name, GaugeMetric<?> gauge, Context context) throws IOException {
        PrintStream stream = context.getStream("# time,value");
        stream.println(gauge.value());
        stream.flush();
    }

    @Override
    public void start(long period, TimeUnit unit) {
        this.startTime = this.clock.time();
        super.start(period, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        try {
            super.shutdown();
        }
        finally {
            for (PrintStream out : this.streamMap.values()) {
                out.close();
            }
        }
    }

    public static interface Context {
        public PrintStream getStream(String var1) throws IOException;
    }
}

