/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.util;

import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.util.MetricPredicate;
import com.yammer.metrics.util.ThreadPools;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ScheduledExecutorService;

public class Utils {
    private static final ThreadPools THREAD_POOLS = new ThreadPools();

    private Utils() {
    }

    public static Map<String, Map<MetricName, Metric>> sortMetrics(Map<MetricName, Metric> metrics) {
        return Utils.sortAndFilterMetrics(metrics, MetricPredicate.ALL);
    }

    public static Map<MetricName, Metric> filterMetrics(Map<MetricName, Metric> metrics, MetricPredicate predicate) {
        HashMap<MetricName, Metric> result = new HashMap<MetricName, Metric>();
        for (Map.Entry<MetricName, Metric> entry : metrics.entrySet()) {
            if (!predicate.matches(entry.getKey(), entry.getValue())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static Map<String, Map<MetricName, Metric>> sortAndFilterMetrics(Map<MetricName, Metric> metrics, MetricPredicate predicate) {
        TreeMap<String, Map<MetricName, Metric>> sortedMetrics = new TreeMap<String, Map<MetricName, Metric>>();
        for (Map.Entry<MetricName, Metric> entry : metrics.entrySet()) {
            String qualifiedTypeName = entry.getKey().getGroup() + "." + entry.getKey().getType();
            if (!predicate.matches(entry.getKey(), entry.getValue())) continue;
            String scopedName = entry.getKey().hasScope() ? qualifiedTypeName + "." + entry.getKey().getScope() : qualifiedTypeName;
            TreeMap<MetricName, Metric> subMetrics = (TreeMap<MetricName, Metric>)sortedMetrics.get(scopedName);
            if (subMetrics == null) {
                subMetrics = new TreeMap<MetricName, Metric>();
                sortedMetrics.put(scopedName, subMetrics);
            }
            subMetrics.put(entry.getKey(), entry.getValue());
        }
        return sortedMetrics;
    }

    public static ScheduledExecutorService newScheduledThreadPool(int poolSize, String name) {
        return THREAD_POOLS.newScheduledThreadPool(poolSize, name);
    }

    public static void shutdownThreadPools() {
        THREAD_POOLS.shutdownThreadPools();
    }
}

