/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.jdbi.strategies;

import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.jdbi.strategies.DelegatingStatementNameStrategy;
import com.yammer.metrics.jdbi.strategies.NameStrategies;
import com.yammer.metrics.jdbi.strategies.StatementName;
import com.yammer.metrics.jdbi.strategies.StatementNameStrategy;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.skife.jdbi.v2.StatementContext;

public final class ShortNameStrategy
extends DelegatingStatementNameStrategy {
    private final ConcurrentMap<String, String> shortClassNames = new ConcurrentHashMap<String, String>();
    private final String baseJmxName;

    public ShortNameStrategy(String baseJmxName) {
        super(new StatementNameStrategy[0]);
        this.baseJmxName = baseJmxName;
        this.registerStrategies(NameStrategies.CHECK_EMPTY, new ShortContextClassStrategy(), new ShortSqlObjectStrategy(), NameStrategies.CHECK_RAW, NameStrategies.NAIVE_NAME);
    }

    private final class ShortSqlObjectStrategy
    implements StatementNameStrategy {
        private ShortSqlObjectStrategy() {
        }

        @Override
        public MetricName getStatementName(StatementContext statementContext) {
            Class clazz = statementContext.getSqlObjectType();
            Method method = statementContext.getSqlObjectMethod();
            if (clazz != null && method != null) {
                String className = clazz.getName();
                String statementName = method.getName();
                int dotPos = className.lastIndexOf(46);
                if (dotPos == -1) {
                    return null;
                }
                String shortName = className.substring(dotPos + 1);
                String oldClassName = ShortNameStrategy.this.shortClassNames.putIfAbsent(shortName, className);
                if (oldClassName == null || oldClassName.equals(className)) {
                    return StatementName.getJmxSafeName(ShortNameStrategy.this.baseJmxName, shortName, statementName);
                }
                return StatementName.getJmxSafeName(ShortNameStrategy.this.baseJmxName, className, statementName);
            }
            return null;
        }
    }

    private final class ShortContextClassStrategy
    implements StatementNameStrategy {
        private ShortContextClassStrategy() {
        }

        @Override
        public MetricName getStatementName(StatementContext statementContext) {
            Object classObj = statementContext.getAttribute("_metric_class");
            Object nameObj = statementContext.getAttribute("_metric_name");
            if (classObj == null || nameObj == null) {
                return null;
            }
            String className = (String)classObj;
            String statementName = (String)nameObj;
            int dotPos = className.lastIndexOf(46);
            if (dotPos == -1) {
                return null;
            }
            String shortName = className.substring(dotPos + 1);
            String oldClassName = ShortNameStrategy.this.shortClassNames.putIfAbsent(shortName, className);
            if (oldClassName == null || oldClassName.equals(className)) {
                return StatementName.getJmxSafeName(ShortNameStrategy.this.baseJmxName, shortName, statementName);
            }
            return StatementName.getJmxSafeName(ShortNameStrategy.this.baseJmxName, className, statementName);
        }
    }
}

