/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.jdbi.strategies;

import com.yammer.metrics.core.MetricName;
import java.util.regex.Pattern;

public class StatementName {
    private static final Pattern JMX_SAFE_CHARS = Pattern.compile("[^a-zA-Z0-9_\\.-]");

    public static MetricName getJmxSafeName(String groupName, String typeName, String statementName) {
        return new MetricName(StatementName.getJmxSafeName(groupName), StatementName.getJmxSafeName(typeName), StatementName.getJmxSafeName(statementName));
    }

    private static String getJmxSafeName(String name) {
        String result = JMX_SAFE_CHARS.matcher(name).replaceAll("_");
        if (result == null || result.length() == 0) {
            return "";
        }
        return Character.isDigit(result.charAt(0)) ? "_" + result : result;
    }
}

