/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.api;

import com.yodlee.sdk.client.ApiClient;
import com.yodlee.sdk.client.ApiListener;
import com.yodlee.sdk.client.ProgressRequestBody;
import com.yodlee.sdk.client.ProgressResponseBody;
import com.yodlee.sdk.context.Context;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;

public abstract class AbstractApi {
    protected Context<?> context;
    private final List<ApiListener> apiListeners = new CopyOnWriteArrayList<ApiListener>();
    private final Map<String, String> requestHeaderMap = new HashMap<String, String>();

    public AbstractApi(Context<?> context) {
        this.context = context;
    }

    public Context<?> getContext() {
        return this.context;
    }

    public void setContext(Context<?> context) {
        this.context = context;
    }

    public boolean addRequestHeader(String headerKey, String headerValue) {
        if (headerKey == null || headerValue == null) {
            return false;
        }
        this.requestHeaderMap.put(headerKey, headerValue);
        return true;
    }

    public boolean removeRequestHeader(String headerkey) {
        if (headerkey == null) {
            return false;
        }
        this.requestHeaderMap.remove(headerkey);
        return true;
    }

    public void clearRequestHeaderMap() {
        this.requestHeaderMap.clear();
    }

    public String getRequestHeaderKey(String headerkey) {
        return this.requestHeaderMap.get(headerkey);
    }

    public Map<String, String> getRequestHeaderMap() {
        return Collections.unmodifiableMap(this.requestHeaderMap);
    }

    public void setRequestHeaderMap(Map<String, String> requestHeaderMap) {
        this.requestHeaderMap.clear();
        Set<Map.Entry<String, String>> entrySet = requestHeaderMap.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            if (entry.getKey() != null && entry.getValue() != null) continue;
        }
    }

    public boolean addApiListener(ApiListener listener) {
        if (listener == null) {
            return false;
        }
        return this.apiListeners.add(listener);
    }

    public boolean removeApiListener(ApiListener listener) {
        return this.apiListeners.remove(listener);
    }

    public void clearApiListeners() {
        this.apiListeners.clear();
    }

    protected void registerResponseInterceptor(ApiClient apiClient) {
        if (apiClient.shouldRegisterNetworkInterceptor()) {
            final ProgressResponseBody.ProgressListener progressListener = (bytesRead, contentLength, done) -> this.fireResponseUpdate(bytesRead, contentLength, done);
            Interceptor interceptor = new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            };
            apiClient.registerNetworkInterceptor(interceptor);
        }
    }

    protected ProgressRequestBody.ProgressRequestListener requestListener() {
        return (bytesWritten, contentLength, done) -> this.fireRequestUpdate(bytesWritten, contentLength, done);
    }

    protected String replacePathVariable(String endPoint, String pathVariable, String value) {
        Map<String, String> requestHeaderMap = this.getRequestHeaderMap();
        return endPoint.replaceAll("\\{" + pathVariable + "\\}", this.getContext().getApiClient(requestHeaderMap).escapeString(value));
    }

    private void fireResponseUpdate(long bytesRead, long contentLength, boolean done) {
        for (ApiListener apiListener : this.apiListeners) {
            apiListener.responseUpdate(bytesRead, contentLength, done);
        }
    }

    private void fireRequestUpdate(long bytesWritten, long contentLength, boolean done) {
        for (ApiListener apiListener : this.apiListeners) {
            apiListener.requestUpdate(bytesWritten, contentLength, done);
        }
    }
}

