/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.api;

import com.yodlee.api.model.AbstractModelComponent;
import com.yodlee.api.model.account.enums.ItemAccountStatus;
import com.yodlee.api.model.account.request.CreateAccountRequest;
import com.yodlee.api.model.account.request.EvaluateAddressRequest;
import com.yodlee.api.model.account.request.UpdateAccountRequest;
import com.yodlee.api.model.account.response.AccountBalanceResponse;
import com.yodlee.api.model.account.response.AccountHistoricalBalancesResponse;
import com.yodlee.api.model.account.response.AccountMigrationResponse;
import com.yodlee.api.model.account.response.AccountResponse;
import com.yodlee.api.model.account.response.AssociatedAccountsResponse;
import com.yodlee.api.model.account.response.CreatedAccountResponse;
import com.yodlee.api.model.account.response.EvaluateAddressResponse;
import com.yodlee.api.model.enums.Container;
import com.yodlee.sdk.api.AbstractApi;
import com.yodlee.sdk.api.exception.ApiException;
import com.yodlee.sdk.api.util.ApiUtils;
import com.yodlee.sdk.api.validators.AccountsValidator;
import com.yodlee.sdk.client.ApiCallback;
import com.yodlee.sdk.client.ApiClient;
import com.yodlee.sdk.client.ApiContext;
import com.yodlee.sdk.client.ApiResponse;
import com.yodlee.sdk.client.CallContext;
import com.yodlee.sdk.client.HttpMethod;
import com.yodlee.sdk.client.Pair;
import com.yodlee.sdk.context.Context;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import okhttp3.Call;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountsApi
extends AbstractApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccountsApi.class);
    private static final String PARAM_TOP = "top";
    private static final String PARAM_SKIP = "skip";
    private static final String PARAM_INTERVAL = "interval";
    private static final String PARAM_INCLUDE_CF = "includeCF";
    private static final String PARAM_FROM_DATE = "fromDate";
    private static final String PARAM_TO_DATE = "toDate";
    private static final String PARAM_STATUS = "status";
    private static final String PARAM_REQUEST_ID = "requestId";
    private static final String PARAM_PROVIDER_ACCOUNT_ID = "providerAccountId";
    private static final String PARAM_INCLUDE = "include";
    private static final String PARAM_ACCOUNT_ID = "accountId";
    private static final String PARAM_CONTAINER = "container";

    public AccountsApi(Context<?> context) {
        super(context);
    }

    public ApiResponse<AccountResponse> getAccount(@Digits(integer=11, fraction=0, message="{accounts.param.accountId.invalid}") @Min(value=1L, message="{accounts.param.accountId.invalid}") long accountId, AccountsValidator.IncludeParameterValue[] include) throws ApiException {
        LOGGER.info("Accounts getAccount API execution started");
        AccountsValidator.validateGetAccount(this, ApiUtils.getMethodName(), accountId, include);
        CallContext callContext = this.buildGetAccountContext(accountId, include, null);
        return callContext.getApiClient().execute(callContext.getCall(), AccountResponse.class);
    }

    public ApiResponse<AccountResponse> getAccount(@Digits(integer=11, fraction=0, message="{accounts.param.accountId.invalid}") @Min(value=1L, message="{accounts.param.accountId.invalid}") long accountId, AccountsValidator.IncludeParameterValue[] include, Map<String, String> headers) throws ApiException {
        LOGGER.info("Accounts getAccountwithGzip API execution started");
        String contentEncodingValue = headers.get("Accept-Encoding");
        AccountsValidator.validateGetAccount(this, ApiUtils.getMethodName(), accountId, include);
        CallContext callContext = this.buildGetAccountContext(accountId, include, contentEncodingValue);
        return callContext.getApiClient().execute(callContext.getCall(), AccountResponse.class);
    }

    public void getAccountAsync(@Digits(integer=11, fraction=0, message="{accounts.param.accountId.invalid}") @Min(value=1L, message="{accounts.param.accountId.invalid}") long accountId, AccountsValidator.IncludeParameterValue[] include, ApiCallback<AccountResponse> apiCallback) throws ApiException {
        LOGGER.info("Accounts getAccountAsync API execution started");
        AccountsValidator.validateGetAccount(this, ApiUtils.getMethodName(), accountId, include);
        CallContext callContext = this.buildGetAccountContext(accountId, include, null);
        callContext.getApiClient().executeAsync(callContext.getCall(), AccountResponse.class, apiCallback);
    }

    private CallContext buildGetAccountContext(long accountId, AccountsValidator.IncludeParameterValue[] include, String contentEncoding) throws ApiException {
        String endPoint = this.replacePathVariable("/accounts/{accountId}", PARAM_ACCOUNT_ID, String.valueOf(accountId));
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext(endPoint, HttpMethod.GET, null);
        if (include != null) {
            apiContext.addQueryParam(new Pair(PARAM_INCLUDE, ApiUtils.convertArrayToString((Object[])include)));
        }
        if (contentEncoding != null) {
            apiContext.addHeaderParam("Accept-Encoding", contentEncoding);
        }
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<AccountResponse> getAllAccounts(@Size(min=0, max=100, message="{accounts.param.accountId.length.invalid}") Long[] accountId, Container container, AccountsValidator.IncludeParameterValue[] include, @Size(min=0, max=100, message="{accounts.param.providerAccountId.length.invalid}") Long[] providerAccountId, String requestId, ItemAccountStatus[] status) throws ApiException {
        LOGGER.info("Accounts getAllAccounts API execution started");
        AccountsValidator.validateGetAllAccounts(this, ApiUtils.getMethodName(), accountId, container, include, providerAccountId, requestId, status);
        CallContext callContext = this.buildAllAccountsContext(accountId, container, include, providerAccountId, requestId, status, null);
        return callContext.getApiClient().execute(callContext.getCall(), AccountResponse.class);
    }

    public ApiResponse<AccountResponse> getAllAccounts(@Size(min=0, max=100, message="{accounts.param.accountId.length.invalid}") Long[] accountId, Container container, AccountsValidator.IncludeParameterValue[] include, @Size(min=0, max=100, message="{accounts.param.providerAccountId.length.invalid}") Long[] providerAccountId, String requestId, ItemAccountStatus[] status, Map<String, String> headers) throws ApiException {
        LOGGER.info("Accounts getAllAccounts API execution started");
        String contentEncodingValue = headers.get("Accept-Encoding");
        AccountsValidator.validateGetAllAccounts(this, ApiUtils.getMethodName(), accountId, container, include, providerAccountId, requestId, status);
        CallContext callContext = this.buildAllAccountsContext(accountId, container, include, providerAccountId, requestId, status, contentEncodingValue);
        return callContext.getApiClient().execute(callContext.getCall(), AccountResponse.class);
    }

    public void getAllAccountsAsync(@Size(min=0, max=100, message="{accounts.param.accountId.length.invalid}") Long[] accountId, Container container, AccountsValidator.IncludeParameterValue[] include, @Size(min=0, max=100, message="{accounts.param.providerAccountId.length.invalid}") Long[] providerAccountId, String requestId, ItemAccountStatus[] status, ApiCallback<AccountResponse> apiCallback) throws ApiException {
        LOGGER.info("Accounts getAllAccountsAsync API execution started");
        AccountsValidator.validateGetAllAccounts(this, ApiUtils.getMethodName(), accountId, container, include, providerAccountId, requestId, status);
        CallContext callContext = this.buildAllAccountsContext(accountId, container, include, providerAccountId, requestId, status, null);
        callContext.getApiClient().executeAsync(callContext.getCall(), AccountResponse.class, apiCallback);
    }

    private CallContext buildAllAccountsContext(Long[] accountId, Container container, AccountsValidator.IncludeParameterValue[] include, Long[] providerAccountId, String requestId, ItemAccountStatus[] status, String contentEncoding) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/accounts", HttpMethod.GET, null);
        if (accountId != null) {
            apiContext.addQueryParam(new Pair(PARAM_ACCOUNT_ID, ApiUtils.convertArrayToString((Object[])accountId)));
        }
        if (container != null) {
            apiContext.addQueryParam(new Pair(PARAM_CONTAINER, container.name()));
        }
        if (include != null) {
            apiContext.addQueryParam(new Pair(PARAM_INCLUDE, ApiUtils.convertArrayToString((Object[])include)));
        }
        if (providerAccountId != null) {
            apiContext.addQueryParam(new Pair(PARAM_PROVIDER_ACCOUNT_ID, ApiUtils.convertArrayToString((Object[])providerAccountId)));
        }
        if (!StringUtils.isEmpty((CharSequence)requestId)) {
            apiContext.addQueryParam(new Pair(PARAM_REQUEST_ID, requestId));
        }
        if (status != null) {
            apiContext.addQueryParam(new Pair(PARAM_STATUS, ApiUtils.convertArrayToString(status)));
        }
        if (contentEncoding != null) {
            apiContext.addHeaderParam("Accept-Encoding", contentEncoding);
        }
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<AccountHistoricalBalancesResponse> getHistoricalBalances(@Digits(integer=11, fraction=0, message="{accounts.param.accountId.invalid}") @Min(value=1L, message="{accounts.param.accountId.invalid}") Long accountId, Date toDate, Date fromDate, Boolean includeCF, AccountsValidator.HistoricalBalancesIntervalValue interval, @Min(value=0L, message="{accounts.param.skip.invalid}") Integer skip, @Min(value=1L, message="{accounts.param.top.invalid}") @Max(value=500L, message="{accounts.param.top.invalid}") Integer top) throws ApiException {
        LOGGER.info("Accounts getHistoricalBalances API execution started");
        AccountsValidator.validateGetHistoricalBalances(this, ApiUtils.getMethodName(), accountId, toDate, fromDate, includeCF, interval, skip, top);
        CallContext callContext = this.buildGetHistoricalBalancesContext(accountId, toDate, fromDate, includeCF, interval, skip, top);
        return callContext.getApiClient().execute(callContext.getCall(), AccountHistoricalBalancesResponse.class);
    }

    public void getHistoricalBalancesAsync(@Digits(integer=11, fraction=0, message="{accounts.param.accountId.invalid}") @Min(value=1L, message="{accounts.param.accountId.invalid}") Long accountId, Date toDate, Date fromDate, Boolean includeCF, AccountsValidator.HistoricalBalancesIntervalValue interval, @Min(value=0L, message="{accounts.param.skip.invalid}") Integer skip, @Min(value=1L, message="{accounts.param.top.invalid}") @Max(value=500L, message="{accounts.param.top.invalid}") Integer top, ApiCallback<AccountHistoricalBalancesResponse> apiCallback) throws ApiException {
        LOGGER.info("Accounts getHistoricalBalancesAsync API execution started");
        AccountsValidator.validateGetHistoricalBalances(this, ApiUtils.getMethodName(), accountId, toDate, fromDate, includeCF, interval, skip, top);
        CallContext callContext = this.buildGetHistoricalBalancesContext(accountId, toDate, fromDate, includeCF, interval, skip, top);
        callContext.getApiClient().executeAsync(callContext.getCall(), AccountHistoricalBalancesResponse.class, apiCallback);
    }

    private CallContext buildGetHistoricalBalancesContext(Long accountId, Date toDate, Date fromDate, Boolean includeCF, AccountsValidator.HistoricalBalancesIntervalValue interval, Integer skip, Integer top) throws ApiException {
        String formattedFromDate;
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/accounts/historicalBalances", HttpMethod.GET, null);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        if (accountId != null) {
            apiContext.addQueryParam(new Pair(PARAM_ACCOUNT_ID, accountId.toString()));
        }
        if (toDate != null) {
            formattedFromDate = formatter.format(toDate);
            apiContext.addQueryParam(new Pair(PARAM_TO_DATE, formattedFromDate));
        }
        if (fromDate != null) {
            formattedFromDate = formatter.format(fromDate);
            apiContext.addQueryParam(new Pair(PARAM_FROM_DATE, formattedFromDate));
        }
        if (includeCF != null) {
            apiContext.addQueryParam(new Pair(PARAM_INCLUDE_CF, includeCF.toString()));
        }
        if (interval != null) {
            apiContext.addQueryParam(new Pair(PARAM_INTERVAL, interval.name()));
        }
        if (skip != null) {
            apiContext.addQueryParam(new Pair(PARAM_SKIP, skip.toString()));
        }
        if (top != null) {
            apiContext.addQueryParam(new Pair(PARAM_TOP, top.toString()));
        }
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<CreatedAccountResponse> createManualAccount(@NotNull(message="{accounts.manualAccountInfo.required}") CreateAccountRequest accountParam) throws ApiException {
        LOGGER.info("Accounts createManualAccount API execution started");
        AccountsValidator.validateCreateManualAccount(this, ApiUtils.getMethodName(), accountParam);
        CallContext callContext = this.buildcreateManualAccountContext(accountParam);
        return callContext.getApiClient().execute(callContext.getCall(), CreatedAccountResponse.class);
    }

    public void createManualAccountAsync(@NotNull(message="{accounts.manualAccountInfo.required}") CreateAccountRequest accountParam, ApiCallback<CreatedAccountResponse> apiCallback) throws ApiException {
        LOGGER.info("Accounts createManualAccountAsync API execution started");
        AccountsValidator.validateCreateManualAccount(this, ApiUtils.getMethodName(), accountParam);
        CallContext callContext = this.buildcreateManualAccountContext(accountParam);
        callContext.getApiClient().executeAsync(callContext.getCall(), CreatedAccountResponse.class, apiCallback);
    }

    private CallContext buildcreateManualAccountContext(CreateAccountRequest accountParam) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/accounts", HttpMethod.POST, accountParam);
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<AbstractModelComponent> updateAccount(@Digits(integer=11, fraction=0, message="{accounts.param.accountId.invalid}") long accountId, @NotNull(message="{accounts.accountInfo.required}") UpdateAccountRequest accountRequest) throws ApiException {
        LOGGER.info("Accounts updateAccount API execution started");
        AccountsValidator.validateUpdateAccount(this, ApiUtils.getMethodName(), accountId, accountRequest);
        CallContext callContext = this.buildUpdateAccountContext(accountId, accountRequest);
        return callContext.getApiClient().execute(callContext.getCall(), null);
    }

    public void updateAccountAsync(@Digits(integer=11, fraction=0, message="{accounts.param.accountId.invalid}") long accountId, @NotNull(message="{accounts.accountInfo.required}") UpdateAccountRequest accountRequest, ApiCallback<AbstractModelComponent> apiCallback) throws ApiException {
        LOGGER.info("Accounts updateAccountAsync API execution started");
        AccountsValidator.validateUpdateAccount(this, ApiUtils.getMethodName(), accountId, accountRequest);
        CallContext callContext = this.buildUpdateAccountContext(accountId, accountRequest);
        callContext.getApiClient().executeAsync(callContext.getCall(), apiCallback);
    }

    private CallContext buildUpdateAccountContext(long accountId, UpdateAccountRequest accountRequest) throws ApiException {
        String endpoint = this.replacePathVariable("/accounts/{accountId}", PARAM_ACCOUNT_ID, String.valueOf(accountId));
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext(endpoint, HttpMethod.PUT, accountRequest);
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<AbstractModelComponent> deleteAccount(@Digits(integer=11, fraction=0, message="{accounts.param.accountId.invalid}") long accountId) throws ApiException {
        LOGGER.info("Accounts deleteAccount API execution started");
        AccountsValidator.validateDeleteAccount(this, ApiUtils.getMethodName(), accountId);
        CallContext callContext = this.buildDeleteAccountContext(accountId);
        return callContext.getApiClient().execute(callContext.getCall(), null);
    }

    public void deleteAccountAsync(@Digits(integer=11, fraction=0, message="{accounts.param.accountId.invalid}") long accountId, ApiCallback<AbstractModelComponent> apiCallback) throws ApiException {
        LOGGER.info("Accounts deleteAccountAsync API execution started");
        AccountsValidator.validateDeleteAccount(this, ApiUtils.getMethodName(), accountId);
        CallContext callContext = this.buildDeleteAccountContext(accountId);
        callContext.getApiClient().executeAsync(callContext.getCall(), apiCallback);
    }

    private CallContext buildDeleteAccountContext(long accountId) throws ApiException {
        String endpoint = this.replacePathVariable("/accounts/{accountId}", PARAM_ACCOUNT_ID, String.valueOf(accountId));
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext(endpoint, HttpMethod.DELETE, null);
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<EvaluateAddressResponse> evaluateAddress(@NotNull(message="{evaluateAddress.address.required}") EvaluateAddressRequest evaluateAddressRequest) throws ApiException {
        LOGGER.info("Evaluate Address API execution started");
        AccountsValidator.validateEvaluateAddress(this, ApiUtils.getMethodName(), evaluateAddressRequest);
        CallContext callContext = this.buildEvaluateAddressContext(evaluateAddressRequest);
        return callContext.getApiClient().execute(callContext.getCall(), EvaluateAddressResponse.class);
    }

    public void evaluateAddressAsync(@NotNull(message="{evaluateAddress.address.required}") EvaluateAddressRequest evaluateAddressRequest, ApiCallback<AbstractModelComponent> apiCallback) throws ApiException {
        LOGGER.info("Evaluate Address Async API execution started");
        AccountsValidator.validateEvaluateAddress(this, ApiUtils.getMethodName(), evaluateAddressRequest);
        CallContext callContext = this.buildEvaluateAddressContext(evaluateAddressRequest);
        callContext.getApiClient().executeAsync(callContext.getCall(), apiCallback);
    }

    private CallContext buildEvaluateAddressContext(EvaluateAddressRequest evaluateAddressRequest) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/accounts/evaluateAddress", HttpMethod.POST, evaluateAddressRequest);
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<AccountMigrationResponse> migrateAccounts(@Digits(integer=11, fraction=0, message="{accounts.param.providerAccountId.invalid}") long providerAccountId) throws ApiException {
        LOGGER.info("Accounts migrateAccounts API execution started");
        AccountsValidator.validateMigrateAccounts(this, ApiUtils.getMethodName(), providerAccountId);
        CallContext callContext = this.buildMigrateAccountsContext(providerAccountId);
        return callContext.getApiClient().execute(callContext.getCall(), AccountMigrationResponse.class);
    }

    public void migrateAccountsAsync(@Digits(integer=11, fraction=0, message="{accounts.param.providerAccountId.invalid}") long providerAccountId, ApiCallback<AbstractModelComponent> apiCallback) throws ApiException {
        LOGGER.info("Accounts migrateAccountsAsync API execution started");
        AccountsValidator.validateMigrateAccounts(this, ApiUtils.getMethodName(), providerAccountId);
        CallContext callContext = this.buildMigrateAccountsContext(providerAccountId);
        callContext.getApiClient().executeAsync(callContext.getCall(), apiCallback);
    }

    private CallContext buildMigrateAccountsContext(long providerAccountId) throws ApiException {
        String endpoint = this.replacePathVariable("/accounts/migrateAccounts/{providerAccountId}", PARAM_PROVIDER_ACCOUNT_ID, String.valueOf(providerAccountId));
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext(endpoint, HttpMethod.PUT, null);
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<AssociatedAccountsResponse> getAssociatedAccounts(@Digits(integer=11, fraction=0, message="{accounts.param.providerAccountId.invalid}") long providerAccountId) throws ApiException {
        LOGGER.info("Accounts getAssociatedAccounts API execution started");
        AccountsValidator.validateAssociatedAccounts(this, ApiUtils.getMethodName(), providerAccountId);
        CallContext callContext = this.buildAssociatedAccountsContext(providerAccountId);
        return callContext.getApiClient().execute(callContext.getCall(), AssociatedAccountsResponse.class);
    }

    public void getAssociatedAccountsAsync(@Digits(integer=11, fraction=0, message="{accounts.param.providerAccountId.invalid}") long providerAccountId, ApiCallback<AbstractModelComponent> apiCallback) throws ApiException {
        LOGGER.info("Accounts getAssociatedAccountsAsync API execution started");
        AccountsValidator.validateAssociatedAccounts(this, ApiUtils.getMethodName(), providerAccountId);
        CallContext callContext = this.buildAssociatedAccountsContext(providerAccountId);
        callContext.getApiClient().executeAsync(callContext.getCall(), apiCallback);
    }

    private CallContext buildAssociatedAccountsContext(long providerAccountId) throws ApiException {
        String endpoint = this.replacePathVariable("/accounts/associatedAccounts/{providerAccountId}", PARAM_PROVIDER_ACCOUNT_ID, String.valueOf(providerAccountId));
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext(endpoint, HttpMethod.GET, null);
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<AccountBalanceResponse> getAccountBalance(@Size(min=0, max=10, message="{accounts.param.accountId.length.invalid}") @NotEmpty(message="{accounts.param.accountId.required}") Long[] accountId, @Digits(integer=11, fraction=0, message="{accounts.param.providerAccountId.invalid}") @NotNull(message="{providerAccounts.param.providerAccountId.required}") long providerAccountId) throws ApiException {
        LOGGER.info("Accounts getAccountBal API execution started");
        AccountsValidator.validateAccountBalance(this, ApiUtils.getMethodName(), accountId, providerAccountId);
        CallContext callContext = this.buildAccountBalanceContext(accountId, providerAccountId);
        return callContext.getApiClient().execute(callContext.getCall(), AccountBalanceResponse.class);
    }

    public void getAccountBalanceAsync(@Size(min=0, max=10, message="{accounts.param.accountId.length.invalid}") @NotEmpty(message="{accounts.param.accountId.required}") Long[] accountId, @Digits(integer=11, fraction=0, message="{accounts.param.providerAccountId.invalid}") @NotNull(message="{providerAccounts.param.providerAccountId.required}") long providerAccountId, ApiCallback<AccountBalanceResponse> apiCallback) throws ApiException {
        LOGGER.info("Accounts getAccountBal API execution started");
        AccountsValidator.validateAccountBalance(this, ApiUtils.getMethodName(), accountId, providerAccountId);
        CallContext callContext = this.buildAccountBalanceContext(accountId, providerAccountId);
        callContext.getApiClient().executeAsync(callContext.getCall(), AccountBalanceResponse.class, apiCallback);
    }

    private CallContext buildAccountBalanceContext(Long[] accountId, long providerAccountId) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/accounts/latestBalances", HttpMethod.GET, null);
        apiContext.addQueryParam(new Pair(PARAM_ACCOUNT_ID, ApiUtils.convertArrayToString((Object[])accountId)));
        apiContext.addQueryParam(new Pair(PARAM_PROVIDER_ACCOUNT_ID, String.valueOf(providerAccountId)));
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }
}

