/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.api;

import com.yodlee.api.model.AbstractModelComponent;
import com.yodlee.api.model.auth.request.ApiKeyRequest;
import com.yodlee.api.model.auth.response.ApiKeyResponse;
import com.yodlee.api.model.clientcredential.ClientCredentialToken;
import com.yodlee.api.model.clientcredential.response.ClientCredentialTokenResponse;
import com.yodlee.sdk.api.AbstractApi;
import com.yodlee.sdk.api.exception.ApiException;
import com.yodlee.sdk.api.util.ApiUtils;
import com.yodlee.sdk.api.validators.AuthValidator;
import com.yodlee.sdk.client.ApiCallback;
import com.yodlee.sdk.client.ApiClient;
import com.yodlee.sdk.client.ApiContext;
import com.yodlee.sdk.client.ApiResponse;
import com.yodlee.sdk.client.CallContext;
import com.yodlee.sdk.client.HttpMethod;
import com.yodlee.sdk.configuration.cobrand.AbstractClientCredentialConfiguration;
import com.yodlee.sdk.configuration.cobrand.ClientCredentialAdminConfiguration;
import com.yodlee.sdk.configuration.user.ClientCredentialUserConfiguration;
import com.yodlee.sdk.context.ClientCredentialAdminContext;
import com.yodlee.sdk.context.ClientCredentialUserContext;
import com.yodlee.sdk.context.Context;
import javax.validation.constraints.NotNull;
import okhttp3.Call;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthApi
extends AbstractApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthApi.class);
    private static final String PARAM_API_KEY = "key";
    private final AbstractClientCredentialConfiguration clientCredentialConfiguration;

    public AuthApi() {
        this(null, null);
    }

    public AuthApi(AbstractClientCredentialConfiguration clientCredentialConfiguration) {
        this(null, clientCredentialConfiguration);
    }

    public AuthApi(Context<?> context) {
        this(context, null);
    }

    public AuthApi(Context<?> context, AbstractClientCredentialConfiguration clientCredentialConfiguration) {
        super(context);
        this.clientCredentialConfiguration = clientCredentialConfiguration;
    }

    public ApiResponse<AbstractModelComponent> deleteToken() throws ApiException {
        LOGGER.info("Auth deleteToken API execution started");
        CallContext callContext = this.buildDeleteTokenContext();
        return callContext.getApiClient().execute(callContext.getCall(), null);
    }

    public void deleteTokenAsync(ApiCallback<AbstractModelComponent> apiCallBack) throws ApiException {
        LOGGER.info("Auth deleteTokenAsync API execution started");
        CallContext callContext = this.buildDeleteTokenContext();
        callContext.getApiClient().executeAsync(callContext.getCall(), apiCallBack);
    }

    private CallContext buildDeleteTokenContext() throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/auth/token", HttpMethod.DELETE, null);
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<ApiKeyResponse> generateApiKey(@NotNull(message="{auth.apiKeyRequest.required}") ApiKeyRequest apiKeyRequest) throws ApiException {
        LOGGER.info("Auth generateApiKey API execution started");
        AuthValidator.validateGenerateApiKey(this, ApiUtils.getMethodName(), apiKeyRequest);
        CallContext callContext = this.buildGenerateApiKeyContext(apiKeyRequest);
        return callContext.getApiClient().execute(callContext.getCall(), ApiKeyResponse.class);
    }

    public void generateApiKeyAsync(@NotNull(message="{auth.apiKeyRequest.required}") ApiKeyRequest apiKeyRequest, ApiCallback<ApiKeyResponse> apiCallback) throws ApiException {
        LOGGER.info("AuthAsync generateApiKeyAsync API execution started");
        AuthValidator.validateGenerateApiKey(this, ApiUtils.getMethodName(), apiKeyRequest);
        CallContext callContext = this.buildGenerateApiKeyContext(apiKeyRequest);
        callContext.getApiClient().executeAsync(callContext.getCall(), ApiKeyResponse.class, apiCallback);
    }

    private CallContext buildGenerateApiKeyContext(ApiKeyRequest apiKeyRequest) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/auth/apiKey", HttpMethod.POST, apiKeyRequest);
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<ApiKeyResponse> getApiKeys() throws ApiException {
        LOGGER.info("Auth getApiKeys API execution started");
        AuthValidator.validateContext(this);
        CallContext callContext = this.buildGetApiKeysContext();
        return callContext.getApiClient().execute(callContext.getCall(), ApiKeyResponse.class);
    }

    public void getApiKeysAsync(ApiCallback<ApiKeyResponse> apiCallback) throws ApiException {
        LOGGER.info("Auth getApiKeysAsync API execution started");
        AuthValidator.validateContext(this);
        CallContext callContext = this.buildGetApiKeysContext();
        callContext.getApiClient().executeAsync(callContext.getCall(), ApiKeyResponse.class, apiCallback);
    }

    private CallContext buildGetApiKeysContext() throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/auth/apiKey", HttpMethod.GET, null);
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<AbstractModelComponent> deleteApiKey(@NotEmpty(message="{auth.param.apiKey.required}") String key) throws ApiException {
        LOGGER.info("Auth deleteApiKey API execution started");
        AuthValidator.validateDeleteApiKey(this, ApiUtils.getMethodName(), key);
        CallContext callContext = this.buildDeleteApiKeyContext(key);
        return callContext.getApiClient().execute(callContext.getCall(), null);
    }

    public void deleteApiKeyAsync(@NotEmpty(message="{auth.param.apiKey.required}") String key, ApiCallback<AbstractModelComponent> apiCallback) throws ApiException {
        LOGGER.info("Auth deleteApiKeyAsync API execution started");
        AuthValidator.validateDeleteApiKey(this, ApiUtils.getMethodName(), key);
        CallContext callContext = this.buildDeleteApiKeyContext(key);
        callContext.getApiClient().executeAsync(callContext.getCall(), apiCallback);
    }

    private CallContext buildDeleteApiKeyContext(@NotEmpty(message="{auth.param.apiKey.required}") String key) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        String endpoint = this.replacePathVariable("/auth/apiKey/{key}", PARAM_API_KEY, key);
        ApiContext apiContext = new ApiContext(endpoint, HttpMethod.DELETE, null);
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<ClientCredentialTokenResponse> generateAccessToken() throws ApiException {
        Call call;
        ApiContext apiContext = this.generateAccessTokenApiContext();
        ApiClient apiClient = this.getApiClient();
        ApiResponse<ClientCredentialTokenResponse> clientCredentialTokenResponse = apiClient.execute(call = apiClient.buildCall(apiContext, null), ClientCredentialTokenResponse.class);
        if (clientCredentialTokenResponse != null && clientCredentialTokenResponse.getData() != null) {
            ClientCredentialToken token = clientCredentialTokenResponse.getData().getToken();
            this.setContext(this.createContext(token));
        }
        return clientCredentialTokenResponse;
    }

    private Context<?> createContext(ClientCredentialToken token) {
        if (token != null) {
            if (this.clientCredentialConfiguration instanceof ClientCredentialAdminConfiguration) {
                return new ClientCredentialAdminContext(token.getAccessToken(), token.getIssuedAt(), token.getExpiresIn(), (ClientCredentialAdminConfiguration)this.clientCredentialConfiguration);
            }
            if (this.clientCredentialConfiguration instanceof ClientCredentialUserConfiguration) {
                return new ClientCredentialUserContext(token.getAccessToken(), token.getIssuedAt(), token.getExpiresIn(), (ClientCredentialUserConfiguration)this.clientCredentialConfiguration);
            }
        }
        return null;
    }

    private ApiContext generateAccessTokenApiContext() {
        ApiContext apiContext = new ApiContext("/auth/token", HttpMethod.POST, null);
        apiContext.clearHeaderParams();
        apiContext.addHeaderParam("Api-Version", this.clientCredentialConfiguration.getApiVersion());
        apiContext.addHeaderParam("Content-Type", "application/x-www-form-urlencoded");
        apiContext.addHeaderParam("loginName", this.clientCredentialConfiguration.getLoginName());
        apiContext.addFormParam("clientId", this.clientCredentialConfiguration.getClientId());
        apiContext.addFormParam("secret", this.clientCredentialConfiguration.getSecret());
        return apiContext;
    }

    private ApiClient getApiClient() {
        ApiClient apiClient = new ApiClient();
        apiClient.setBasePath(this.clientCredentialConfiguration.getBasePath());
        apiClient.addHeader("Api-Version", this.clientCredentialConfiguration.getApiVersion());
        if (this.clientCredentialConfiguration.getLocale() != null) {
            apiClient.addHeader("locale", this.clientCredentialConfiguration.getLocale());
        }
        if (this.clientCredentialConfiguration.getSocketTimeout() != null) {
            apiClient.setConnectTimeout(this.clientCredentialConfiguration.getSocketTimeout());
        }
        if (this.clientCredentialConfiguration.getReadTimeout() != null) {
            apiClient.setReadTimeout(this.clientCredentialConfiguration.getReadTimeout());
        }
        if (this.clientCredentialConfiguration.getWriteTimeout() != null) {
            apiClient.setWriteTimeout(this.clientCredentialConfiguration.getWriteTimeout());
        }
        return apiClient;
    }
}

