/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.api;

import com.yodlee.api.model.AbstractModelComponent;
import com.yodlee.api.model.cobrand.enums.CobrandNotificationEventType;
import com.yodlee.api.model.cobrand.request.CobrandLoginRequest;
import com.yodlee.api.model.cobrand.request.CreateCobrandNotificationEventRequest;
import com.yodlee.api.model.cobrand.request.UpdateCobrandNotificationEventRequest;
import com.yodlee.api.model.cobrand.response.CobrandLoginResponse;
import com.yodlee.api.model.cobrand.response.CobrandNotificationResponse;
import com.yodlee.api.model.cobrand.response.CobrandPublicKeyResponse;
import com.yodlee.sdk.api.AbstractApi;
import com.yodlee.sdk.api.exception.ApiException;
import com.yodlee.sdk.api.util.ApiUtils;
import com.yodlee.sdk.api.validators.CobrandValidator;
import com.yodlee.sdk.client.ApiCallback;
import com.yodlee.sdk.client.ApiClient;
import com.yodlee.sdk.client.ApiContext;
import com.yodlee.sdk.client.ApiResponse;
import com.yodlee.sdk.client.CallContext;
import com.yodlee.sdk.client.HttpMethod;
import com.yodlee.sdk.client.Pair;
import com.yodlee.sdk.configuration.cobrand.CobrandConfiguration;
import com.yodlee.sdk.context.CobrandContext;
import com.yodlee.sdk.context.Context;
import javax.validation.constraints.NotNull;
import okhttp3.Call;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CobrandApi
extends AbstractApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(CobrandApi.class);
    private static final String PARAM_EVENT_NAME = "eventName";
    private final CobrandConfiguration cobrandConfiguration;

    public CobrandApi() {
        this(null, null);
    }

    public CobrandApi(CobrandConfiguration cobrandConfiguration) {
        this(null, cobrandConfiguration);
    }

    public CobrandApi(Context<?> context, CobrandConfiguration cobrandConfiguration) {
        super(context);
        this.cobrandConfiguration = cobrandConfiguration;
    }

    public ApiResponse<CobrandLoginResponse> cobrandLogin(@NotNull(message="{cobrand.required}") CobrandLoginRequest cobrandLoginRequest) throws ApiException {
        LOGGER.info("Cobrand cobrandLogin API execution started");
        CobrandValidator.validateCobrandLogin(this, ApiUtils.getMethodName(), cobrandLoginRequest);
        CallContext callContext = this.buildCobrandLoginContext(cobrandLoginRequest);
        ApiResponse<CobrandLoginResponse> cobrandLoginResponse = callContext.getApiClient().execute(callContext.getCall(), CobrandLoginResponse.class);
        String cobSession = cobrandLoginResponse.getData().getSession().getCobSession();
        CobrandContext cobrandContext = new CobrandContext(cobSession, this.cobrandConfiguration);
        this.setContext(cobrandContext);
        LOGGER.info("Cobrand cobrandLogin API execution ended and set the CobrandContext");
        return cobrandLoginResponse;
    }

    public void cobrandLoginAsync(@NotNull(message="{cobrand.required}") CobrandLoginRequest cobrandLoginRequest, ApiCallback<CobrandLoginResponse> apiCallBack) throws ApiException {
        LOGGER.info("Cobrand cobrandLoginAsync API execution started");
        CobrandValidator.validateCobrandLogin(this, ApiUtils.getMethodName(), cobrandLoginRequest);
        CallContext callContext = this.buildCobrandLoginContext(cobrandLoginRequest);
        callContext.getApiClient().executeAsync(callContext.getCall(), CobrandLoginResponse.class, apiCallBack);
    }

    private CallContext buildCobrandLoginContext(CobrandLoginRequest cobrandLoginRequest) throws ApiException {
        ApiContext apiContext = new ApiContext("/cobrand/login", HttpMethod.POST, cobrandLoginRequest);
        ApiClient apiClient = this.getApiClient();
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<AbstractModelComponent> cobrandLogout() throws ApiException {
        LOGGER.info("Cobrand Logout API execution started");
        CobrandValidator.validateApiContext(this);
        CallContext callContext = this.buildCobrandLogoutContext();
        return callContext.getApiClient().execute(callContext.getCall(), null);
    }

    public void cobrandLogoutAsync(ApiCallback<AbstractModelComponent> apiCallBack) throws ApiException {
        LOGGER.info("Cobrand cobrandLogoutAsync API execution started");
        CobrandValidator.validateApiContext(this);
        CallContext callContext = this.buildCobrandLogoutContext();
        callContext.getApiClient().executeAsync(callContext.getCall(), apiCallBack);
    }

    private CallContext buildCobrandLogoutContext() throws ApiException {
        ApiContext apiContext = new ApiContext("/cobrand/logout", HttpMethod.POST, null);
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    @Deprecated
    public ApiResponse<AbstractModelComponent> createSubscriptionEvent(@NotNull(message="{cobrand.param.eventName.required}") CobrandNotificationEventType eventName, @NotNull(message="{cobrand.CreateCobrandNotificationEventRequest.required}") CreateCobrandNotificationEventRequest eventRequest) throws ApiException {
        LOGGER.info("Cobrand createSubscriptionEvent API execution started");
        CobrandValidator.validateCreateSubscriptionEvent(this, ApiUtils.getMethodName(), eventName, eventRequest);
        CallContext callContext = this.buildCreateSubscriptionEventContext(eventName, eventRequest);
        return callContext.getApiClient().execute(callContext.getCall(), null);
    }

    @Deprecated
    public void createSubscriptionEventAsync(@NotNull(message="{cobrand.param.eventName.required}") CobrandNotificationEventType eventName, @NotNull(message="{cobrand.CreateCobrandNotificationEventRequest.required}") CreateCobrandNotificationEventRequest eventRequest, ApiCallback<AbstractModelComponent> apiCallBack) throws ApiException {
        LOGGER.info("Cobrand createSubscriptionEventAsync API execution started");
        CobrandValidator.validateCreateSubscriptionEvent(this, ApiUtils.getMethodName(), eventName, eventRequest);
        CallContext callContext = this.buildCreateSubscriptionEventContext(eventName, eventRequest);
        callContext.getApiClient().executeAsync(callContext.getCall(), apiCallBack);
    }

    private CallContext buildCreateSubscriptionEventContext(CobrandNotificationEventType eventName, CreateCobrandNotificationEventRequest eventRequest) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        String endPoint = this.replacePathVariable("/cobrand/config/notifications/events/{eventName}", PARAM_EVENT_NAME, eventName.toString());
        ApiContext apiContext = new ApiContext(endPoint, HttpMethod.POST, eventRequest);
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    @Deprecated
    public ApiResponse<AbstractModelComponent> updateSubscribedEvent(@NotNull(message="{cobrand.param.eventName.required}") CobrandNotificationEventType eventName, @NotNull(message="{cobrand.UpdateCobrandNotificationEventRequest.required}") UpdateCobrandNotificationEventRequest eventRequest) throws ApiException {
        LOGGER.info("Cobrand updateSubscribedEvent API execution started");
        CobrandValidator.validateUpdateSubscribedEvent(this, ApiUtils.getMethodName(), eventName, eventRequest);
        CallContext callContext = this.buildUpdateSubscribedEventContext(eventName, eventRequest);
        return callContext.getApiClient().execute(callContext.getCall(), null);
    }

    @Deprecated
    public void updateSubscribedEventAsync(@NotNull(message="{cobrand.param.eventName.required}") CobrandNotificationEventType eventName, @NotNull(message="{cobrand.UpdateCobrandNotificationEventRequest.required}") UpdateCobrandNotificationEventRequest eventRequest, ApiCallback<AbstractModelComponent> apiCallback) throws ApiException {
        LOGGER.info("Cobrand updateSubscribedEventAsync API execution started");
        CobrandValidator.validateUpdateSubscribedEvent(this, ApiUtils.getMethodName(), eventName, eventRequest);
        CallContext callContext = this.buildUpdateSubscribedEventContext(eventName, eventRequest);
        callContext.getApiClient().executeAsync(callContext.getCall(), apiCallback);
    }

    private CallContext buildUpdateSubscribedEventContext(CobrandNotificationEventType eventName, UpdateCobrandNotificationEventRequest eventRequest) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        String endPoint = this.replacePathVariable("/cobrand/config/notifications/events/{eventName}", PARAM_EVENT_NAME, eventName.toString());
        ApiContext apiContext = new ApiContext(endPoint, HttpMethod.PUT, eventRequest);
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    @Deprecated
    public ApiResponse<AbstractModelComponent> deleteSubscribedEvent(@NotNull(message="{cobrand.param.eventName.required}") CobrandNotificationEventType eventName) throws ApiException {
        LOGGER.info("Cobrand deleteSubscribedEvent API execution started");
        CobrandValidator.validateDeleteSubscribedEvent(this, ApiUtils.getMethodName(), eventName);
        CallContext callContext = this.buildDeleteSubscribedEventContext(eventName);
        return callContext.getApiClient().execute(callContext.getCall(), null);
    }

    @Deprecated
    public void deleteSubscribedEventAsync(@NotNull(message="{cobrand.param.eventName.required}") CobrandNotificationEventType eventName, ApiCallback<AbstractModelComponent> apiCallback) throws ApiException {
        LOGGER.info("Cobrand deleteSubscribedEventAsync API execution started");
        CobrandValidator.validateDeleteSubscribedEvent(this, ApiUtils.getMethodName(), eventName);
        CallContext callContext = this.buildDeleteSubscribedEventContext(eventName);
        callContext.getApiClient().executeAsync(callContext.getCall(), apiCallback);
    }

    private CallContext buildDeleteSubscribedEventContext(CobrandNotificationEventType eventName) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        String endPoint = this.replacePathVariable("/cobrand/config/notifications/events/{eventName}", PARAM_EVENT_NAME, eventName.toString());
        ApiContext apiContext = new ApiContext(endPoint, HttpMethod.DELETE, null);
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    @Deprecated
    public ApiResponse<CobrandPublicKeyResponse> getPublicKey() throws ApiException {
        LOGGER.info("Cobrand getPublicKey API execution started");
        CobrandValidator.validateApiContext(this);
        CallContext callContext = this.buildGetPublicKeyContext();
        return callContext.getApiClient().execute(callContext.getCall(), CobrandPublicKeyResponse.class);
    }

    @Deprecated
    public void getPublicKeyAsync(ApiCallback<CobrandPublicKeyResponse> apiCallback) throws ApiException {
        LOGGER.info("Cobrand getPublicKeyAsync API execution started");
        CobrandValidator.validateApiContext(this);
        CallContext callContext = this.buildGetPublicKeyContext();
        callContext.getApiClient().executeAsync(callContext.getCall(), CobrandPublicKeyResponse.class, apiCallback);
    }

    private CallContext buildGetPublicKeyContext() throws ApiException {
        ApiContext apiContext = new ApiContext("/cobrand/publicKey", HttpMethod.GET, null);
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    @Deprecated
    public ApiResponse<CobrandNotificationResponse> getSubscribedEvents(CobrandNotificationEventType eventName) throws ApiException {
        LOGGER.info("Cobrand getPublicKey API execution started");
        CobrandValidator.validateApiContext(this);
        CallContext callContext = this.buildGetSubscribedEventsContext(eventName);
        return callContext.getApiClient().execute(callContext.getCall(), CobrandNotificationResponse.class);
    }

    @Deprecated
    public void getSubscribedEventsAsync(CobrandNotificationEventType eventName, ApiCallback<CobrandNotificationResponse> apiCallback) throws ApiException {
        LOGGER.info("Cobrand getPublicKeyAsync API execution started");
        CobrandValidator.validateApiContext(this);
        CallContext callContext = this.buildGetSubscribedEventsContext(eventName);
        callContext.getApiClient().executeAsync(callContext.getCall(), CobrandNotificationResponse.class, apiCallback);
    }

    private CallContext buildGetSubscribedEventsContext(CobrandNotificationEventType eventName) throws ApiException {
        ApiContext apiContext = new ApiContext("/cobrand/config/notifications/events", HttpMethod.GET, null);
        if (eventName != null) {
            apiContext.addQueryParam(new Pair(PARAM_EVENT_NAME, eventName.name()));
        }
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    private ApiClient getApiClient() {
        ApiClient apiClient = new ApiClient();
        apiClient.setBasePath(this.cobrandConfiguration.getBasePath());
        apiClient.addHeader("Cobrand-Name", this.cobrandConfiguration.getName());
        apiClient.addHeader("Api-Version", this.cobrandConfiguration.getApiVersion());
        if (this.cobrandConfiguration.getLocale() != null) {
            apiClient.addHeader("locale", this.cobrandConfiguration.getLocale());
        }
        if (this.cobrandConfiguration.getSocketTimeout() != null) {
            apiClient.setConnectTimeout(this.cobrandConfiguration.getSocketTimeout());
        }
        if (this.cobrandConfiguration.getReadTimeout() != null) {
            apiClient.setReadTimeout(this.cobrandConfiguration.getReadTimeout());
        }
        if (this.cobrandConfiguration.getWriteTimeout() != null) {
            apiClient.setWriteTimeout(this.cobrandConfiguration.getWriteTimeout());
        }
        return apiClient;
    }
}

