/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.api;

import com.yodlee.api.model.AbstractModelComponent;
import com.yodlee.api.model.configs.enums.ConfigsNotificationEventType;
import com.yodlee.api.model.configs.request.CreateConfigsNotificationEventRequest;
import com.yodlee.api.model.configs.request.UpdateConfigsNotificationEventRequest;
import com.yodlee.api.model.configs.response.ConfigsNotificationResponse;
import com.yodlee.api.model.configs.response.ConfigsPublicKeyResponse;
import com.yodlee.sdk.api.AbstractApi;
import com.yodlee.sdk.api.exception.ApiException;
import com.yodlee.sdk.api.util.ApiUtils;
import com.yodlee.sdk.api.validators.ConfigsValidator;
import com.yodlee.sdk.client.ApiCallback;
import com.yodlee.sdk.client.ApiClient;
import com.yodlee.sdk.client.ApiContext;
import com.yodlee.sdk.client.ApiResponse;
import com.yodlee.sdk.client.CallContext;
import com.yodlee.sdk.client.HttpMethod;
import com.yodlee.sdk.client.Pair;
import com.yodlee.sdk.context.Context;
import javax.validation.constraints.NotNull;
import okhttp3.Call;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigsApi
extends AbstractApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigsApi.class);
    private static final String PARAM_EVENT_NAME = "eventName";

    public ConfigsApi(Context<?> context) {
        super(context);
    }

    public ApiResponse<AbstractModelComponent> createSubscriptionNotificationEvent(@NotNull(message="{configs.param.eventName.required}") ConfigsNotificationEventType eventName, @NotNull(message="{configs.CreateConfigsNotificationEventRequest.required}") CreateConfigsNotificationEventRequest eventRequest) throws ApiException {
        LOGGER.info("Configs createSubscriptionNotificationEvent API execution started");
        ConfigsValidator.validateCreateSubscriptionNotificationEvent(this, ApiUtils.getMethodName(), eventName, eventRequest);
        CallContext callContext = this.buildCreateSubscriptionNotificationEventContext(eventName, eventRequest);
        return callContext.getApiClient().execute(callContext.getCall(), null);
    }

    public void createSubscriptionNotificationEventAsync(@NotNull(message="{configs.param.eventName.required}") ConfigsNotificationEventType eventName, @NotNull(message="{configs.CreateConfigsNotificationEventRequest.required}") CreateConfigsNotificationEventRequest eventRequest, ApiCallback<AbstractModelComponent> apiCallBack) throws ApiException {
        LOGGER.info("Configs createSubscriptionNotificationEventAsync API execution started");
        ConfigsValidator.validateCreateSubscriptionNotificationEvent(this, ApiUtils.getMethodName(), eventName, eventRequest);
        CallContext callContext = this.buildCreateSubscriptionNotificationEventContext(eventName, eventRequest);
        callContext.getApiClient().executeAsync(callContext.getCall(), apiCallBack);
    }

    private CallContext buildCreateSubscriptionNotificationEventContext(ConfigsNotificationEventType eventName, CreateConfigsNotificationEventRequest eventRequest) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        String endPoint = this.replacePathVariable("/configs/notifications/events/{eventName}", PARAM_EVENT_NAME, eventName.toString());
        ApiContext apiContext = new ApiContext(endPoint, HttpMethod.POST, eventRequest);
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<AbstractModelComponent> updateSubscribedNotificationEvent(@NotNull(message="{configs.param.eventName.required}") ConfigsNotificationEventType eventName, @NotNull(message="{configs.UpdateConfigsNotificationEventRequest.required}") UpdateConfigsNotificationEventRequest eventRequest) throws ApiException {
        LOGGER.info("Configs updateSubscribedNotificationEvent API execution started");
        ConfigsValidator.validateUpdateSubscribedNotificationEvent(this, ApiUtils.getMethodName(), eventName, eventRequest);
        CallContext callContext = this.buildUpdateSubscribedNotificationEventContext(eventName, eventRequest);
        return callContext.getApiClient().execute(callContext.getCall(), null);
    }

    public void updateSubscribedNotificationEventAsync(@NotNull(message="{configs.param.eventName.required}") ConfigsNotificationEventType eventName, @NotNull(message="{configs.UpdateConfigsNotificationEventRequest.required}") UpdateConfigsNotificationEventRequest eventRequest, ApiCallback<AbstractModelComponent> apiCallback) throws ApiException {
        LOGGER.info("Configs updateSubscribedNotificationEventAsync API execution started");
        ConfigsValidator.validateUpdateSubscribedNotificationEvent(this, ApiUtils.getMethodName(), eventName, eventRequest);
        CallContext callContext = this.buildUpdateSubscribedNotificationEventContext(eventName, eventRequest);
        callContext.getApiClient().executeAsync(callContext.getCall(), apiCallback);
    }

    private CallContext buildUpdateSubscribedNotificationEventContext(ConfigsNotificationEventType eventName, UpdateConfigsNotificationEventRequest eventRequest) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        String endPoint = this.replacePathVariable("/configs/notifications/events/{eventName}", PARAM_EVENT_NAME, eventName.toString());
        ApiContext apiContext = new ApiContext(endPoint, HttpMethod.PUT, eventRequest);
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<AbstractModelComponent> deleteSubscribedNotificationEvent(@NotNull(message="{configs.param.eventName.required}") ConfigsNotificationEventType eventName) throws ApiException {
        LOGGER.info("Configs deleteSubscribedNotificationEvent API execution started");
        ConfigsValidator.validateDeleteSubscribedNotificationEvent(this, ApiUtils.getMethodName(), eventName);
        CallContext callContext = this.buildDeleteSubscribedNotificationEventContext(eventName);
        return callContext.getApiClient().execute(callContext.getCall(), null);
    }

    public void deleteSubscribedNotificationEventAsync(@NotNull(message="{configs.param.eventName.required}") ConfigsNotificationEventType eventName, ApiCallback<AbstractModelComponent> apiCallback) throws ApiException {
        LOGGER.info("Configs deleteSubscribedNotificationEventAsync API execution started");
        ConfigsValidator.validateDeleteSubscribedNotificationEvent(this, ApiUtils.getMethodName(), eventName);
        CallContext callContext = this.buildDeleteSubscribedNotificationEventContext(eventName);
        callContext.getApiClient().executeAsync(callContext.getCall(), apiCallback);
    }

    private CallContext buildDeleteSubscribedNotificationEventContext(ConfigsNotificationEventType eventName) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        String endPoint = this.replacePathVariable("/configs/notifications/events/{eventName}", PARAM_EVENT_NAME, eventName.toString());
        ApiContext apiContext = new ApiContext(endPoint, HttpMethod.DELETE, null);
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<ConfigsPublicKeyResponse> getPublicEncryptionKey() throws ApiException {
        LOGGER.info("Configs getPublicEncryptionKey API execution started");
        ConfigsValidator.validateApiContext(this);
        CallContext callContext = this.buildGetPublicEncryptionKeyContext();
        return callContext.getApiClient().execute(callContext.getCall(), ConfigsPublicKeyResponse.class);
    }

    public void getPublicEncryptionKeyAsync(ApiCallback<ConfigsPublicKeyResponse> apiCallback) throws ApiException {
        LOGGER.info("Configs getPublicEncryptionKeyAsync API execution started");
        ConfigsValidator.validateApiContext(this);
        CallContext callContext = this.buildGetPublicEncryptionKeyContext();
        callContext.getApiClient().executeAsync(callContext.getCall(), ConfigsPublicKeyResponse.class, apiCallback);
    }

    private CallContext buildGetPublicEncryptionKeyContext() throws ApiException {
        ApiContext apiContext = new ApiContext("/configs/publicKey", HttpMethod.GET, null);
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<ConfigsNotificationResponse> getSubscribedNotificationEvents(ConfigsNotificationEventType eventName) throws ApiException {
        LOGGER.info("Configs getSubscribedNotificationEvents API execution started");
        ConfigsValidator.validateApiContext(this);
        CallContext callContext = this.buildGetSubscribedNotificationEventsContext(eventName);
        return callContext.getApiClient().execute(callContext.getCall(), ConfigsNotificationResponse.class);
    }

    public void getSubscribedNotificationEventsAsync(ConfigsNotificationEventType eventName, ApiCallback<ConfigsNotificationResponse> apiCallback) throws ApiException {
        LOGGER.info("Configs getSubscribedNotificationEventsAsync API execution started");
        ConfigsValidator.validateApiContext(this);
        CallContext callContext = this.buildGetSubscribedNotificationEventsContext(eventName);
        callContext.getApiClient().executeAsync(callContext.getCall(), ConfigsNotificationResponse.class, apiCallback);
    }

    private CallContext buildGetSubscribedNotificationEventsContext(ConfigsNotificationEventType eventName) throws ApiException {
        ApiContext apiContext = new ApiContext("/configs/notifications/events", HttpMethod.GET, null);
        if (eventName != null) {
            apiContext.addQueryParam(new Pair(PARAM_EVENT_NAME, eventName.name()));
        }
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }
}

