/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.api;

import com.yodlee.api.model.AbstractModelComponent;
import com.yodlee.api.model.consent.request.CreateConsentRequest;
import com.yodlee.api.model.consent.request.UpdateConsentRequest;
import com.yodlee.api.model.consent.response.ConsentResponse;
import com.yodlee.api.model.consent.response.CreatedConsentResponse;
import com.yodlee.api.model.consent.response.UpdatedConsentResponse;
import com.yodlee.sdk.api.AbstractApi;
import com.yodlee.sdk.api.exception.ApiException;
import com.yodlee.sdk.api.util.ApiUtils;
import com.yodlee.sdk.api.validators.ConsentsValidator;
import com.yodlee.sdk.client.ApiCallback;
import com.yodlee.sdk.client.ApiClient;
import com.yodlee.sdk.client.ApiContext;
import com.yodlee.sdk.client.ApiResponse;
import com.yodlee.sdk.client.CallContext;
import com.yodlee.sdk.client.HttpMethod;
import com.yodlee.sdk.client.Pair;
import com.yodlee.sdk.context.Context;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import okhttp3.Call;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsentsApi
extends AbstractApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsentsApi.class);
    private static final String PARAM_CONSENTS_ID = "consentId";
    private static final String PARAM_PROVIDERACCOUNTS_ID = "providerAccountId";

    public ConsentsApi(Context<?> context) {
        super(context);
    }

    public ApiResponse<UpdatedConsentResponse> getAuthorizationURL(@Digits(integer=11, fraction=0, message="{consents.param.consentId.invalid}") long consentId) throws ApiException {
        LOGGER.info("Consents getAuthorizationURL API execution started");
        ConsentsValidator.validateGetAuthorizationURL(this, ApiUtils.getMethodName(), consentId);
        CallContext callContext = this.buildGetAuthorizationURLContext(consentId);
        return callContext.getApiClient().execute(callContext.getCall(), UpdatedConsentResponse.class);
    }

    public void getAuthorizationURLAsync(@Digits(integer=11, fraction=0, message="{consents.param.consentId.invalid}") long consentId, ApiCallback<AbstractModelComponent> apiCallback) throws ApiException {
        LOGGER.info("Consents getAuthorizationURL API execution started");
        ConsentsValidator.validateGetAuthorizationURL(this, ApiUtils.getMethodName(), consentId);
        CallContext callContext = this.buildGetAuthorizationURLContext(consentId);
        callContext.getApiClient().executeAsync(callContext.getCall(), apiCallback);
    }

    private CallContext buildGetAuthorizationURLContext(long consentId) throws ApiException {
        String endpoint = this.replacePathVariable("/consents/{consentId}", PARAM_CONSENTS_ID, String.valueOf(consentId));
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext(endpoint, HttpMethod.GET, null);
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<UpdatedConsentResponse> captureConsent(@Digits(integer=11, fraction=0, message="{consents.param.consentId.invalid}") long consentId, @NotNull(message="{consents.updateConsentRequest.required}") UpdateConsentRequest updateConsentRequest) throws ApiException {
        LOGGER.info("Consents captureConsent API execution started");
        ConsentsValidator.validateCaptureConsent(this, ApiUtils.getMethodName(), consentId, updateConsentRequest);
        CallContext callContext = this.buildCaptureConsentContext(consentId, updateConsentRequest);
        return callContext.getApiClient().execute(callContext.getCall(), UpdatedConsentResponse.class);
    }

    public void captureConsentAsync(@Digits(integer=11, fraction=0, message="{accounts.param.consentId.invalid}") long consentId, @NotNull(message="{consents.updateConsentRequest.required}") UpdateConsentRequest updateConsentRequest, ApiCallback<AbstractModelComponent> apiCallback) throws ApiException {
        LOGGER.info("Consents captureConsent API execution started");
        ConsentsValidator.validateCaptureConsent(this, ApiUtils.getMethodName(), consentId, updateConsentRequest);
        CallContext callContext = this.buildCaptureConsentContext(consentId, updateConsentRequest);
        callContext.getApiClient().executeAsync(callContext.getCall(), apiCallback);
    }

    private CallContext buildCaptureConsentContext(long consentId, UpdateConsentRequest updateConsentRequest) throws ApiException {
        String endpoint = this.replacePathVariable("/consents/{consentId}", PARAM_CONSENTS_ID, String.valueOf(consentId));
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext(endpoint, HttpMethod.PUT, updateConsentRequest);
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<CreatedConsentResponse> createConsent(@NotNull(message="{consents.createConsentRequest.required}") CreateConsentRequest createConsentRequest) throws ApiException {
        LOGGER.info("Consents createConsent API execution started");
        ConsentsValidator.validateCreateConsent(this, ApiUtils.getMethodName(), createConsentRequest);
        CallContext callContext = this.buildCreateConsentContext(createConsentRequest);
        return callContext.getApiClient().execute(callContext.getCall(), CreatedConsentResponse.class);
    }

    public void createConsentAsync(@NotNull(message="{consents.createConsentRequest.required}") CreateConsentRequest createConsentRequest, ApiCallback<AbstractModelComponent> apiCallback) throws ApiException {
        LOGGER.info("Consents createConsent API execution started");
        ConsentsValidator.validateCreateConsent(this, ApiUtils.getMethodName(), createConsentRequest);
        CallContext callContext = this.buildCreateConsentContext(createConsentRequest);
        callContext.getApiClient().executeAsync(callContext.getCall(), apiCallback);
    }

    private CallContext buildCreateConsentContext(CreateConsentRequest createConsentRequest) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/consents", HttpMethod.POST, createConsentRequest);
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<ConsentResponse> getConsent(@Size(min=0, max=100, message="{consents.param.consentId.length.invalid}") Long[] consentIds, @Size(min=0, max=100, message="{consents.param.providerAccountId.length.invalid}") Long[] providerAccountIds) throws ApiException {
        LOGGER.info("Consents getAuthorizationURL API execution started");
        ConsentsValidator.validateGetConsent(this, ApiUtils.getMethodName(), consentIds, providerAccountIds);
        CallContext callContext = this.buildGetConsentContext(consentIds, providerAccountIds);
        return callContext.getApiClient().execute(callContext.getCall(), ConsentResponse.class);
    }

    public void getConsentAsync(@Size(min=0, max=100, message="{consents.param.consentId.length.invalid}") Long[] consentIds, @Size(min=0, max=100, message="{consents.param.providerAccountId.length.invalid}") Long[] providerAccountIds, ApiCallback<AbstractModelComponent> apiCallback) throws ApiException {
        LOGGER.info("Consents getAuthorizationURL API execution started");
        ConsentsValidator.validateGetConsent(this, ApiUtils.getMethodName(), consentIds, providerAccountIds);
        CallContext callContext = this.buildGetConsentContext(consentIds, providerAccountIds);
        callContext.getApiClient().executeAsync(callContext.getCall(), apiCallback);
    }

    private CallContext buildGetConsentContext(Long[] consentIds, Long[] providerAccountIds) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/consents", HttpMethod.GET, null);
        if (consentIds != null) {
            apiContext.addQueryParam(new Pair(PARAM_CONSENTS_ID, ApiUtils.convertArrayToString((Object[])consentIds)));
        }
        if (providerAccountIds != null) {
            apiContext.addQueryParam(new Pair(PARAM_PROVIDERACCOUNTS_ID, ApiUtils.convertArrayToString((Object[])providerAccountIds)));
        }
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }
}

