/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.api;

import com.yodlee.api.model.dataextracts.response.DataExtractsEventResponse;
import com.yodlee.api.model.dataextracts.response.DataExtractsUserDataResponse;
import com.yodlee.sdk.api.AbstractApi;
import com.yodlee.sdk.api.exception.ApiException;
import com.yodlee.sdk.api.util.ApiUtils;
import com.yodlee.sdk.api.validators.DataExtractsValidator;
import com.yodlee.sdk.client.ApiCallback;
import com.yodlee.sdk.client.ApiClient;
import com.yodlee.sdk.client.ApiContext;
import com.yodlee.sdk.client.ApiResponse;
import com.yodlee.sdk.client.CallContext;
import com.yodlee.sdk.client.HttpMethod;
import com.yodlee.sdk.client.Pair;
import com.yodlee.sdk.context.Context;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Past;
import javax.validation.constraints.Pattern;
import okhttp3.Call;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataExtractsApi
extends AbstractApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataExtractsApi.class);
    private static final String PARAM_LOGIN_NAME = "loginName";
    private static final String PARAM_TO_DATE = "toDate";
    private static final String PARAM_FROM_DATE = "fromDate";
    private static final String PARAM_EVENT_NAME = "eventName";

    public DataExtractsApi(Context<?> context) {
        super(context);
    }

    public ApiResponse<DataExtractsEventResponse> getDataExtractsEvents(@NotNull(message="{dataExtracts.param.eventName.required}") DataExtractsValidator.DataExtractsEventType eventName, @NotNull(message="{dataExtracts.param.fromDate.required}") @Past(message="{dataExtracts.param.fromDate.invalid}") Date fromDate, @NotNull(message="{dataExtracts.param.toDate.required}") @Past(message="{dataExtracts.param.toDate.invalid}") Date toDate) throws ApiException {
        LOGGER.info("DataExtracts getDataExtractsEvents API execution started");
        DataExtractsValidator.validateDataExtractsEvents(this, ApiUtils.getMethodName(), eventName, fromDate, toDate);
        CallContext callContext = this.buildGetDataExtractsEventsContext(eventName, fromDate, toDate);
        return callContext.getApiClient().execute(callContext.getCall(), DataExtractsEventResponse.class);
    }

    public void getDataExtractsEventsAsync(@NotNull(message="{dataExtracts.param.eventName.required}") DataExtractsValidator.DataExtractsEventType eventName, @NotNull(message="{dataExtracts.param.fromDate.required}") @Past(message="{dataExtracts.param.fromDate.invalid}") Date fromDate, @NotNull(message="{dataExtracts.param.toDate.required}") @Past(message="{dataExtracts.param.toDate.invalid}") Date toDate, ApiCallback<DataExtractsEventResponse> apiCallback) throws ApiException {
        LOGGER.info("DataExtracts getDataExtractsEventsAsync API execution started");
        DataExtractsValidator.validateDataExtractsEvents(this, ApiUtils.getMethodName(), eventName, fromDate, toDate);
        CallContext callContext = this.buildGetDataExtractsEventsContext(eventName, fromDate, toDate);
        callContext.getApiClient().executeAsync(callContext.getCall(), DataExtractsEventResponse.class, apiCallback);
    }

    private CallContext buildGetDataExtractsEventsContext(DataExtractsValidator.DataExtractsEventType eventName, Date fromDate, Date toDate) throws ApiException {
        SimpleDateFormat sdf = DataExtractsApi.getUTCSimpleDateFormat();
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/dataExtracts/events", HttpMethod.GET, null);
        this.registerResponseInterceptor(apiClient);
        apiContext.addQueryParam(new Pair(PARAM_EVENT_NAME, eventName.name()));
        apiContext.addQueryParam(new Pair(PARAM_FROM_DATE, sdf.format(fromDate)));
        apiContext.addQueryParam(new Pair(PARAM_TO_DATE, sdf.format(toDate)));
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<DataExtractsUserDataResponse> getDataExtractsUserData(@NotNull(message="{dataExtracts.param.fromDate.required}") @Past(message="{dataExtracts.param.fromDate.invalid}") Date fromDate, @NotEmpty(message="{dataExtracts.param.loginName.required}") @Pattern(regexp="[^\\s]+", message="{user.loginName.invalid}") String loginName, @NotNull(message="{dataExtracts.param.toDate.required}") @Past(message="{dataExtracts.param.toDate.invalid}") Date toDate) throws ApiException {
        LOGGER.info("DataExtracts getDataExtractsUserData API execution started");
        DataExtractsValidator.validateDataExtractsUserData(this, ApiUtils.getMethodName(), fromDate, loginName, toDate);
        CallContext callContext = this.buildGetDataExtractsUserDataContext(fromDate, loginName, toDate);
        return callContext.getApiClient().execute(callContext.getCall(), DataExtractsUserDataResponse.class);
    }

    public void getDataExtractsUserDataAsync(@NotNull(message="{dataExtracts.param.fromDate.required}") @Past(message="{dataExtracts.param.fromDate.invalid}") Date fromDate, @NotEmpty(message="{dataExtracts.param.loginName.required}") @Pattern(regexp="[^\\s]+", message="{user.loginName.invalid}") String loginName, @NotNull(message="{dataExtracts.param.toDate.required}") @Past(message="{dataExtracts.param.toDate.invalid}") Date toDate, ApiCallback<DataExtractsUserDataResponse> apiCallback) throws ApiException {
        LOGGER.info("DataExtracts getDataExtractsUserDataAsync API execution started");
        DataExtractsValidator.validateDataExtractsUserData(this, ApiUtils.getMethodName(), fromDate, loginName, toDate);
        CallContext callContext = this.buildGetDataExtractsUserDataContext(fromDate, loginName, toDate);
        callContext.getApiClient().executeAsync(callContext.getCall(), DataExtractsUserDataResponse.class, apiCallback);
    }

    private CallContext buildGetDataExtractsUserDataContext(Date fromDate, String loginName, Date toDate) throws ApiException {
        SimpleDateFormat sdf = DataExtractsApi.getUTCSimpleDateFormat();
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/dataExtracts/userData", HttpMethod.GET, null);
        this.registerResponseInterceptor(apiClient);
        apiContext.addQueryParam(new Pair(PARAM_LOGIN_NAME, loginName));
        apiContext.addQueryParam(new Pair(PARAM_FROM_DATE, sdf.format(fromDate)));
        apiContext.addQueryParam(new Pair(PARAM_TO_DATE, sdf.format(toDate)));
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    private static SimpleDateFormat getUTCSimpleDateFormat() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        return formatter;
    }
}

