/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.api;

import com.yodlee.api.model.annotations.AllowedContainer;
import com.yodlee.api.model.derived.response.DerivedHoldingSummaryResponse;
import com.yodlee.api.model.derived.response.DerivedNetworthResponse;
import com.yodlee.api.model.derived.response.DerivedTransactionSummaryResponse;
import com.yodlee.api.model.enums.Container;
import com.yodlee.sdk.api.AbstractApi;
import com.yodlee.sdk.api.exception.ApiException;
import com.yodlee.sdk.api.util.ApiUtils;
import com.yodlee.sdk.api.validators.DerivedValidator;
import com.yodlee.sdk.client.ApiCallback;
import com.yodlee.sdk.client.ApiClient;
import com.yodlee.sdk.client.ApiContext;
import com.yodlee.sdk.client.ApiResponse;
import com.yodlee.sdk.client.CallContext;
import com.yodlee.sdk.client.HttpMethod;
import com.yodlee.sdk.client.Pair;
import com.yodlee.sdk.context.Context;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Past;
import javax.validation.constraints.Size;
import okhttp3.Call;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerivedApi
extends AbstractApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(DerivedApi.class);
    private static final String PARAM_CATEGORY_TYPE = "categoryType";
    private static final String PARAM_CATEGORY_ID = "categoryId";
    private static final String PARAM_INCLUDE_USER_CATEGORY = "includeUserCategory";
    private static final String PARAM_TOP = "top";
    private static final String PARAM_TO_DATE = "toDate";
    private static final String PARAM_SKIP = "skip";
    private static final String PARAM_INTERVAL = "interval";
    private static final String PARAM_INCLUDE = "include";
    private static final String PARAM_FROM_DATE = "fromDate";
    private static final String PARAM_ACCOUNT_ID = "accountId";
    private static final String PARAM_ACCOUNT_IDS = "accountIds";
    private static final String PARAM_GROUP_BY = "groupBy";
    private static final String PARAM_CONTAINER = "container";

    public DerivedApi(Context<?> context) {
        super(context);
    }

    public ApiResponse<DerivedTransactionSummaryResponse> getTransactionSummary(@NotNull(message="{derived.param.groupBy.required}") DerivedValidator.GroupType groupBy, @Size(min=0, max=100, message="{derived.param.accountId.length.invalid}") Long[] accountId, @Size(min=0, max=100, message="{derived.param.categoryId.length.invalid}") Long[] categoryId, @Size(min=0, max=100, message="{derived.param.categoryTypes.length.invalid}") DerivedValidator.CategoryType[] categoryTypes, @Past(message="{derived.param.fromDate.invalid}") Date fromDate, DerivedValidator.DerivedInclude include, Boolean includeUserCategory, DerivedValidator.DataPointInterval interval, @Past(message="{derived.param.toDate.invalid}") Date toDate) throws ApiException {
        LOGGER.info("Derived getTransactionSummary API execution started");
        DerivedValidator.validateTransactionSummary(this, ApiUtils.getMethodName(), groupBy, accountId, categoryId, categoryTypes, fromDate, include, includeUserCategory, interval, toDate);
        CallContext callContext = this.buildGetTransactionSummaryContext(groupBy, accountId, categoryId, categoryTypes, fromDate, include, includeUserCategory, interval, toDate);
        return callContext.getApiClient().execute(callContext.getCall(), DerivedTransactionSummaryResponse.class);
    }

    public void getTransactionSummaryAsync(@NotNull(message="{derived.param.groupBy.required}") DerivedValidator.GroupType groupBy, @Size(min=0, max=100, message="{derived.param.accountId.length.invalid}") Long[] accountId, @Size(min=0, max=100, message="{derived.param.categoryId.length.invalid}") Long[] categoryId, @Size(min=0, max=100, message="{derived.param.categoryTypes.length.invalid}") DerivedValidator.CategoryType[] categoryTypes, @Past(message="{derived.param.fromDate.invalid}") Date fromDate, DerivedValidator.DerivedInclude include, Boolean includeUserCategory, DerivedValidator.DataPointInterval interval, @Past(message="{derived.param.toDate.invalid}") Date toDate, ApiCallback<DerivedTransactionSummaryResponse> apiCallback) throws ApiException {
        LOGGER.info("Derived getTransactionSummaryAsync API execution started");
        DerivedValidator.validateTransactionSummary(this, ApiUtils.getMethodName(), groupBy, accountId, categoryId, categoryTypes, fromDate, include, includeUserCategory, interval, toDate);
        CallContext callContext = this.buildGetTransactionSummaryContext(groupBy, accountId, categoryId, categoryTypes, fromDate, include, includeUserCategory, interval, toDate);
        callContext.getApiClient().executeAsync(callContext.getCall(), DerivedTransactionSummaryResponse.class, apiCallback);
    }

    private CallContext buildGetTransactionSummaryContext(DerivedValidator.GroupType groupBy, Long[] accountId, Long[] categoryId, DerivedValidator.CategoryType[] categoryTypes, Date fromDate, DerivedValidator.DerivedInclude include, Boolean includeUserCategory, DerivedValidator.DataPointInterval interval, Date toDate) throws ApiException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/derived/transactionSummary", HttpMethod.GET, null);
        this.registerResponseInterceptor(apiClient);
        apiContext.addQueryParam(new Pair(PARAM_GROUP_BY, groupBy.toString()));
        if (accountId != null && accountId.length > 0) {
            apiContext.addQueryParam(new Pair(PARAM_ACCOUNT_ID, ApiUtils.convertArrayToString((Object[])accountId)));
        }
        if (categoryId != null && categoryId.length > 0) {
            apiContext.addQueryParam(new Pair(PARAM_CATEGORY_ID, ApiUtils.convertArrayToString((Object[])categoryId)));
        }
        if (categoryTypes != null && categoryTypes.length > 0) {
            apiContext.addQueryParam(new Pair(PARAM_CATEGORY_TYPE, ApiUtils.convertArrayToString((Object[])categoryTypes)));
        }
        if (fromDate != null) {
            apiContext.addQueryParam(new Pair(PARAM_FROM_DATE, formatter.format((Object)fromDate)));
        }
        if (include != null) {
            apiContext.addQueryParam(new Pair(PARAM_INCLUDE, include.toString()));
        }
        if (includeUserCategory != null) {
            apiContext.addQueryParam(new Pair(PARAM_INCLUDE_USER_CATEGORY, String.valueOf(includeUserCategory)));
        }
        if (interval != null) {
            apiContext.addQueryParam(new Pair(PARAM_INTERVAL, interval.toString()));
        }
        if (toDate != null) {
            apiContext.addQueryParam(new Pair(PARAM_TO_DATE, formatter.format((Object)toDate)));
        }
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<DerivedHoldingSummaryResponse> getHoldingSummary(@Size(min=0, max=100, message="{derived.param.accountId.length.invalid}") Long[] accountIds, String classificationType, DerivedValidator.DerivedInclude include) throws ApiException {
        LOGGER.info("Derived getHoldingSummary API execution started");
        DerivedValidator.validateHoldingSummary(this, ApiUtils.getMethodName(), accountIds, classificationType, include);
        CallContext callContext = this.buildGetHoldingSummaryContext(accountIds, classificationType, include);
        return callContext.getApiClient().execute(callContext.getCall(), DerivedHoldingSummaryResponse.class);
    }

    public void getHoldingSummaryAsync(@Size(min=0, max=100, message="{derived.param.accountId.length.invalid}") Long[] accountIds, String classificationType, DerivedValidator.DerivedInclude include, ApiCallback<DerivedHoldingSummaryResponse> apiCallback) throws ApiException {
        LOGGER.info("Derived getHoldingSummaryAsync API execution started");
        DerivedValidator.validateHoldingSummary(this, ApiUtils.getMethodName(), accountIds, classificationType, include);
        CallContext callContext = this.buildGetHoldingSummaryContext(accountIds, classificationType, include);
        callContext.getApiClient().executeAsync(callContext.getCall(), DerivedHoldingSummaryResponse.class, apiCallback);
    }

    private CallContext buildGetHoldingSummaryContext(Long[] accountIds, String classificationType, DerivedValidator.DerivedInclude include) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/derived/holdingSummary", HttpMethod.GET, null);
        this.registerResponseInterceptor(apiClient);
        if (accountIds != null && accountIds.length > 0) {
            apiContext.addQueryParam(new Pair(PARAM_ACCOUNT_IDS, ApiUtils.convertArrayToString((Object[])accountIds)));
        }
        if (!StringUtils.isEmpty((CharSequence)classificationType)) {
            apiContext.addQueryParam(new Pair(PARAM_FROM_DATE, classificationType));
        }
        if (include != null) {
            apiContext.addQueryParam(new Pair(PARAM_INCLUDE, include.toString()));
        }
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<DerivedNetworthResponse> getNetworth(Long[] accountIds, @Past(message="{derived.param.fromDate.invalid}") Date fromDate, DerivedValidator.DerivedInclude include, DerivedValidator.DataPointInterval interval, @Min(value=0L, message="{derived.param.skip.invalid}") Integer skip, @Past(message="{derived.param.toDate.invalid}") Date toDate, @Min(value=1L, message="{derived.param.top.invalid}") @Max(value=500L, message="{derived.param.top.invalid}") Integer top, @AllowedContainer(value={Container.bank, Container.creditCard, Container.investment, Container.insurance, Container.loan, Container.realEstate, Container.otherAssets, Container.otherLiabilities}, message="{derived.param.container.invalid}") @AllowedContainer(value={Container.bank, Container.creditCard, Container.investment, Container.insurance, Container.loan, Container.realEstate, Container.otherAssets, Container.otherLiabilities}, message="{derived.param.container.invalid}") Container container) throws ApiException {
        LOGGER.info("Derived getNetworth API execution started");
        DerivedValidator.validateNetworth(this, ApiUtils.getMethodName(), accountIds, fromDate, include, interval, skip, toDate, top, container);
        CallContext callContext = this.buildGetNetworthContext(accountIds, fromDate, include, interval, skip, toDate, top, container);
        return callContext.getApiClient().execute(callContext.getCall(), DerivedNetworthResponse.class);
    }

    public void getNetworthAsync(Long[] accountIds, @Past(message="{derived.param.fromDate.invalid}") Date fromDate, DerivedValidator.DerivedInclude include, DerivedValidator.DataPointInterval interval, @Min(value=0L, message="{derived.param.skip.invalid}") Integer skip, @Past(message="{derived.param.toDate.invalid}") Date toDate, @Min(value=1L, message="{derived.param.top.invalid}") @Max(value=500L, message="{derived.param.top.invalid}") Integer top, @AllowedContainer(value={Container.bank, Container.creditCard, Container.investment, Container.insurance, Container.loan, Container.realEstate, Container.otherAssets, Container.otherLiabilities}, message="{derived.param.container.invalid}") @AllowedContainer(value={Container.bank, Container.creditCard, Container.investment, Container.insurance, Container.loan, Container.realEstate, Container.otherAssets, Container.otherLiabilities}, message="{derived.param.container.invalid}") Container container, ApiCallback<DerivedNetworthResponse> apiCallback) throws ApiException {
        LOGGER.info("Derived getNetworthAsync API execution started");
        DerivedValidator.validateNetworth(this, ApiUtils.getMethodName(), accountIds, fromDate, include, interval, skip, toDate, top, container);
        CallContext callContext = this.buildGetNetworthContext(accountIds, fromDate, include, interval, skip, toDate, top, container);
        callContext.getApiClient().executeAsync(callContext.getCall(), DerivedNetworthResponse.class, apiCallback);
    }

    private CallContext buildGetNetworthContext(Long[] accountIds, Date fromDate, DerivedValidator.DerivedInclude include, DerivedValidator.DataPointInterval interval, Integer skip, Date toDate, Integer top, Container container) throws ApiException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/derived/networth", HttpMethod.GET, null);
        this.registerResponseInterceptor(apiClient);
        if (accountIds != null && accountIds.length > 0) {
            apiContext.addQueryParam(new Pair(PARAM_ACCOUNT_IDS, ApiUtils.convertArrayToString((Object[])accountIds)));
        }
        if (fromDate != null) {
            apiContext.addQueryParam(new Pair(PARAM_FROM_DATE, formatter.format((Object)fromDate)));
        }
        if (include != null) {
            apiContext.addQueryParam(new Pair(PARAM_INCLUDE, include.toString()));
        }
        if (interval != null) {
            apiContext.addQueryParam(new Pair(PARAM_INTERVAL, interval.toString()));
        }
        if (skip != null) {
            apiContext.addQueryParam(new Pair(PARAM_SKIP, String.valueOf(skip)));
        }
        if (toDate != null) {
            apiContext.addQueryParam(new Pair(PARAM_TO_DATE, formatter.format((Object)toDate)));
        }
        if (top != null) {
            apiContext.addQueryParam(new Pair(PARAM_TOP, String.valueOf(top)));
        }
        if (container != null) {
            apiContext.addQueryParam(new Pair(PARAM_CONTAINER, String.valueOf(container)));
        }
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }
}

