/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.api;

import com.yodlee.api.model.AbstractModelComponent;
import com.yodlee.api.model.documents.enums.DocType;
import com.yodlee.api.model.documents.response.DocumentDownloadResponse;
import com.yodlee.api.model.documents.response.DocumentResponse;
import com.yodlee.sdk.api.AbstractApi;
import com.yodlee.sdk.api.exception.ApiException;
import com.yodlee.sdk.api.util.ApiUtils;
import com.yodlee.sdk.api.validators.DocumentsValidator;
import com.yodlee.sdk.client.ApiCallback;
import com.yodlee.sdk.client.ApiClient;
import com.yodlee.sdk.client.ApiContext;
import com.yodlee.sdk.client.ApiResponse;
import com.yodlee.sdk.client.CallContext;
import com.yodlee.sdk.client.HttpMethod;
import com.yodlee.sdk.client.Pair;
import com.yodlee.sdk.context.Context;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import okhttp3.Call;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentsApi
extends AbstractApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentsApi.class);
    private static final String PARAM_KEYWORD = "Keyword";
    private static final String PARAM_ACCOUNT_ID = "accountId";
    private static final String PARAM_DOC_TYPE = "docType";
    private static final String PARAM_FROM_DATE = "fromDate";
    private static final String PARAM_TO_DATE = "toDate";
    private static final String PARAM_DOCUMENT_ID = "documentId";

    public DocumentsApi(Context<?> context) {
        super(context);
    }

    public ApiResponse<DocumentResponse> getDocuments(String keyword, @Digits(integer=11, fraction=0, message="{documents.param.accountId.invalid}") @Min(value=1L, message="{documents.param.accountId.invalid}") Long accountId, DocType docType, Date fromDate, Date toDate) throws ApiException {
        LOGGER.info("Documents getDocuments API execution started");
        DocumentsValidator.validateGetDocuments(this, ApiUtils.getMethodName(), keyword, accountId, docType, fromDate, toDate);
        CallContext callContext = this.buildGetDocumentsContext(keyword, accountId, docType, fromDate, toDate, null);
        return callContext.getApiClient().execute(callContext.getCall(), DocumentResponse.class);
    }

    public ApiResponse<DocumentResponse> getDocuments(String keyword, @Digits(integer=11, fraction=0, message="{documents.param.accountId.invalid}") @Min(value=1L, message="{documents.param.accountId.invalid}") Long accountId, DocType docType, Date fromDate, Date toDate, Map<String, String> headers) throws ApiException {
        LOGGER.info("Documents getDocuments API execution started");
        DocumentsValidator.validateGetDocuments(this, ApiUtils.getMethodName(), keyword, accountId, docType, fromDate, toDate);
        String contentEncodingValue = headers.get("Accept-Encoding");
        CallContext callContext = this.buildGetDocumentsContext(keyword, accountId, docType, fromDate, toDate, contentEncodingValue);
        return callContext.getApiClient().execute(callContext.getCall(), DocumentResponse.class);
    }

    public void getDocumentsAsync(String keyword, @Digits(integer=11, fraction=0, message="{documents.param.accountId.invalid}") @Min(value=1L, message="{documents.param.accountId.invalid}") Long accountId, DocType docType, Date fromDate, Date toDate, ApiCallback<DocumentResponse> apiCallback) throws ApiException {
        LOGGER.info("Documents getDocumentsAsync API execution started");
        DocumentsValidator.validateGetDocuments(this, ApiUtils.getMethodName(), keyword, accountId, docType, fromDate, toDate);
        CallContext callContext = this.buildGetDocumentsContext(keyword, accountId, docType, fromDate, toDate, null);
        callContext.getApiClient().executeAsync(callContext.getCall(), DocumentResponse.class, apiCallback);
    }

    private CallContext buildGetDocumentsContext(String keyword, Long accountId, DocType docType, Date fromDate, Date toDate, String contentEncoding) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/documents", HttpMethod.GET, null);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        if (!StringUtils.isBlank((CharSequence)keyword)) {
            apiContext.addQueryParam(new Pair(PARAM_KEYWORD, keyword));
        }
        if (accountId != null) {
            apiContext.addQueryParam(new Pair(PARAM_ACCOUNT_ID, accountId.toString()));
        }
        if (docType != null) {
            apiContext.addQueryParam(new Pair(PARAM_DOC_TYPE, docType.name()));
        }
        if (fromDate != null) {
            String formattedFromDate = formatter.format(fromDate);
            apiContext.addQueryParam(new Pair(PARAM_FROM_DATE, formattedFromDate));
        }
        if (toDate != null) {
            String formattedToDate = formatter.format(toDate);
            apiContext.addQueryParam(new Pair(PARAM_TO_DATE, formattedToDate));
        }
        if (contentEncoding != null) {
            apiContext.addHeaderParam("Accept-Encoding", contentEncoding);
        }
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<DocumentDownloadResponse> downloadDocument(@NotNull(message="{documents.param.documentId.required}") String documentId) throws ApiException {
        LOGGER.info("Documents downloadDocument API execution started");
        DocumentsValidator.validateDeleteOrDownloadDocument(this, ApiUtils.getMethodName(), documentId);
        CallContext callContext = this.buildDownloadDocumentContext(documentId, null);
        return callContext.getApiClient().execute(callContext.getCall(), DocumentDownloadResponse.class);
    }

    public ApiResponse<DocumentDownloadResponse> downloadDocument(@NotNull(message="{documents.param.documentId.required}") String documentId, Map<String, String> headers) throws ApiException {
        LOGGER.info("Documents downloadDocument API execution started");
        DocumentsValidator.validateDeleteOrDownloadDocument(this, ApiUtils.getMethodName(), documentId);
        String contentEncodingValue = headers.get("Accept-Encoding");
        CallContext callContext = this.buildDownloadDocumentContext(documentId, contentEncodingValue);
        return callContext.getApiClient().execute(callContext.getCall(), DocumentDownloadResponse.class);
    }

    public void downloadDocumentAsync(@NotNull(message="{documents.param.documentId.required}") String documentId, ApiCallback<DocumentDownloadResponse> apiCallback) throws ApiException {
        LOGGER.info("Documents downloadDocumentAsync API execution started");
        DocumentsValidator.validateDeleteOrDownloadDocument(this, ApiUtils.getMethodName(), documentId);
        CallContext callContext = this.buildDownloadDocumentContext(documentId, null);
        callContext.getApiClient().executeAsync(callContext.getCall(), DocumentDownloadResponse.class, apiCallback);
    }

    private CallContext buildDownloadDocumentContext(String documentId, String contentEncoding) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        String endpoint = this.replacePathVariable("/documents/{documentId}", PARAM_DOCUMENT_ID, documentId);
        ApiContext apiContext = new ApiContext(endpoint, HttpMethod.GET, null);
        if (contentEncoding != null) {
            apiContext.addHeaderParam("Accept-Encoding", contentEncoding);
        }
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<AbstractModelComponent> deleteDocument(@NotNull(message="{documents.param.documentId.required}") String documentId) throws ApiException {
        LOGGER.info("Documents deleteDocument API execution started");
        DocumentsValidator.validateDeleteOrDownloadDocument(this, ApiUtils.getMethodName(), documentId);
        CallContext callContext = this.buildDeleteDocumentContext(documentId);
        return callContext.getApiClient().execute(callContext.getCall(), null);
    }

    public void deleteDocumentAsync(@NotNull(message="{documents.param.documentId.required}") String documentId, ApiCallback<AbstractModelComponent> apiCallback) throws ApiException {
        LOGGER.info("Documents deleteDocumentAsync API execution started");
        DocumentsValidator.validateDeleteOrDownloadDocument(this, ApiUtils.getMethodName(), documentId);
        CallContext callContext = this.buildDeleteDocumentContext(documentId);
        callContext.getApiClient().executeAsync(callContext.getCall(), apiCallback);
    }

    private CallContext buildDeleteDocumentContext(String documentId) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        String endpoint = this.replacePathVariable("/documents/{documentId}", PARAM_DOCUMENT_ID, documentId);
        ApiContext apiContext = new ApiContext(endpoint, HttpMethod.DELETE, null);
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }
}

