/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.api;

import com.yodlee.api.model.enrichData.request.EnrichDataRequest;
import com.yodlee.api.model.enrichData.response.EnrichedTransactionResponse;
import com.yodlee.sdk.api.AbstractApi;
import com.yodlee.sdk.api.ProvidersApi;
import com.yodlee.sdk.api.exception.ApiException;
import com.yodlee.sdk.api.util.ApiUtils;
import com.yodlee.sdk.api.validators.EnrichDataValidator;
import com.yodlee.sdk.client.ApiCallback;
import com.yodlee.sdk.client.ApiClient;
import com.yodlee.sdk.client.ApiContext;
import com.yodlee.sdk.client.ApiResponse;
import com.yodlee.sdk.client.CallContext;
import com.yodlee.sdk.client.HttpMethod;
import com.yodlee.sdk.context.Context;
import okhttp3.Call;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnrichDataApi
extends AbstractApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProvidersApi.class);

    public EnrichDataApi(Context<?> context) {
        super(context);
    }

    public ApiResponse<EnrichedTransactionResponse> pushUserData(EnrichDataRequest userData) throws ApiException {
        LOGGER.info("DataFeed pushUserData API execution started");
        EnrichDataValidator.validatePushUserData(this, ApiUtils.getMethodName());
        CallContext callContext = this.buildPushUserDataContext(userData);
        return callContext.getApiClient().execute(callContext.getCall(), EnrichedTransactionResponse.class);
    }

    public void pushUserDataAsync(ApiCallback<EnrichedTransactionResponse> apiCallback, EnrichDataRequest userData) throws ApiException {
        LOGGER.info("DataFeed pushUserDataAsync API execution started");
        EnrichDataValidator.validatePushUserData(this, ApiUtils.getMethodName());
        CallContext callContext = this.buildPushUserDataContext(userData);
        callContext.getApiClient().executeAsync(callContext.getCall(), EnrichedTransactionResponse.class, apiCallback);
    }

    private CallContext buildPushUserDataContext(EnrichDataRequest userData) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiCallModel = new ApiContext("/enrichData/userData", HttpMethod.POST, userData);
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiCallModel, this.requestListener());
        return new CallContext(apiClient, call);
    }
}

