/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.api;

import com.yodlee.api.model.holdings.response.HoldingAssetClassificationListResponse;
import com.yodlee.api.model.holdings.response.HoldingResponse;
import com.yodlee.api.model.holdings.response.HoldingSecuritiesResponse;
import com.yodlee.api.model.holdings.response.HoldingTypeListResponse;
import com.yodlee.sdk.api.AbstractApi;
import com.yodlee.sdk.api.exception.ApiException;
import com.yodlee.sdk.api.util.ApiUtils;
import com.yodlee.sdk.api.validators.HoldingsValidator;
import com.yodlee.sdk.client.ApiCallback;
import com.yodlee.sdk.client.ApiClient;
import com.yodlee.sdk.client.ApiContext;
import com.yodlee.sdk.client.ApiResponse;
import com.yodlee.sdk.client.CallContext;
import com.yodlee.sdk.client.HttpMethod;
import com.yodlee.sdk.client.Pair;
import com.yodlee.sdk.context.Context;
import java.util.Map;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Min;
import javax.validation.constraints.Size;
import okhttp3.Call;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoldingsApi
extends AbstractApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(HoldingsApi.class);
    private static final String PARAM_PROVIDER_ACCOUNT_ID = "providerAccountId";
    private static final String PARAM_INCLUDE = "include";
    private static final String PARAM_CLASSIFICATION_VALUE = "classificationValue";
    private static final String PARAM_ASSET_CLASSIFICATION_CLASSIFICATION_TYPE = "assetClassificationClassificationType";
    private static final String PARAM_ACCOUNT_ID = "accountId";
    private static final String PARAM_HOLDING_ID = "holdingId";

    public HoldingsApi(Context<?> context) {
        super(context);
    }

    public ApiResponse<HoldingResponse> getHoldings(@Size(min=0, max=100, message="{holdings.param.accountId.length.invalid}") Long[] accountId, String assetClassificationClassificationType, String classificationValue, HoldingsValidator.HoldingInclude include, @Digits(message="{holdings.param.providerAccountId.invalid}", fraction=0, integer=11) @Min(value=1L, message="{holdings.param.providerAccountId.invalid}") Long providerAccountId) throws ApiException {
        LOGGER.info("Holdings getHoldings API execution started");
        HoldingsValidator.validateGetHoldings(this, ApiUtils.getMethodName(), accountId, assetClassificationClassificationType, classificationValue, include, providerAccountId);
        CallContext callContext = this.buildGetHoldingsContext(accountId, assetClassificationClassificationType, classificationValue, include, providerAccountId, null);
        return callContext.getApiClient().execute(callContext.getCall(), HoldingResponse.class);
    }

    public ApiResponse<HoldingResponse> getHoldings(@Size(min=0, max=100, message="{holdings.param.accountId.length.invalid}") Long[] accountId, String assetClassificationClassificationType, String classificationValue, HoldingsValidator.HoldingInclude include, @Digits(message="{holdings.param.providerAccountId.invalid}", fraction=0, integer=11) @Min(value=1L, message="{holdings.param.providerAccountId.invalid}") Long providerAccountId, Map<String, String> headers) throws ApiException {
        LOGGER.info("Holdings getHoldings API execution started");
        HoldingsValidator.validateGetHoldings(this, ApiUtils.getMethodName(), accountId, assetClassificationClassificationType, classificationValue, include, providerAccountId);
        String contentEncodingValue = headers.get("Accept-Encoding");
        CallContext callContext = this.buildGetHoldingsContext(accountId, assetClassificationClassificationType, classificationValue, include, providerAccountId, contentEncodingValue);
        return callContext.getApiClient().execute(callContext.getCall(), HoldingResponse.class);
    }

    public void getHoldingsAsync(@Size(min=0, max=100, message="{holdings.param.accountId.length.invalid}") Long[] accountId, String assetClassificationClassificationType, String classificationValue, HoldingsValidator.HoldingInclude include, @Digits(message="{holdings.param.providerAccountId.invalid}", fraction=0, integer=11) @Min(value=1L, message="{holdings.param.providerAccountId.invalid}") Long providerAccountId, ApiCallback<HoldingResponse> apiCallback) throws ApiException {
        LOGGER.info("Holdings getHoldingsAsync API execution started");
        HoldingsValidator.validateGetHoldings(this, ApiUtils.getMethodName(), accountId, assetClassificationClassificationType, classificationValue, include, providerAccountId);
        CallContext callContext = this.buildGetHoldingsContext(accountId, assetClassificationClassificationType, classificationValue, include, providerAccountId, null);
        callContext.getApiClient().executeAsync(callContext.getCall(), HoldingResponse.class, apiCallback);
    }

    private CallContext buildGetHoldingsContext(Long[] accountId, String assetClassificationClassificationType, String classificationValue, HoldingsValidator.HoldingInclude include, Long providerAccountId, String contentEncoding) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/holdings", HttpMethod.GET, null);
        if (accountId != null) {
            apiContext.addQueryParam(new Pair(PARAM_ACCOUNT_ID, ApiUtils.convertArrayToString((Object[])accountId)));
        }
        if (!StringUtils.isEmpty((CharSequence)assetClassificationClassificationType)) {
            apiContext.addQueryParam(new Pair(PARAM_ASSET_CLASSIFICATION_CLASSIFICATION_TYPE, assetClassificationClassificationType));
        }
        if (!StringUtils.isEmpty((CharSequence)classificationValue)) {
            apiContext.addQueryParam(new Pair(PARAM_CLASSIFICATION_VALUE, classificationValue));
        }
        if (include != null) {
            apiContext.addQueryParam(new Pair(PARAM_INCLUDE, include.toString()));
        }
        if (providerAccountId != null) {
            apiContext.addQueryParam(new Pair(PARAM_PROVIDER_ACCOUNT_ID, providerAccountId.toString()));
        }
        if (contentEncoding != null) {
            apiContext.addHeaderParam("Accept-Encoding", contentEncoding);
        }
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<HoldingSecuritiesResponse> getSecurities(@Size(min=0, max=100, message="{holdings.param.holdingId.length.invalid}") Long[] holdingId) throws ApiException {
        LOGGER.info("Holdings getSecurities API execution started");
        HoldingsValidator.validateGetSecurities(this, ApiUtils.getMethodName(), holdingId);
        CallContext callContext = this.buildGetSecuritiesContext(holdingId);
        return callContext.getApiClient().execute(callContext.getCall(), HoldingSecuritiesResponse.class);
    }

    public void getSecuritiesAsync(@Size(min=0, max=100, message="{holdings.param.holdingId.length.invalid}") Long[] holdingId, ApiCallback<HoldingSecuritiesResponse> apiCallback) throws ApiException {
        LOGGER.info("Holdings getSecuritiesAsync API execution started");
        HoldingsValidator.validateGetSecurities(this, ApiUtils.getMethodName(), holdingId);
        CallContext callContext = this.buildGetSecuritiesContext(holdingId);
        callContext.getApiClient().executeAsync(callContext.getCall(), HoldingSecuritiesResponse.class, apiCallback);
    }

    private CallContext buildGetSecuritiesContext(Long[] holdingId) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/holdings/securities", HttpMethod.GET, null);
        if (holdingId != null) {
            apiContext.addQueryParam(new Pair(PARAM_HOLDING_ID, ApiUtils.convertArrayToString((Object[])holdingId)));
        }
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<HoldingTypeListResponse> getHoldingTypeList() throws ApiException {
        LOGGER.info("Holdings getHoldingTypeList API execution started");
        HoldingsValidator.validateHoldingsContext(this);
        CallContext callContext = this.buildGetHoldingTypeListContext();
        return callContext.getApiClient().execute(callContext.getCall(), HoldingTypeListResponse.class);
    }

    public void getHoldingTypeListAsync(ApiCallback<HoldingTypeListResponse> apiCallback) throws ApiException {
        LOGGER.info("Holdings getHoldingTypeListAsync API execution started");
        HoldingsValidator.validateHoldingsContext(this);
        CallContext callContext = this.buildGetHoldingTypeListContext();
        callContext.getApiClient().executeAsync(callContext.getCall(), HoldingTypeListResponse.class, apiCallback);
    }

    private CallContext buildGetHoldingTypeListContext() throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/holdings/holdingTypeList", HttpMethod.GET, null);
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<HoldingAssetClassificationListResponse> getAssetClassificationList() throws ApiException {
        LOGGER.info("Holdings getAssetClassificationList API execution started");
        HoldingsValidator.validateHoldingsContext(this);
        CallContext callContext = this.buildGetAssetClassificationListContext();
        return callContext.getApiClient().execute(callContext.getCall(), HoldingAssetClassificationListResponse.class);
    }

    public void getAssetClassificationListAsync(ApiCallback<HoldingAssetClassificationListResponse> apiCallback) throws ApiException {
        LOGGER.info("Holdings getAssetClassificationListAsync API execution started");
        HoldingsValidator.validateHoldingsContext(this);
        CallContext callContext = this.buildGetAssetClassificationListContext();
        callContext.getApiClient().executeAsync(callContext.getCall(), HoldingAssetClassificationListResponse.class, apiCallback);
    }

    private CallContext buildGetAssetClassificationListContext() throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/holdings/assetClassificationList", HttpMethod.GET, null);
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }
}

