/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.api;

import com.yodlee.api.model.AbstractModelComponent;
import com.yodlee.api.model.Field;
import com.yodlee.api.model.provideraccounts.request.AbstractProviderAccountRequest;
import com.yodlee.api.model.provideraccounts.request.ProviderAccountPreferencesRequest;
import com.yodlee.api.model.provideraccounts.request.ProviderAccountRequest;
import com.yodlee.api.model.provideraccounts.request.RefreshProviderAccountRequest;
import com.yodlee.api.model.provideraccounts.response.AddedProviderAccountResponse;
import com.yodlee.api.model.provideraccounts.response.ProviderAccountDetailResponse;
import com.yodlee.api.model.provideraccounts.response.ProviderAccountResponse;
import com.yodlee.api.model.provideraccounts.response.ProviderAccountUserProfileResponse;
import com.yodlee.api.model.provideraccounts.response.UpdatedProviderAccountResponse;
import com.yodlee.sdk.api.AbstractApi;
import com.yodlee.sdk.api.exception.ApiException;
import com.yodlee.sdk.api.util.ApiUtils;
import com.yodlee.sdk.api.validators.ProviderAccountsValidator;
import com.yodlee.sdk.client.ApiCallback;
import com.yodlee.sdk.client.ApiClient;
import com.yodlee.sdk.client.ApiContext;
import com.yodlee.sdk.client.ApiResponse;
import com.yodlee.sdk.client.CallContext;
import com.yodlee.sdk.client.HttpMethod;
import com.yodlee.sdk.client.Pair;
import com.yodlee.sdk.context.Context;
import java.util.Arrays;
import java.util.Map;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import okhttp3.Call;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProviderAccountsApi
extends AbstractApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProviderAccountsApi.class);
    private static final String PARAM_PROVIDER_IDS = "providerIds";
    private static final String PARAM_REQUEST_ID = "requestId";
    private static final String PARAM_INCLUDE = "include";
    private static final String PARAM_PROVIDER_ACCOUNT_IDS = "providerAccountIds";
    private static final String PROVIDER_ID = "providerId";
    private static final String PROVIDER_ACCOUNT_ID = "providerAccountId";

    public ProviderAccountsApi(Context<?> context) {
        super(context);
    }

    public ApiResponse<UpdatedProviderAccountResponse> refreshAllProviderAccounts() throws ApiException {
        ProviderAccountsValidator.validateRefreshAllProviderAccounts(this, ApiUtils.getMethodName());
        return this.editCredentialsOrRefreshProviderAccount(null, null);
    }

    public void refreshAllProviderAccountsAsync(ApiCallback<UpdatedProviderAccountResponse> apiCallback) throws ApiException {
        ProviderAccountsValidator.validateRefreshAllProviderAccounts(this, ApiUtils.getMethodName());
        this.editCredentialsOrRefreshProviderAccountAsync(null, null, apiCallback);
    }

    public ApiResponse<UpdatedProviderAccountResponse> refreshProviderAccount(@Digits(message="{providerAccounts.param.providerAccountId.invalid}", fraction=0, integer=11) long providerAccountId, RefreshProviderAccountRequest refreshProviderAccountRequest) throws ApiException {
        ProviderAccountsValidator.validateRefreshProviderAccount(this, ApiUtils.getMethodName(), providerAccountId, refreshProviderAccountRequest);
        return this.editCredentialsOrRefreshProviderAccount(String.valueOf(providerAccountId), (AbstractProviderAccountRequest)refreshProviderAccountRequest);
    }

    public void refreshProviderAccountAsync(@Digits(message="{providerAccounts.param.providerAccountId.invalid}", fraction=0, integer=11) long providerAccountId, RefreshProviderAccountRequest refreshProviderAccountRequest, ApiCallback<UpdatedProviderAccountResponse> apiCallback) throws ApiException {
        ProviderAccountsValidator.validateRefreshProviderAccount(this, ApiUtils.getMethodName(), providerAccountId, refreshProviderAccountRequest);
        this.editCredentialsOrRefreshProviderAccountAsync(String.valueOf(providerAccountId), (AbstractProviderAccountRequest)refreshProviderAccountRequest, apiCallback);
    }

    public ApiResponse<UpdatedProviderAccountResponse> editProviderAccountCredentials(@Min(value=1L, message="{providerAccounts.param.providerAccountId.invalid}") @Digits(message="{providerAccounts.param.providerAccountId.invalid}", fraction=0, integer=11) long providerAccountId, @NotNull(message="{providerAccounts.param.providerAccountRequest.required}") ProviderAccountRequest providerAccountRequest) throws ApiException {
        ProviderAccountsValidator.validateUpdateProviderAccount(this, ApiUtils.getMethodName(), providerAccountId, providerAccountRequest);
        return this.editCredentialsOrRefreshProviderAccount(String.valueOf(providerAccountId), (AbstractProviderAccountRequest)providerAccountRequest);
    }

    public void editProviderAccountCredentialsAsync(@Min(value=1L, message="{providerAccounts.param.providerAccountId.invalid}") @Digits(message="{providerAccounts.param.providerAccountId.invalid}", fraction=0, integer=11) long providerAccountId, @NotNull(message="{providerAccounts.param.providerAccountRequest.required}") ProviderAccountRequest providerAccountRequest, ApiCallback<UpdatedProviderAccountResponse> apiCallback) throws ApiException {
        ProviderAccountsValidator.validateUpdateProviderAccount(this, ApiUtils.getMethodName(), providerAccountId, providerAccountRequest);
        this.editCredentialsOrRefreshProviderAccountAsync(String.valueOf(providerAccountId), (AbstractProviderAccountRequest)providerAccountRequest, apiCallback);
    }

    public ApiResponse<UpdatedProviderAccountResponse> submitProviderAccountMFA(@Min(value=1L, message="{providerAccounts.param.providerAccountId.invalid}") @Digits(message="{providerAccounts.param.providerAccountId.invalid}", fraction=0, integer=11) long providerAccountId, Field[] mfaFields) throws ApiException {
        ProviderAccountsValidator.validateMFAProviderAccount(this, ApiUtils.getMethodName(), providerAccountId, mfaFields);
        ProviderAccountRequest providerAccountRequest = new ProviderAccountRequest();
        providerAccountRequest.setField(Arrays.asList(mfaFields));
        return this.editCredentialsOrRefreshProviderAccount(String.valueOf(providerAccountId), (AbstractProviderAccountRequest)providerAccountRequest);
    }

    public void submitProviderAccountMFAAsync(@Min(value=1L, message="{providerAccounts.param.providerAccountId.invalid}") @Digits(message="{providerAccounts.param.providerAccountId.invalid}", fraction=0, integer=11) long providerAccountId, Field[] mfaFields, ApiCallback<UpdatedProviderAccountResponse> apiCallback) throws ApiException {
        ProviderAccountsValidator.validateMFAProviderAccount(this, ApiUtils.getMethodName(), providerAccountId, mfaFields);
        ProviderAccountRequest providerAccountRequest = new ProviderAccountRequest();
        providerAccountRequest.setField(Arrays.asList(mfaFields));
        this.editCredentialsOrRefreshProviderAccountAsync(String.valueOf(providerAccountId), (AbstractProviderAccountRequest)providerAccountRequest, apiCallback);
    }

    public ApiResponse<AbstractModelComponent> deleteProviderAccount(@Min(value=1L, message="{providerAccounts.param.providerAccountId.invalid}") @Digits(message="{providerAccounts.param.providerAccountId.invalid}", fraction=0, integer=11) long providerAccountId) throws ApiException {
        LOGGER.info("ProviderAccount deleteProviderAccount API execution started");
        ProviderAccountsValidator.validateDeleteProviderAccount(this, ApiUtils.getMethodName(), providerAccountId);
        CallContext callContext = this.buildDeleteProviderAccountContext(providerAccountId);
        return callContext.getApiClient().execute(callContext.getCall(), null);
    }

    public void deleteProviderAccountAsync(@Min(value=1L, message="{providerAccounts.param.providerAccountId.invalid}") @Digits(message="{providerAccounts.param.providerAccountId.invalid}", fraction=0, integer=11) long providerAccountId, ApiCallback<AbstractModelComponent> apiCallback) throws ApiException {
        LOGGER.info("ProviderAccount deleteProviderAccountAsync API execution started");
        ProviderAccountsValidator.validateDeleteProviderAccount(this, ApiUtils.getMethodName(), providerAccountId);
        CallContext callContext = this.buildDeleteProviderAccountContext(providerAccountId);
        callContext.getApiClient().executeAsync(callContext.getCall(), apiCallback);
    }

    public ApiResponse<ProviderAccountDetailResponse> getProviderAccount(@Min(value=1L, message="{providerAccounts.param.providerAccountId.invalid}") @Digits(message="{providerAccounts.param.providerAccountId.invalid}", fraction=0, integer=11) long providerAccountId, ProviderAccountsValidator.ProviderAccountInclude[] include, String requestId) throws ApiException {
        LOGGER.info("ProviderAccount getProviderAccount API execution started");
        ProviderAccountsValidator.validateGetProviderAccount(this, ApiUtils.getMethodName(), providerAccountId, include, requestId);
        CallContext callContext = this.buildGetProviderAccountContext(providerAccountId, include, requestId, null);
        return callContext.getApiClient().execute(callContext.getCall(), ProviderAccountDetailResponse.class);
    }

    public ApiResponse<ProviderAccountDetailResponse> getProviderAccount(@Min(value=1L, message="{providerAccounts.param.providerAccountId.invalid}") @Digits(message="{providerAccounts.param.providerAccountId.invalid}", fraction=0, integer=11) long providerAccountId, ProviderAccountsValidator.ProviderAccountInclude[] include, String requestId, Map<String, String> headers) throws ApiException {
        LOGGER.info("ProviderAccount getProviderAccount API execution started");
        ProviderAccountsValidator.validateGetProviderAccount(this, ApiUtils.getMethodName(), providerAccountId, include, requestId);
        String contentEncodingValue = headers.get("Accept-Encoding");
        CallContext callContext = this.buildGetProviderAccountContext(providerAccountId, include, requestId, contentEncodingValue);
        return callContext.getApiClient().execute(callContext.getCall(), ProviderAccountDetailResponse.class);
    }

    public void getProviderAccountAsync(@Min(value=1L, message="{providerAccounts.param.providerAccountId.invalid}") @Digits(message="{providerAccounts.param.providerAccountId.invalid}", fraction=0, integer=11) long providerAccountId, ProviderAccountsValidator.ProviderAccountInclude[] include, String requestId, ApiCallback<ProviderAccountDetailResponse> apiCallback) throws ApiException {
        LOGGER.info("ProviderAccount getProviderAccountAsync API execution started");
        ProviderAccountsValidator.validateGetProviderAccount(this, ApiUtils.getMethodName(), providerAccountId, include, requestId);
        CallContext callContext = this.buildGetProviderAccountContext(providerAccountId, include, requestId, null);
        callContext.getApiClient().executeAsync(callContext.getCall(), ProviderAccountDetailResponse.class, apiCallback);
    }

    public ApiResponse<ProviderAccountResponse> getAllProviderAccounts(ProviderAccountsValidator.ProviderAccountDetailsInclude include, Long[] providerIds) throws ApiException {
        LOGGER.info("ProviderAccount getAllProviderAccounts API execution started");
        ProviderAccountsValidator.validateGetAllProviderAccounts(this, ApiUtils.getMethodName(), include, providerIds);
        CallContext callContext = this.buildGetAllProviderAccountsContext(include, providerIds, null);
        return callContext.getApiClient().execute(callContext.getCall(), ProviderAccountResponse.class);
    }

    public ApiResponse<ProviderAccountResponse> getAllProviderAccounts(ProviderAccountsValidator.ProviderAccountDetailsInclude include, Long[] providerIds, Map<String, String> headers) throws ApiException {
        LOGGER.info("ProviderAccount getAllProviderAccounts API execution started");
        ProviderAccountsValidator.validateGetAllProviderAccounts(this, ApiUtils.getMethodName(), include, providerIds);
        String contentEncodingValue = headers.get("Accept-Encoding");
        CallContext callContext = this.buildGetAllProviderAccountsContext(include, providerIds, contentEncodingValue);
        return callContext.getApiClient().execute(callContext.getCall(), ProviderAccountResponse.class);
    }

    public void getAllProviderAccountsAsync(ProviderAccountsValidator.ProviderAccountDetailsInclude include, Long[] providerIds, ApiCallback<ProviderAccountResponse> apiCallback) throws ApiException {
        LOGGER.info("ProviderAccount getAllProviderAccountsAsync API execution started");
        ProviderAccountsValidator.validateGetAllProviderAccounts(this, ApiUtils.getMethodName(), include, providerIds);
        CallContext callContext = this.buildGetAllProviderAccountsContext(include, providerIds, null);
        callContext.getApiClient().executeAsync(callContext.getCall(), ProviderAccountResponse.class, apiCallback);
    }

    public ApiResponse<AddedProviderAccountResponse> linkCredentialProviderAccount(@NotNull(message="{providerAccounts.param.providerAccountRequest.required}") ProviderAccountRequest providerAccountRequest, @Min(value=1L, message="{providerAccounts.param.providerId.invalid}") @Digits(message="{providerAccounts.param.providerId.invalid}", fraction=0, integer=11) long providerId) throws ApiException {
        LOGGER.info("ProviderAccount linkCredentialProviderAccount API execution started");
        ProviderAccountsValidator.validateLinkProviderAccount(this, ApiUtils.getMethodName(), providerId, providerAccountRequest);
        return this.linkProviderAccount(providerAccountRequest, providerId);
    }

    public void linkCredentialProviderAccountAsync(@NotNull(message="{providerAccounts.param.providerAccountRequest.required}") ProviderAccountRequest providerAccountRequest, @Min(value=1L, message="{providerAccounts.param.providerId.invalid}") @Digits(message="{providerAccounts.param.providerId.invalid}", fraction=0, integer=11) long providerId, ApiCallback<AddedProviderAccountResponse> apiCallback) throws ApiException {
        LOGGER.info("ProviderAccount linkCredentialProviderAccountAsync API execution started");
        ProviderAccountsValidator.validateLinkProviderAccount(this, ApiUtils.getMethodName(), providerId, providerAccountRequest);
        this.linkProviderAccountAsync(providerAccountRequest, providerId, apiCallback);
    }

    public ApiResponse<ProviderAccountUserProfileResponse> getProviderAccountProfile(Long[] providerAccountId) throws ApiException {
        LOGGER.info("ProviderAccount getProviderAccountProfile API execution started");
        ProviderAccountsValidator.validateGetProviderAccountProfiles(this, ApiUtils.getMethodName(), providerAccountId);
        CallContext callContext = this.buildGetProviderAccountProfilesContext(providerAccountId);
        return callContext.getApiClient().execute(callContext.getCall(), ProviderAccountUserProfileResponse.class);
    }

    public void getProviderAccountProfileAsync(Long[] providerAccountId, ApiCallback<ProviderAccountUserProfileResponse> apiCallback) throws ApiException {
        LOGGER.info("ProviderAccount getProviderAccountProfileAsync API execution started");
        ProviderAccountsValidator.validateGetProviderAccountProfiles(this, ApiUtils.getMethodName(), providerAccountId);
        CallContext callContext = this.buildGetProviderAccountProfilesContext(providerAccountId);
        callContext.getApiClient().executeAsync(callContext.getCall(), ProviderAccountUserProfileResponse.class, apiCallback);
    }

    public ApiResponse<AbstractModelComponent> updatePreferences(@NotNull(message="{providerAccounts.param.preferences.required}") ProviderAccountPreferencesRequest preferences, @NotNull(message="{providerAccounts.param.providerAccountId.required}") @Digits(message="{providerAccounts.param.providerAccountId.invalid}", fraction=0, integer=11) Long providerAccountId) throws ApiException {
        LOGGER.info("ProviderAccount updatePreferences API execution started");
        ProviderAccountsValidator.validateUpdatePreferences(this, ApiUtils.getMethodName(), preferences, providerAccountId);
        CallContext callContext = this.buildUpdatePreferencesContext(preferences, providerAccountId);
        return callContext.getApiClient().execute(callContext.getCall(), null);
    }

    public void updatePreferencesAsync(@NotNull(message="{providerAccounts.param.preferences.required}") ProviderAccountPreferencesRequest preferences, @NotNull(message="{providerAccounts.param.providerAccountId.required}") @Digits(message="{providerAccounts.param.providerAccountId.invalid}", fraction=0, integer=11) Long providerAccountId, ApiCallback<AbstractModelComponent> apiCallback) throws ApiException {
        LOGGER.info("ProviderAccount updatePreferencesAsync API execution started");
        ProviderAccountsValidator.validateUpdatePreferences(this, ApiUtils.getMethodName(), preferences, providerAccountId);
        CallContext callContext = this.buildUpdatePreferencesContext(preferences, providerAccountId);
        callContext.getApiClient().executeAsync(callContext.getCall(), apiCallback);
    }

    private ApiResponse<UpdatedProviderAccountResponse> editCredentialsOrRefreshProviderAccount(String providerAccountIds, AbstractProviderAccountRequest providerAccountRequest) throws ApiException {
        LOGGER.info("ProviderAccount editCredentialsOrRefreshProviderAccount API execution started");
        CallContext callContext = this.buildEditCredentialsOrRefreshProviderAccountContext(providerAccountIds, providerAccountRequest);
        return callContext.getApiClient().execute(callContext.getCall(), UpdatedProviderAccountResponse.class);
    }

    private void editCredentialsOrRefreshProviderAccountAsync(String providerAccountIds, AbstractProviderAccountRequest providerAccountRequest, ApiCallback<UpdatedProviderAccountResponse> apiCallback) throws ApiException {
        LOGGER.info("ProviderAccount editCredentialsOrRefreshProviderAccountAsync API execution started");
        CallContext callContext = this.buildEditCredentialsOrRefreshProviderAccountContext(providerAccountIds, providerAccountRequest);
        callContext.getApiClient().executeAsync(callContext.getCall(), UpdatedProviderAccountResponse.class, apiCallback);
    }

    private CallContext buildEditCredentialsOrRefreshProviderAccountContext(String providerAccountIds, AbstractProviderAccountRequest providerAccountRequest) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/providerAccounts", HttpMethod.PUT, providerAccountRequest);
        apiContext.addQueryParam(new Pair(PARAM_PROVIDER_ACCOUNT_IDS, providerAccountIds));
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    private CallContext buildDeleteProviderAccountContext(long providerAccountId) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        String apiEndPoint = this.replacePathVariable("/providerAccounts/{providerAccountId}", PROVIDER_ACCOUNT_ID, String.valueOf(providerAccountId));
        ApiContext apiContext = new ApiContext(apiEndPoint, HttpMethod.DELETE, null);
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    private CallContext buildGetProviderAccountContext(long providerAccountId, ProviderAccountsValidator.ProviderAccountInclude[] include, String requestId, String contentEncoding) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        String apiEndPoint = this.replacePathVariable("/providerAccounts/{providerAccountId}", PROVIDER_ACCOUNT_ID, String.valueOf(providerAccountId));
        ApiContext apiContext = new ApiContext(apiEndPoint, HttpMethod.GET, null);
        if (include != null) {
            apiContext.addQueryParam(new Pair(PARAM_INCLUDE, ApiUtils.convertArrayToString((Object[])include)));
        }
        if (!StringUtils.isEmpty((CharSequence)requestId)) {
            apiContext.addQueryParam(new Pair(PARAM_REQUEST_ID, requestId));
        }
        if (contentEncoding != null) {
            apiContext.addHeaderParam("Accept-Encoding", contentEncoding);
        }
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    private CallContext buildGetAllProviderAccountsContext(ProviderAccountsValidator.ProviderAccountDetailsInclude include, Long[] providerIds, String contentEncoding) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/providerAccounts", HttpMethod.GET, null);
        if (include != null) {
            apiContext.addQueryParam(new Pair(PARAM_INCLUDE, include.toString()));
        }
        if (providerIds != null) {
            apiContext.addQueryParam(new Pair(PARAM_PROVIDER_IDS, ApiUtils.convertArrayToString((Object[])providerIds)));
        }
        if (contentEncoding != null) {
            apiContext.addHeaderParam("Accept-Encoding", contentEncoding);
        }
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    private ApiResponse<AddedProviderAccountResponse> linkProviderAccount(ProviderAccountRequest providerAccountRequest, Long providerId) throws ApiException {
        LOGGER.info("ProviderAccount linkProviderAccount API execution started");
        CallContext callContext = this.buildLinkProviderAccountContext(providerAccountRequest, providerId);
        return callContext.getApiClient().execute(callContext.getCall(), AddedProviderAccountResponse.class);
    }

    private void linkProviderAccountAsync(ProviderAccountRequest providerAccountRequest, Long providerId, ApiCallback<AddedProviderAccountResponse> apiCallback) throws ApiException {
        LOGGER.info("ProviderAccount linkProviderAccountAsync API execution started");
        CallContext callContext = this.buildLinkProviderAccountContext(providerAccountRequest, providerId);
        callContext.getApiClient().executeAsync(callContext.getCall(), AddedProviderAccountResponse.class, apiCallback);
    }

    private CallContext buildLinkProviderAccountContext(ProviderAccountRequest providerAccountRequest, Long providerId) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/providerAccounts", HttpMethod.POST, providerAccountRequest);
        apiContext.addQueryParam(new Pair(PROVIDER_ID, providerId.toString()));
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    private CallContext buildGetProviderAccountProfilesContext(Long[] providerAccountId) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/providerAccounts/profile", HttpMethod.GET, null);
        if (providerAccountId != null) {
            apiContext.addQueryParam(new Pair(PROVIDER_ACCOUNT_ID, ApiUtils.convertArrayToString((Object[])providerAccountId)));
        }
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    private CallContext buildUpdatePreferencesContext(ProviderAccountPreferencesRequest preferences, Long providerAccountId) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        String apiEndPoint = this.replacePathVariable("/providerAccounts/{providerAccountId}/preferences", PROVIDER_ACCOUNT_ID, providerAccountId.toString());
        ApiContext apiContext = new ApiContext(apiEndPoint, HttpMethod.PUT, preferences);
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }
}

