/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.api;

import com.yodlee.api.model.providers.response.ProviderDetailResponse;
import com.yodlee.api.model.providers.response.ProviderResponse;
import com.yodlee.api.model.providers.response.ProvidersCountResponse;
import com.yodlee.sdk.api.AbstractApi;
import com.yodlee.sdk.api.exception.ApiException;
import com.yodlee.sdk.api.util.ApiUtils;
import com.yodlee.sdk.api.validators.ProvidersValidator;
import com.yodlee.sdk.client.ApiCallback;
import com.yodlee.sdk.client.ApiClient;
import com.yodlee.sdk.client.ApiContext;
import com.yodlee.sdk.client.ApiResponse;
import com.yodlee.sdk.client.CallContext;
import com.yodlee.sdk.client.HttpMethod;
import com.yodlee.sdk.client.Pair;
import com.yodlee.sdk.context.Context;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import okhttp3.Call;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvidersApi
extends AbstractApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProvidersApi.class);
    private static final String PARAM_TOP = "top";
    private static final String PARAM_SKIP = "skip";
    private static final String PARAM_PRIORITY = "priority";
    private static final String PARAM_NAME = "name";
    private static final String PARAM_DATASET$FILTER = "dataset$filter";
    private static final String FULL_ACCT_NUMBER_FIELDS = "fullAccountNumberFields";
    private static final String PARAM_CAPABILITY = "capability";
    private static final String PARAM_PROVIDER_ID = "providerId";

    public ProvidersApi(Context<?> context) {
        super(context);
    }

    public ApiResponse<ProviderResponse> getAllProviders(@Deprecated ProvidersValidator.ProvidersCapability capability, String datasetFilter, String name, ProvidersValidator.ProvidersPriorityType priority, @Min(value=0L, message="{providers.param.skip.invalid}") Integer skip, @Min(value=1L, message="{providers.param.top.invalid}") @Max(value=500L, message="{providers.param.top.invalid}") Integer top, String fullAccountNumberFields) throws ApiException {
        LOGGER.info("Providers getAllProviders API execution started");
        ProvidersValidator.validateGetProviders(this, ApiUtils.getMethodName(), capability, datasetFilter, name, priority, skip, top, fullAccountNumberFields);
        CallContext callContext = this.buildGetAllProvidersContext(capability, datasetFilter, fullAccountNumberFields, name, priority, skip, top);
        return callContext.getApiClient().execute(callContext.getCall(), ProviderResponse.class);
    }

    public void getAllProvidersAsync(@Deprecated ProvidersValidator.ProvidersCapability capability, String datasetFilter, String name, ProvidersValidator.ProvidersPriorityType priority, @Min(value=0L, message="{providers.param.skip.invalid}") Integer skip, @Min(value=1L, message="{providers.param.top.invalid}") @Max(value=500L, message="{providers.param.top.invalid}") Integer top, String fullAccountNumberFields, ApiCallback<ProviderResponse> apiCallBack) throws ApiException {
        LOGGER.info("Providers getAllProvidersAsync API execution started");
        ProvidersValidator.validateGetProviders(this, ApiUtils.getMethodName(), capability, datasetFilter, name, priority, skip, top, fullAccountNumberFields);
        CallContext callContext = this.buildGetAllProvidersContext(capability, datasetFilter, fullAccountNumberFields, name, priority, skip, top);
        callContext.getApiClient().executeAsync(callContext.getCall(), ProviderResponse.class, apiCallBack);
    }

    private CallContext buildGetAllProvidersContext(ProvidersValidator.ProvidersCapability capability, String datasetFilter, String fullAccountNumberFields, String name, ProvidersValidator.ProvidersPriorityType priority, Integer skip, Integer top) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiCallModel = new ApiContext("/providers", HttpMethod.GET, null);
        if (capability != null) {
            apiCallModel.addQueryParam(new Pair(PARAM_CAPABILITY, capability.toString()));
        }
        if (!StringUtils.isEmpty((CharSequence)datasetFilter)) {
            apiCallModel.addQueryParam(new Pair(PARAM_DATASET$FILTER, datasetFilter));
        }
        if (!StringUtils.isEmpty((CharSequence)fullAccountNumberFields)) {
            apiCallModel.addQueryParam(new Pair(FULL_ACCT_NUMBER_FIELDS, fullAccountNumberFields));
        }
        if (!StringUtils.isEmpty((CharSequence)name)) {
            apiCallModel.addQueryParam(new Pair(PARAM_NAME, name));
        }
        if (priority != null) {
            apiCallModel.addQueryParam(new Pair(PARAM_PRIORITY, priority.toString()));
        }
        if (skip != null) {
            apiCallModel.addQueryParam(new Pair(PARAM_SKIP, skip.toString()));
        }
        if (top != null) {
            apiCallModel.addQueryParam(new Pair(PARAM_TOP, top.toString()));
        }
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiCallModel, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<ProviderDetailResponse> getProvider(@NotNull(message="{providers.param.providerId.required}") @Min(value=0L, message="{providers.param.providerId.invalid}") Long providerId) throws ApiException {
        LOGGER.info("Providers getProvider API execution started");
        ProvidersValidator.validateGetProviderDetails(this, ApiUtils.getMethodName(), providerId);
        CallContext callContext = this.buildgetProviderContext(providerId);
        return callContext.getApiClient().execute(callContext.getCall(), ProviderDetailResponse.class);
    }

    public void getProviderAsync(@NotNull(message="{providers.param.providerId.required}") @Min(value=0L, message="{providers.param.providerId.invalid}") Long providerId, ApiCallback<ProviderDetailResponse> apiCallback) throws ApiException {
        LOGGER.info("Providers getProviderAsync API execution started");
        ProvidersValidator.validateGetProviderDetails(this, ApiUtils.getMethodName(), providerId);
        CallContext callContext = this.buildgetProviderContext(providerId);
        callContext.getApiClient().executeAsync(callContext.getCall(), ProviderDetailResponse.class, apiCallback);
    }

    private CallContext buildgetProviderContext(Long providerId) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        String apiEndPoint = this.replacePathVariable("/providers/{providerId}", PARAM_PROVIDER_ID, providerId.toString());
        this.registerResponseInterceptor(apiClient);
        ApiContext apiCallModel = new ApiContext(apiEndPoint, HttpMethod.GET, null);
        Call call = apiClient.buildCall(apiCallModel, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<ProvidersCountResponse> getProvidersCount(@Deprecated ProvidersValidator.ProvidersCapability capability, String datasetFilter, String name, ProvidersValidator.ProvidersPriorityType priority, String fullAccountNumberFields) throws ApiException {
        LOGGER.info("Providers getProvidersCount API execution started");
        ProvidersValidator.validateGetProvidersCount(this, ApiUtils.getMethodName(), capability, datasetFilter, name, priority, fullAccountNumberFields);
        CallContext callContext = this.buildGetProvidersCountContext(capability, datasetFilter, name, priority, fullAccountNumberFields);
        return callContext.getApiClient().execute(callContext.getCall(), ProvidersCountResponse.class);
    }

    public void getProvidersCountAsync(@Deprecated ProvidersValidator.ProvidersCapability capability, String datasetFilter, String name, ProvidersValidator.ProvidersPriorityType priority, String fullAccountNumberFields, ApiCallback<ProvidersCountResponse> apiCallback) throws ApiException {
        LOGGER.info("Providers getProvidersCountAsync API execution started");
        ProvidersValidator.validateGetProvidersCount(this, ApiUtils.getMethodName(), capability, datasetFilter, name, priority, fullAccountNumberFields);
        CallContext callContext = this.buildGetProvidersCountContext(capability, datasetFilter, name, priority, fullAccountNumberFields);
        callContext.getApiClient().executeAsync(callContext.getCall(), ProvidersCountResponse.class, apiCallback);
    }

    private CallContext buildGetProvidersCountContext(ProvidersValidator.ProvidersCapability capability, String datasetFilter, String name, ProvidersValidator.ProvidersPriorityType priority, String fullAccountNumberFields) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiCallModel = new ApiContext("/providers/count", HttpMethod.GET, null);
        if (capability != null) {
            apiCallModel.addQueryParam(new Pair(PARAM_CAPABILITY, capability.toString()));
        }
        if (!StringUtils.isEmpty((CharSequence)datasetFilter)) {
            apiCallModel.addQueryParam(new Pair(PARAM_DATASET$FILTER, datasetFilter));
        }
        if (!StringUtils.isEmpty((CharSequence)fullAccountNumberFields)) {
            apiCallModel.addQueryParam(new Pair(FULL_ACCT_NUMBER_FIELDS, fullAccountNumberFields));
        }
        if (!StringUtils.isEmpty((CharSequence)name)) {
            apiCallModel.addQueryParam(new Pair(PARAM_NAME, name));
        }
        if (priority != null) {
            apiCallModel.addQueryParam(new Pair(PARAM_PRIORITY, priority.toString()));
        }
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiCallModel, this.requestListener());
        return new CallContext(apiClient, call);
    }
}

