/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.api;

import com.yodlee.api.model.account.enums.ItemAccountStatus;
import com.yodlee.api.model.enums.Container;
import com.yodlee.api.model.statement.response.StatementResponse;
import com.yodlee.sdk.api.AbstractApi;
import com.yodlee.sdk.api.exception.ApiException;
import com.yodlee.sdk.api.util.ApiUtils;
import com.yodlee.sdk.api.validators.StatementsValidator;
import com.yodlee.sdk.client.ApiCallback;
import com.yodlee.sdk.client.ApiClient;
import com.yodlee.sdk.client.ApiContext;
import com.yodlee.sdk.client.ApiResponse;
import com.yodlee.sdk.client.CallContext;
import com.yodlee.sdk.client.HttpMethod;
import com.yodlee.sdk.client.Pair;
import com.yodlee.sdk.context.Context;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Min;
import okhttp3.Call;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementsApi
extends AbstractApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatementsApi.class);
    private static final String PARAM_FROM_DATE = "fromDate";
    private static final String PARAM_STATUS = "status";
    private static final String PARAM_IS_LATEST = "isLatest";
    private static final String PARAM_CONTAINER = "container";
    private static final String PARAM_ACCOUNT_ID = "accountId";

    public StatementsApi(Context<?> context) {
        super(context);
    }

    public ApiResponse<StatementResponse> getStatements(@Min(value=1L, message="{statements.param.accountId.invalid}") @Digits(message="{statements.param.accountId.invalid}", fraction=0, integer=11) Long accountId, Container container, Date fromDate, Boolean isLatest, ItemAccountStatus status) throws ApiException {
        LOGGER.info("Statements getStatements API execution started");
        StatementsValidator.validateGetStatement(this, ApiUtils.getMethodName(), accountId, container, fromDate, isLatest, status);
        CallContext callContext = this.buildGetStatementsContext(accountId, container, fromDate, isLatest, status, null);
        return callContext.getApiClient().execute(callContext.getCall(), StatementResponse.class);
    }

    public ApiResponse<StatementResponse> getStatements(@Min(value=1L, message="{statements.param.accountId.invalid}") @Digits(message="{statements.param.accountId.invalid}", fraction=0, integer=11) Long accountId, Container container, Date fromDate, Boolean isLatest, ItemAccountStatus status, Map<String, String> headers) throws ApiException {
        LOGGER.info("Statements getStatements API execution started");
        StatementsValidator.validateGetStatement(this, ApiUtils.getMethodName(), accountId, container, fromDate, isLatest, status);
        String contentEncodingValue = headers.get("Accept-Encoding");
        CallContext callContext = this.buildGetStatementsContext(accountId, container, fromDate, isLatest, status, contentEncodingValue);
        return callContext.getApiClient().execute(callContext.getCall(), StatementResponse.class);
    }

    public void getStatementsAsync(@Min(value=1L, message="{statements.param.accountId.invalid}") @Digits(message="{statements.param.accountId.invalid}", fraction=0, integer=11) Long accountId, Container container, Date fromDate, Boolean isLatest, ItemAccountStatus status, ApiCallback<StatementResponse> apiCallback) throws ApiException {
        LOGGER.info("Statements getStatementsAsync API execution started");
        StatementsValidator.validateGetStatement(this, ApiUtils.getMethodName(), accountId, container, fromDate, isLatest, status);
        CallContext callContext = this.buildGetStatementsContext(accountId, container, fromDate, isLatest, status, null);
        callContext.getApiClient().executeAsync(callContext.getCall(), StatementResponse.class, apiCallback);
    }

    private CallContext buildGetStatementsContext(Long accountId, Container container, Date fromDate, Boolean isLatest, ItemAccountStatus status, String contentEncoding) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/statements", HttpMethod.GET, null);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        if (accountId != null) {
            apiContext.addQueryParam(new Pair(PARAM_ACCOUNT_ID, accountId.toString()));
        }
        if (container != null) {
            apiContext.addQueryParam(new Pair(PARAM_CONTAINER, container.name()));
        }
        if (isLatest != null) {
            apiContext.addQueryParam(new Pair(PARAM_IS_LATEST, isLatest.toString()));
        }
        if (status != null) {
            apiContext.addQueryParam(new Pair(PARAM_STATUS, status.name()));
        }
        if (fromDate != null) {
            String formattedFromDate = formatter.format(fromDate);
            apiContext.addQueryParam(new Pair(PARAM_FROM_DATE, formattedFromDate));
        }
        if (contentEncoding != null) {
            apiContext.addHeaderParam("Accept-Encoding", contentEncoding);
        }
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }
}

