/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yodlee.api.model.AbstractModelComponent;
import com.yodlee.api.model.enums.BaseType;
import com.yodlee.api.model.enums.Container;
import com.yodlee.api.model.transaction.enums.TransactionCategoryType;
import com.yodlee.api.model.transaction.request.TransactionCategorizationRuleRequest;
import com.yodlee.api.model.transaction.request.TransactionCategoryRequest;
import com.yodlee.api.model.transaction.request.TransactionRequest;
import com.yodlee.api.model.transaction.request.UpdateCategoryRequest;
import com.yodlee.api.model.transaction.response.TransactionCategorizationRuleResponse;
import com.yodlee.api.model.transaction.response.TransactionCategoryResponse;
import com.yodlee.api.model.transaction.response.TransactionCountResponse;
import com.yodlee.api.model.transaction.response.TransactionResponse;
import com.yodlee.sdk.api.AbstractApi;
import com.yodlee.sdk.api.exception.ApiException;
import com.yodlee.sdk.api.util.ApiUtils;
import com.yodlee.sdk.api.validators.TransactionsValidator;
import com.yodlee.sdk.client.ApiCallback;
import com.yodlee.sdk.client.ApiClient;
import com.yodlee.sdk.client.ApiContext;
import com.yodlee.sdk.client.ApiResponse;
import com.yodlee.sdk.client.CallContext;
import com.yodlee.sdk.client.HttpMethod;
import com.yodlee.sdk.client.Pair;
import com.yodlee.sdk.context.Context;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import okhttp3.Call;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionsApi
extends AbstractApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionsApi.class);
    private static final String VALUE_RUN = "run";
    private static final String PARAM_ACTION = "action";
    private static final String PARAM_RULE_ID = "ruleId";
    private static final String PARAM_TRANSACTION_ID = "transactionId";
    private static final String PARAM_TYPE = "type";
    private static final String PARAM_TOP = "top";
    private static final String PARAM_TO_DATE = "toDate";
    private static final String PARAM_SKIP = "skip";
    private static final String PARAM_KEYWORD = "keyword";
    private static final String PARAM_HIGH_LEVEL_CATEGORY_ID = "highLevelCategoryId";
    private static final String PARAM_FROM_DATE = "fromDate";
    private static final String PARAM_DETAIL_CATEGORY_ID = "detailCategoryId";
    private static final String PARAM_CONTAINER = "container";
    private static final String PARAM_CATEGORY_TYPE = "categoryType";
    private static final String PARAM_CATEGORY_ID = "categoryId";
    private static final String PARAM_BASE_TYPE = "baseType";
    private static final String PARAM_ACCOUNT_ID = "accountId";

    public TransactionsApi(Context<?> context) {
        super(context);
    }

    public ApiResponse<TransactionResponse> getTransactions(@Size(min=0, max=100, message="{transactions.param.accountId.length.invalid}") Long[] accountId, BaseType baseType, @Size(min=0, max=100, message="{transactions.param.categoryId.length.invalid}") Long[] categoryId, TransactionCategoryType categoryType, Container container, @Size(min=0, max=100, message="{transactions.param.detailCategoryId.length.invalid}") Long[] detailCategoryId, Date fromDate, @Size(min=0, max=100, message="{transactions.param.highLevelCategoryId.length.invalid}") Long[] highLevelCategoryId, String keyword, @Min(value=0L, message="{transactions.param.skip.invalid}") Integer skip, Date toDate, @Min(value=1L, message="{transactions.param.top.invalid}") @Max(value=500L, message="{transactions.param.top.invalid}") Integer top, String type) throws ApiException {
        LOGGER.info("Transactions getTransactions API execution started");
        TransactionsValidator.validateGetTransactions(this, ApiUtils.getMethodName(), accountId, baseType, categoryId, categoryType, container, detailCategoryId, fromDate, highLevelCategoryId, keyword, skip, toDate, top, type);
        CallContext callContext = this.buildGetTransactionsContext(accountId, baseType, categoryId, categoryType, container, detailCategoryId, fromDate, highLevelCategoryId, keyword, skip, toDate, top, type, null);
        return callContext.getApiClient().execute(callContext.getCall(), TransactionResponse.class);
    }

    public ApiResponse<TransactionResponse> getTransactions(@Size(min=0, max=100, message="{transactions.param.accountId.length.invalid}") Long[] accountId, BaseType baseType, @Size(min=0, max=100, message="{transactions.param.categoryId.length.invalid}") Long[] categoryId, TransactionCategoryType categoryType, Container container, @Size(min=0, max=100, message="{transactions.param.detailCategoryId.length.invalid}") Long[] detailCategoryId, Date fromDate, @Size(min=0, max=100, message="{transactions.param.highLevelCategoryId.length.invalid}") Long[] highLevelCategoryId, String keyword, @Min(value=0L, message="{transactions.param.skip.invalid}") Integer skip, Date toDate, @Min(value=1L, message="{transactions.param.top.invalid}") @Max(value=500L, message="{transactions.param.top.invalid}") Integer top, String type, Map<String, String> headers) throws ApiException {
        LOGGER.info("Transactions getTransactions API execution started");
        TransactionsValidator.validateGetTransactions(this, ApiUtils.getMethodName(), accountId, baseType, categoryId, categoryType, container, detailCategoryId, fromDate, highLevelCategoryId, keyword, skip, toDate, top, type);
        String contentEncodingValue = headers.get("Accept-Encoding");
        CallContext callContext = this.buildGetTransactionsContext(accountId, baseType, categoryId, categoryType, container, detailCategoryId, fromDate, highLevelCategoryId, keyword, skip, toDate, top, type, contentEncodingValue);
        return callContext.getApiClient().execute(callContext.getCall(), TransactionResponse.class);
    }

    public void getTransactionsAsync(@Size(min=0, max=100, message="{transactions.param.accountId.length.invalid}") Long[] accountId, BaseType baseType, @Size(min=0, max=100, message="{transactions.param.categoryId.length.invalid}") Long[] categoryId, TransactionCategoryType categoryType, Container container, @Size(min=0, max=100, message="{transactions.param.detailCategoryId.length.invalid}") Long[] detailCategoryId, Date fromDate, @Size(min=0, max=100, message="{transactions.param.highLevelCategoryId.length.invalid}") Long[] highLevelCategoryId, String keyword, @Min(value=0L, message="{transactions.param.skip.invalid}") Integer skip, Date toDate, @Min(value=1L, message="{transactions.param.top.invalid}") @Max(value=500L, message="{transactions.param.top.invalid}") Integer top, String type, ApiCallback<TransactionResponse> apiCallback) throws ApiException {
        LOGGER.info("Transactions getTransactionsAsync API execution started");
        TransactionsValidator.validateGetTransactions(this, ApiUtils.getMethodName(), accountId, baseType, categoryId, categoryType, container, detailCategoryId, fromDate, highLevelCategoryId, keyword, skip, toDate, top, type);
        CallContext callContext = this.buildGetTransactionsContext(accountId, baseType, categoryId, categoryType, container, detailCategoryId, fromDate, highLevelCategoryId, keyword, skip, toDate, top, type, null);
        callContext.getApiClient().executeAsync(callContext.getCall(), TransactionResponse.class, apiCallback);
    }

    private CallContext buildGetTransactionsContext(Long[] accountId, BaseType baseType, Long[] categoryId, TransactionCategoryType categoryType, Container container, Long[] detailCategoryId, Date fromDate, Long[] highLevelCategoryId, String keyword, Integer skip, Date toDate, Integer top, String type, String contentEncoding) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/transactions", HttpMethod.GET, null);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        if (accountId != null) {
            apiContext.addQueryParam(new Pair(PARAM_ACCOUNT_ID, ApiUtils.convertArrayToString((Object[])accountId)));
        }
        if (baseType != null) {
            apiContext.addQueryParam(new Pair(PARAM_BASE_TYPE, baseType.name()));
        }
        if (categoryId != null) {
            apiContext.addQueryParam(new Pair(PARAM_CATEGORY_ID, ApiUtils.convertArrayToString((Object[])categoryId)));
        }
        if (categoryType != null) {
            apiContext.addQueryParam(new Pair(PARAM_CATEGORY_TYPE, categoryType.name()));
        }
        if (container != null) {
            apiContext.addQueryParam(new Pair(PARAM_CONTAINER, container.name()));
        }
        if (detailCategoryId != null) {
            apiContext.addQueryParam(new Pair(PARAM_DETAIL_CATEGORY_ID, ApiUtils.convertArrayToString((Object[])detailCategoryId)));
        }
        if (fromDate != null) {
            String formattedFromDate = formatter.format(fromDate);
            apiContext.addQueryParam(new Pair(PARAM_FROM_DATE, formattedFromDate));
        }
        if (highLevelCategoryId != null) {
            apiContext.addQueryParam(new Pair(PARAM_HIGH_LEVEL_CATEGORY_ID, ApiUtils.convertArrayToString((Object[])highLevelCategoryId)));
        }
        if (keyword != null) {
            apiContext.addQueryParam(new Pair(PARAM_KEYWORD, keyword));
        }
        if (skip != null) {
            apiContext.addQueryParam(new Pair(PARAM_SKIP, skip.toString()));
        }
        if (toDate != null) {
            String formattedToDate = formatter.format(toDate);
            apiContext.addQueryParam(new Pair(PARAM_TO_DATE, formattedToDate));
        }
        if (top != null) {
            apiContext.addQueryParam(new Pair(PARAM_TOP, top.toString()));
        }
        if (type != null) {
            apiContext.addQueryParam(new Pair(PARAM_TYPE, type));
        }
        if (contentEncoding != null) {
            apiContext.addHeaderParam("Accept-Encoding", contentEncoding);
        }
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<TransactionCountResponse> getTransactionsCount(@Size(min=0, max=100, message="{transactions.param.accountId.length.invalid}") Long[] accountId, BaseType baseType, @Size(min=0, max=100, message="{transactions.param.categoryId.length.invalid}") Long[] categoryId, TransactionCategoryType categoryType, Container container, @Size(min=0, max=100, message="{transactions.param.detailCategoryId.length.invalid}") Long[] detailCategoryId, Date fromDate, @Size(min=0, max=100, message="{transactions.param.highLevelCategoryId.length.invalid}") Long[] highLevelCategoryId, String keyword, Date toDate, String type) throws ApiException {
        LOGGER.info("Transactions getTransactionsCount API execution started");
        TransactionsValidator.validateGetTransactionsCount(this, ApiUtils.getMethodName(), accountId, baseType, categoryId, categoryType, container, detailCategoryId, fromDate, highLevelCategoryId, keyword, toDate, type);
        CallContext callContext = this.buildGetTransactionsCountContext(accountId, baseType, categoryId, categoryType, container, detailCategoryId, fromDate, highLevelCategoryId, keyword, toDate, type);
        return callContext.getApiClient().execute(callContext.getCall(), TransactionCountResponse.class);
    }

    public void getTransactionsCountAsync(@Size(min=0, max=100, message="{transactions.param.accountId.length.invalid}") Long[] accountId, BaseType baseType, @Size(min=0, max=100, message="{transactions.param.categoryId.length.invalid}") Long[] categoryId, TransactionCategoryType categoryType, Container container, @Size(min=0, max=100, message="{transactions.param.detailCategoryId.length.invalid}") Long[] detailCategoryId, Date fromDate, @Size(min=0, max=100, message="{transactions.param.highLevelCategoryId.length.invalid}") Long[] highLevelCategoryId, String keyword, Date toDate, String type, ApiCallback<TransactionCountResponse> apiCallback) throws ApiException {
        LOGGER.info("Transactions getTransactionsCountAsync API execution started");
        TransactionsValidator.validateGetTransactionsCount(this, ApiUtils.getMethodName(), accountId, baseType, categoryId, categoryType, container, detailCategoryId, fromDate, highLevelCategoryId, keyword, toDate, type);
        CallContext callContext = this.buildGetTransactionsCountContext(accountId, baseType, categoryId, categoryType, container, detailCategoryId, fromDate, highLevelCategoryId, keyword, toDate, type);
        callContext.getApiClient().executeAsync(callContext.getCall(), TransactionCountResponse.class, apiCallback);
    }

    private CallContext buildGetTransactionsCountContext(Long[] accountId, BaseType baseType, Long[] categoryId, TransactionCategoryType categoryType, Container container, Long[] detailCategoryId, Date fromDate, Long[] highLevelCategoryId, String keyword, Date toDate, String type) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/transactions/count", HttpMethod.GET, null);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        if (accountId != null) {
            apiContext.addQueryParam(new Pair(PARAM_ACCOUNT_ID, ApiUtils.convertArrayToString((Object[])accountId)));
        }
        if (baseType != null) {
            apiContext.addQueryParam(new Pair(PARAM_BASE_TYPE, baseType.name()));
        }
        if (categoryId != null) {
            apiContext.addQueryParam(new Pair(PARAM_CATEGORY_ID, ApiUtils.convertArrayToString((Object[])categoryId)));
        }
        if (categoryType != null) {
            apiContext.addQueryParam(new Pair(PARAM_CATEGORY_TYPE, categoryType.name()));
        }
        if (container != null) {
            apiContext.addQueryParam(new Pair(PARAM_CONTAINER, container.name()));
        }
        if (detailCategoryId != null) {
            apiContext.addQueryParam(new Pair(PARAM_DETAIL_CATEGORY_ID, ApiUtils.convertArrayToString((Object[])detailCategoryId)));
        }
        if (fromDate != null) {
            String formattedFromDate = formatter.format(fromDate);
            apiContext.addQueryParam(new Pair(PARAM_FROM_DATE, formattedFromDate));
        }
        if (highLevelCategoryId != null) {
            apiContext.addQueryParam(new Pair(PARAM_HIGH_LEVEL_CATEGORY_ID, ApiUtils.convertArrayToString((Object[])highLevelCategoryId)));
        }
        if (keyword != null) {
            apiContext.addQueryParam(new Pair(PARAM_KEYWORD, keyword));
        }
        if (toDate != null) {
            String formattedToDate = formatter.format(toDate);
            apiContext.addQueryParam(new Pair(PARAM_TO_DATE, formattedToDate));
        }
        if (type != null) {
            apiContext.addQueryParam(new Pair(PARAM_TYPE, type));
        }
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<AbstractModelComponent> updateTransaction(@Min(value=1L, message="{transactions.param.transactionId.invalid}") @Digits(message="{transactions.param.transactionId.invalid}", fraction=0, integer=11) long transactionId, @NotNull(message="{transactions.updateTransaction.required}") TransactionRequest transactionRequest) throws ApiException {
        LOGGER.info("Transactions updateTransaction API execution started");
        TransactionsValidator.validateUpdateTransaction(this, ApiUtils.getMethodName(), transactionId, transactionRequest);
        CallContext callContext = this.buildUpdateTransactionContext(transactionId, transactionRequest);
        return callContext.getApiClient().execute(callContext.getCall(), null);
    }

    public void updateTransactionAsync(@Min(value=1L, message="{transactions.param.transactionId.invalid}") @Digits(message="{transactions.param.transactionId.invalid}", fraction=0, integer=11) long transactionId, @NotNull(message="{transactions.updateTransaction.required}") TransactionRequest transactionRequest, ApiCallback<AbstractModelComponent> apiCallback) throws ApiException {
        LOGGER.info("Transactions updateTransactionAsync API execution started");
        TransactionsValidator.validateUpdateTransaction(this, ApiUtils.getMethodName(), transactionId, transactionRequest);
        CallContext callContext = this.buildUpdateTransactionContext(transactionId, transactionRequest);
        callContext.getApiClient().executeAsync(callContext.getCall(), apiCallback);
    }

    private CallContext buildUpdateTransactionContext(long transactionId, TransactionRequest transactionRequest) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        String endpoint = this.replacePathVariable("/transactions/{transactionId}", PARAM_TRANSACTION_ID, String.valueOf(transactionId));
        ApiContext apiContext = new ApiContext(endpoint, HttpMethod.PUT, transactionRequest);
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<AbstractModelComponent> createTransactionCategory(@NotNull(message="{transactions.createTransactionCategory.required}") TransactionCategoryRequest transactionCategoryRequest) throws ApiException {
        LOGGER.info("Transactions createTransactionCategory API execution started");
        TransactionsValidator.validateCreateTransactionCategory(this, ApiUtils.getMethodName(), transactionCategoryRequest);
        CallContext callContext = this.buildCreateTransactionCategoryContext(transactionCategoryRequest);
        return callContext.getApiClient().execute(callContext.getCall(), null);
    }

    public void createTransactionCategoryAsync(@NotNull(message="{transactions.createTransactionCategory.required}") TransactionCategoryRequest transactionCategoryRequest, ApiCallback<AbstractModelComponent> apiCallback) throws ApiException {
        LOGGER.info("Transactions createTransactionCategoryAsync API execution started");
        TransactionsValidator.validateCreateTransactionCategory(this, ApiUtils.getMethodName(), transactionCategoryRequest);
        CallContext callContext = this.buildCreateTransactionCategoryContext(transactionCategoryRequest);
        callContext.getApiClient().executeAsync(callContext.getCall(), apiCallback);
    }

    private CallContext buildCreateTransactionCategoryContext(TransactionCategoryRequest transactionCategoryRequest) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/transactions/categories", HttpMethod.POST, transactionCategoryRequest);
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<TransactionCategoryResponse> getTransactionCategories() throws ApiException {
        LOGGER.info("Transactions getTransactionCategories API execution started");
        TransactionsValidator.validateCobrandContext(this);
        CallContext callContext = this.buildGetTransactionCategoriesContext();
        return callContext.getApiClient().execute(callContext.getCall(), TransactionCategoryResponse.class);
    }

    public void getTransactionCategoriesAsync(ApiCallback<TransactionCategoryResponse> apiCallback) throws ApiException {
        LOGGER.info("Transactions getTransactionCategoriesAsync API execution started");
        TransactionsValidator.validateCobrandContext(this);
        CallContext callContext = this.buildGetTransactionCategoriesContext();
        callContext.getApiClient().executeAsync(callContext.getCall(), TransactionCategoryResponse.class, apiCallback);
    }

    private CallContext buildGetTransactionCategoriesContext() throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/transactions/categories", HttpMethod.GET, null);
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<AbstractModelComponent> updateTransactionCategory(@NotNull(message="{transactions.updateTransactionCategory.required}") UpdateCategoryRequest updateCategoryRequest) throws ApiException {
        LOGGER.info("Transactions updateTransactionCategory API execution started");
        TransactionsValidator.validateUpdateTransactionCategory(this, ApiUtils.getMethodName(), updateCategoryRequest);
        CallContext callContext = this.buildUpdateTransactionCategoryContext(updateCategoryRequest);
        return callContext.getApiClient().execute(callContext.getCall(), null);
    }

    public void updateTransactionCategoryAsync(@NotNull(message="{transactions.updateTransactionCategory.required}") UpdateCategoryRequest updateCategoryRequest, ApiCallback<AbstractModelComponent> apiCallback) throws ApiException {
        LOGGER.info("Transactions updateTransactionCategoryAsync API execution started");
        TransactionsValidator.validateUpdateTransactionCategory(this, ApiUtils.getMethodName(), updateCategoryRequest);
        CallContext callContext = this.buildUpdateTransactionCategoryContext(updateCategoryRequest);
        callContext.getApiClient().executeAsync(callContext.getCall(), apiCallback);
    }

    private CallContext buildUpdateTransactionCategoryContext(UpdateCategoryRequest updateCategoryRequest) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/transactions/categories", HttpMethod.PUT, updateCategoryRequest);
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<AbstractModelComponent> deleteTransactionCategory(@Min(value=1L, message="{transactions.param.categoryId.invalid}") @Digits(message="{transactions.param.categoryId.invalid}", fraction=0, integer=11) long categoryId) throws ApiException {
        LOGGER.info("Transactions deleteTransactionCategoryAsync API execution started");
        TransactionsValidator.validateDeleteTransactionCategory(this, ApiUtils.getMethodName(), categoryId);
        CallContext callContext = this.buildDeleteTransactionCategoryContext(categoryId);
        return callContext.getApiClient().execute(callContext.getCall(), null);
    }

    public void deleteTransactionCategoryAsync(@Min(value=1L, message="{transactions.param.categoryId.invalid}") @Digits(message="{transactions.param.categoryId.invalid}", fraction=0, integer=11) long categoryId, ApiCallback<AbstractModelComponent> apiCallback) throws ApiException {
        LOGGER.info("Transactions deleteTransactionCategoryAsync API execution started");
        TransactionsValidator.validateDeleteTransactionCategory(this, ApiUtils.getMethodName(), categoryId);
        CallContext callContext = this.buildDeleteTransactionCategoryContext(categoryId);
        callContext.getApiClient().executeAsync(callContext.getCall(), apiCallback);
    }

    private CallContext buildDeleteTransactionCategoryContext(long categoryId) throws ApiException {
        String endpoint = this.replacePathVariable("/transactions/categories/{categoryId}", PARAM_CATEGORY_ID, String.valueOf(categoryId));
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext(endpoint, HttpMethod.DELETE, null);
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<TransactionCategorizationRuleResponse> getTransactionCategorizationRules() throws ApiException {
        LOGGER.info("Transactions getTransactionCategorizationRules API execution started");
        TransactionsValidator.validateContext(this);
        CallContext callContext = this.buildGetTransactionCategorizationRulesContext();
        return callContext.getApiClient().execute(callContext.getCall(), TransactionCategorizationRuleResponse.class);
    }

    public void getTransactionCategorizationRulesAsync(ApiCallback<TransactionCategorizationRuleResponse> apiCallback) throws ApiException {
        LOGGER.info("Transactions getTransactionCategorizationRulesAsync API execution started");
        TransactionsValidator.validateContext(this);
        CallContext callContext = this.buildGetTransactionCategorizationRulesContext();
        callContext.getApiClient().executeAsync(callContext.getCall(), TransactionCategorizationRuleResponse.class, apiCallback);
    }

    private CallContext buildGetTransactionCategorizationRulesContext() throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/transactions/categories/txnRules", HttpMethod.GET, null);
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<AbstractModelComponent> createTransactionCategorizationRules(@NotNull(message="transactions.createTransactionCategorizationRules.required") TransactionCategorizationRuleRequest transactionCategorizationRuleRequest) throws ApiException {
        LOGGER.info("Transactions createTransactionCategorizationRules API execution started");
        TransactionsValidator.validateCreateTransactionCategorizationRules(this, ApiUtils.getMethodName(), transactionCategorizationRuleRequest);
        CallContext callContext = this.buildCreateTransactionCategorizationRulesContext(transactionCategorizationRuleRequest);
        return callContext.getApiClient().execute(callContext.getCall(), null);
    }

    public void createTransactionCategorizationRulesAsync(@NotNull(message="transactions.createTransactionCategorizationRules.required") TransactionCategorizationRuleRequest transactionCategorizationRuleRequest, ApiCallback<AbstractModelComponent> apiCallback) throws ApiException {
        LOGGER.info("Transactions createTransactionCategorizationRulesAsync API execution started");
        TransactionsValidator.validateCreateTransactionCategorizationRules(this, ApiUtils.getMethodName(), transactionCategorizationRuleRequest);
        CallContext callContext = this.buildCreateTransactionCategorizationRulesContext(transactionCategorizationRuleRequest);
        callContext.getApiClient().executeAsync(callContext.getCall(), apiCallback);
    }

    private CallContext buildCreateTransactionCategorizationRulesContext(TransactionCategorizationRuleRequest transactionCategorizationRuleRequest) throws ApiException {
        String ruleParamValue = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            ruleParamValue = mapper.writeValueAsString((Object)transactionCategorizationRuleRequest);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Already validated, exception will never occur.");
        }
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/transactions/categories/rules", HttpMethod.POST, null);
        apiContext.addQueryParam(new Pair("ruleParam", ruleParamValue));
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<AbstractModelComponent> runTransactionCategorizationRules() throws ApiException {
        LOGGER.info("Transactions runTransactionCategorizationRules API execution started");
        TransactionsValidator.validateContext(this);
        CallContext callContext = this.buildRunTransactionCategorizationRulesContext();
        return callContext.getApiClient().execute(callContext.getCall(), null);
    }

    public void runTransactionCategorizationRulesAsync(ApiCallback<AbstractModelComponent> apiCallback) throws ApiException {
        LOGGER.info("Transactions runTransactionCategorizationRulesAsync API execution started");
        TransactionsValidator.validateContext(this);
        CallContext callContext = this.buildRunTransactionCategorizationRulesContext();
        callContext.getApiClient().executeAsync(callContext.getCall(), apiCallback);
    }

    private CallContext buildRunTransactionCategorizationRulesContext() throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/transactions/categories/rules", HttpMethod.POST, null);
        apiContext.addQueryParam(new Pair(PARAM_ACTION, VALUE_RUN));
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<AbstractModelComponent> runTransactionCategorizationRule(@Min(value=1L, message="{transactions.param.ruleId.invalid}") @Digits(message="{transactions.param.ruleId.invalid}", fraction=0, integer=11) long ruleId) throws ApiException {
        LOGGER.info("Transactions runTransactionCategorizationRule API execution started");
        TransactionsValidator.validateRunOrDeleteTransactionCategorizationRule(this, ApiUtils.getMethodName(), ruleId);
        CallContext callContext = this.buildRunTransactionCategorizationRuleContext(ruleId);
        return callContext.getApiClient().execute(callContext.getCall(), null);
    }

    public void runTransactionCategorizationRuleAsync(@Min(value=1L, message="{transactions.param.ruleId.invalid}") @Digits(message="{transactions.param.ruleId.invalid}", fraction=0, integer=11) long ruleId, ApiCallback<AbstractModelComponent> apiCallback) throws ApiException {
        LOGGER.info("Transactions runTransactionCategorizationRuleAsync API execution started");
        TransactionsValidator.validateRunOrDeleteTransactionCategorizationRule(this, ApiUtils.getMethodName(), ruleId);
        CallContext callContext = this.buildRunTransactionCategorizationRuleContext(ruleId);
        callContext.getApiClient().executeAsync(callContext.getCall(), apiCallback);
    }

    private CallContext buildRunTransactionCategorizationRuleContext(long ruleId) throws ApiException {
        String endpoint = this.replacePathVariable("/transactions/categories/rules/{ruleId}", PARAM_RULE_ID, String.valueOf(ruleId));
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext(endpoint, HttpMethod.POST, null);
        apiContext.addQueryParam(new Pair(PARAM_ACTION, VALUE_RUN));
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<AbstractModelComponent> updateTransactionCategorizationRule(@Min(value=1L, message="{transactions.param.ruleId.invalid}") @Digits(message="{transactions.param.ruleId.invalid}", fraction=0, integer=11) long ruleId, @NotNull(message="{transactions.updateTransactionCategorizationRule.required}") TransactionCategorizationRuleRequest transactionCategoriesRuleRequest) throws ApiException {
        LOGGER.info("Transactions updateTransactionCategorizationRule API execution started");
        TransactionsValidator.validateUpdateTransactionCategorizationRule(this, ApiUtils.getMethodName(), ruleId, transactionCategoriesRuleRequest);
        CallContext callContext = this.buildUpdateTransactionCategorizationRuleContext(ruleId, transactionCategoriesRuleRequest);
        return callContext.getApiClient().execute(callContext.getCall(), null);
    }

    public void updateTransactionCategorizationRuleAsync(@Min(value=1L, message="{transactions.param.ruleId.invalid}") @Digits(message="{transactions.param.ruleId.invalid}", fraction=0, integer=11) long ruleId, @NotNull(message="{transactions.updateTransactionCategorizationRule.required}") TransactionCategorizationRuleRequest transactionCategoriesRuleRequest, ApiCallback<AbstractModelComponent> apiCallback) throws ApiException {
        LOGGER.info("Transactions updateTransactionCategorizationRuleAsync API execution started");
        TransactionsValidator.validateUpdateTransactionCategorizationRule(this, ApiUtils.getMethodName(), ruleId, transactionCategoriesRuleRequest);
        CallContext callContext = this.buildUpdateTransactionCategorizationRuleContext(ruleId, transactionCategoriesRuleRequest);
        callContext.getApiClient().executeAsync(callContext.getCall(), apiCallback);
    }

    private CallContext buildUpdateTransactionCategorizationRuleContext(long ruleId, TransactionCategorizationRuleRequest transactionCategoriesRuleRequest) throws ApiException {
        String endpoint = this.replacePathVariable("/transactions/categories/rules/{ruleId}", PARAM_RULE_ID, String.valueOf(ruleId));
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext(endpoint, HttpMethod.PUT, transactionCategoriesRuleRequest);
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<AbstractModelComponent> deleteTransactionCategorizationRule(@Min(value=1L, message="{transactions.param.ruleId.invalid}") @Digits(message="{transactions.param.ruleId.invalid}", fraction=0, integer=11) long ruleId) throws ApiException {
        LOGGER.info("Transactions deleteTransactionCategorizationRule API execution started");
        TransactionsValidator.validateRunOrDeleteTransactionCategorizationRule(this, ApiUtils.getMethodName(), ruleId);
        CallContext callContext = this.buildDeleteTransactionCategorizationRuleContext(ruleId);
        return callContext.getApiClient().execute(callContext.getCall(), null);
    }

    public void deleteTransactionCategorizationRuleAsync(@Min(value=1L, message="{transactions.param.ruleId.invalid}") @Digits(message="{transactions.param.ruleId.invalid}", fraction=0, integer=11) long ruleId, ApiCallback<AbstractModelComponent> apiCallback) throws ApiException {
        LOGGER.info("Transactions deleteTransactionCategorizationRuleAsync API execution started");
        TransactionsValidator.validateRunOrDeleteTransactionCategorizationRule(this, ApiUtils.getMethodName(), ruleId);
        CallContext callContext = this.buildDeleteTransactionCategorizationRuleContext(ruleId);
        callContext.getApiClient().executeAsync(callContext.getCall(), apiCallback);
    }

    private CallContext buildDeleteTransactionCategorizationRuleContext(long ruleId) throws ApiException {
        String endpoint = this.replacePathVariable("/transactions/categories/rules/{ruleId}", PARAM_RULE_ID, String.valueOf(ruleId));
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext(endpoint, HttpMethod.DELETE, null);
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }
}

