/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.api;

import com.yodlee.api.model.AbstractModelComponent;
import com.yodlee.api.model.user.request.UpdateUserRequest;
import com.yodlee.api.model.user.request.UserRequest;
import com.yodlee.api.model.user.response.UserAccessTokensResponse;
import com.yodlee.api.model.user.response.UserDetailResponse;
import com.yodlee.api.model.user.response.UserResponse;
import com.yodlee.sdk.api.AbstractApi;
import com.yodlee.sdk.api.exception.ApiException;
import com.yodlee.sdk.api.util.ApiUtils;
import com.yodlee.sdk.api.validators.UserValidator;
import com.yodlee.sdk.client.ApiCallback;
import com.yodlee.sdk.client.ApiClient;
import com.yodlee.sdk.client.ApiContext;
import com.yodlee.sdk.client.ApiResponse;
import com.yodlee.sdk.client.CallContext;
import com.yodlee.sdk.client.HttpMethod;
import com.yodlee.sdk.client.Pair;
import com.yodlee.sdk.configuration.user.UserConfiguration;
import com.yodlee.sdk.context.CobrandContext;
import com.yodlee.sdk.context.Context;
import com.yodlee.sdk.context.UserContext;
import javax.validation.constraints.NotNull;
import okhttp3.Call;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserApi
extends AbstractApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserApi.class);
    private static final String PARAM_APP_IDS = "appIds";
    private static final String PARAM_SOURCE = "source";
    private static final String PARAM_ISSUER = "issuer";
    private static final String PARAM_SAML_RESPONSE = "samlResponse";
    private final UserConfiguration configuration;

    public UserApi(Context<?> context, UserConfiguration configuration) {
        super(context);
        this.configuration = configuration;
    }

    public UserApi(Context<?> context) {
        this(context, null);
    }

    public ApiResponse<UserResponse> samlLogin(@NotEmpty(message="{user.param.samlResponse.required}") String samlResponse, @NotEmpty(message="{user.param.issuer.required}") String issuer, String source) throws ApiException {
        LOGGER.info("User SamlLogin API execution started");
        UserValidator.validateSamlLogin(this, ApiUtils.getMethodName(), samlResponse, issuer, source);
        CallContext callContext = this.buildSamlLoginContext(samlResponse, issuer, source);
        ApiResponse<UserResponse> userResponse = callContext.getApiClient().execute(callContext.getCall(), UserResponse.class);
        UserContext userContext = new UserContext(((CobrandContext)this.getContext()).getCobSession(), userResponse.getData().getUser().getSession().getUserSession(), this.configuration);
        this.setContext(userContext);
        LOGGER.info("User SamlLogin API execution ended after setting userContext");
        return userResponse;
    }

    public void samlLoginAsync(@NotEmpty(message="{user.param.samlResponse.required}") String samlResponse, @NotEmpty(message="{user.param.issuer.required}") String issuer, String source, ApiCallback<UserResponse> apiCallback) throws ApiException {
        LOGGER.info("User SamlLoginAsync API execution started");
        UserValidator.validateSamlLogin(this, ApiUtils.getMethodName(), samlResponse, issuer, source);
        CallContext callContext = this.buildSamlLoginContext(samlResponse, issuer, source);
        callContext.getApiClient().executeAsync(callContext.getCall(), UserResponse.class, apiCallback);
    }

    private CallContext buildSamlLoginContext(String samlResponse, String issuer, String source) throws ApiException {
        ApiContext apiContext = new ApiContext("/user/samlLogin", HttpMethod.POST, null);
        apiContext.addQueryParam(new Pair(PARAM_SAML_RESPONSE, samlResponse));
        apiContext.addQueryParam(new Pair(PARAM_ISSUER, issuer));
        apiContext.addQueryParam(new Pair(PARAM_SOURCE, source));
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<UserResponse> registerUser(@NotNull(message="{user.UserRequest.required}") UserRequest userRequest) throws ApiException {
        LOGGER.info("User registerUser API execution started");
        UserValidator.validateRegisterUser(this, ApiUtils.getMethodName(), userRequest);
        CallContext callContext = this.buildRegisterUserContext(userRequest);
        return callContext.getApiClient().execute(callContext.getCall(), UserResponse.class);
    }

    public void registerUserAsync(@NotNull(message="{user.UserRequest.required}") UserRequest userRequest, ApiCallback<UserResponse> apiCallback) throws ApiException {
        LOGGER.info("User registerUserAsync API execution started");
        UserValidator.validateRegisterUser(this, ApiUtils.getMethodName(), userRequest);
        CallContext callContext = this.buildRegisterUserContext(userRequest);
        callContext.getApiClient().executeAsync(callContext.getCall(), UserResponse.class, apiCallback);
    }

    private CallContext buildRegisterUserContext(UserRequest userRequest) throws ApiException {
        ApiContext apiContext = new ApiContext("/user/register", HttpMethod.POST, userRequest);
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<UserDetailResponse> getUser() throws ApiException {
        LOGGER.info("User getUser API execution started");
        UserValidator.validateApiContext(this);
        CallContext callContext = this.buildGetUserContext();
        return callContext.getApiClient().execute(callContext.getCall(), UserDetailResponse.class);
    }

    public void getUserAsync(ApiCallback<UserDetailResponse> apiCallback) throws ApiException {
        LOGGER.info("User getUserAsync API execution started");
        UserValidator.validateApiContext(this);
        CallContext callContext = this.buildGetUserContext();
        callContext.getApiClient().executeAsync(callContext.getCall(), UserDetailResponse.class, apiCallback);
    }

    private CallContext buildGetUserContext() throws ApiException {
        ApiContext apiContext = new ApiContext("/user", HttpMethod.GET, null);
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<AbstractModelComponent> userLogout() throws ApiException {
        LOGGER.info("User userLogout API execution started");
        UserValidator.validateApiContext(this);
        CallContext callContext = this.buildUserLogoutContext();
        return callContext.getApiClient().execute(callContext.getCall(), null);
    }

    public void userLogoutAsync(ApiCallback<AbstractModelComponent> apiCallback) throws ApiException {
        LOGGER.info("User userLogoutAsync API execution started");
        UserValidator.validateApiContext(this);
        CallContext callContext = this.buildUserLogoutContext();
        callContext.getApiClient().executeAsync(callContext.getCall(), apiCallback);
    }

    private CallContext buildUserLogoutContext() throws ApiException {
        ApiContext apiContext = new ApiContext("/user/logout", HttpMethod.POST, null);
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<AbstractModelComponent> updateUser(@NotNull(message="{user.UpdateUserRequest.required}") UpdateUserRequest userRequest) throws ApiException {
        LOGGER.info("User updateUser API execution started");
        UserValidator.validateUpdateUser(this, ApiUtils.getMethodName(), userRequest);
        CallContext callContext = this.buildUpdateUserContext(userRequest);
        return callContext.getApiClient().execute(callContext.getCall(), null);
    }

    public void updateUserAsync(@NotNull(message="{user.UpdateUserRequest.required}") UpdateUserRequest userRequest, ApiCallback<AbstractModelComponent> apiCallback) throws ApiException {
        LOGGER.info("User updateUserAsync API execution started");
        UserValidator.validateUpdateUser(this, ApiUtils.getMethodName(), userRequest);
        CallContext callContext = this.buildUpdateUserContext(userRequest);
        callContext.getApiClient().executeAsync(callContext.getCall(), apiCallback);
    }

    private CallContext buildUpdateUserContext(UpdateUserRequest userRequest) throws ApiException {
        ApiContext apiContext = new ApiContext("/user", HttpMethod.PUT, userRequest);
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<UserAccessTokensResponse> getAccessTokens(@NotEmpty(message="{user.param.finappId.required}") Long[] appIds) throws ApiException {
        LOGGER.info("User getAccessToken API execution started");
        UserValidator.validateGetAccessTokens(this, ApiUtils.getMethodName(), appIds);
        CallContext callContext = this.buildGetAccessTokensContext(appIds);
        return callContext.getApiClient().execute(callContext.getCall(), UserAccessTokensResponse.class);
    }

    public void getAccessTokensAsync(@NotEmpty(message="{user.param.finappId.required}") Long[] appIds, ApiCallback<UserAccessTokensResponse> apiCallback) throws ApiException {
        LOGGER.info("User getAccessTokensAsync API execution started");
        UserValidator.validateGetAccessTokens(this, ApiUtils.getMethodName(), appIds);
        CallContext callContext = this.buildGetAccessTokensContext(appIds);
        callContext.getApiClient().executeAsync(callContext.getCall(), UserAccessTokensResponse.class, apiCallback);
    }

    private CallContext buildGetAccessTokensContext(Long[] appIds) throws ApiException {
        ApiContext apiContext = new ApiContext("/user/accessTokens", HttpMethod.GET, null);
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        apiContext.addQueryParam(new Pair(PARAM_APP_IDS, ApiUtils.convertArrayToString((Object[])appIds)));
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<AbstractModelComponent> unregister() throws ApiException {
        LOGGER.info("User unregister API execution started");
        UserValidator.validateApiContext(this);
        CallContext callContext = this.buildUnregisterContext();
        return callContext.getApiClient().execute(callContext.getCall(), null);
    }

    public void unregisterAsync(ApiCallback<AbstractModelComponent> apiCallback) throws ApiException {
        LOGGER.info("User unregisterAsync API execution started");
        UserValidator.validateApiContext(this);
        CallContext callContext = this.buildUnregisterContext();
        callContext.getApiClient().executeAsync(callContext.getCall(), apiCallback);
    }

    private CallContext buildUnregisterContext() throws ApiException {
        ApiContext apiContext = new ApiContext("/user/unregister", HttpMethod.DELETE, null);
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }
}

