/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.api;

import com.yodlee.api.model.verification.enums.VerificationType;
import com.yodlee.api.model.verification.enums.VerifiedAccountsVerificationStatus;
import com.yodlee.api.model.verification.request.UpdateVerificationRequest;
import com.yodlee.api.model.verification.request.VerificationMatchingRequest;
import com.yodlee.api.model.verification.request.VerificationRequest;
import com.yodlee.api.model.verification.response.VerificationResponse;
import com.yodlee.api.model.verification.response.VerificationStatusResponse;
import com.yodlee.api.model.verification.response.VerifiedAccountResponse;
import com.yodlee.sdk.api.AbstractApi;
import com.yodlee.sdk.api.exception.ApiException;
import com.yodlee.sdk.api.util.ApiUtils;
import com.yodlee.sdk.api.validators.VerificationValidator;
import com.yodlee.sdk.client.ApiCallback;
import com.yodlee.sdk.client.ApiClient;
import com.yodlee.sdk.client.ApiContext;
import com.yodlee.sdk.client.ApiResponse;
import com.yodlee.sdk.client.CallContext;
import com.yodlee.sdk.client.HttpMethod;
import com.yodlee.sdk.client.Pair;
import com.yodlee.sdk.context.Context;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import okhttp3.Call;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerificationApi
extends AbstractApi {
    private static final String VERIFICATION_TYPE = "verificationType";
    private static final String PARAM_PROVIDER_ACCOUNT_ID = "providerAccountId";
    private static final String PARAM_ACCOUNT_ID = "accountId";
    private static final String PARAM_VERIFICATION_STATUS = "verificationStatus";
    private static final String PARAM_IS_SELECTED = "isSelected";
    private static final Logger LOGGER = LoggerFactory.getLogger(VerificationApi.class);

    public VerificationApi(Context<?> context) {
        super(context);
    }

    public ApiResponse<VerificationStatusResponse> getVerificationDetails(Long[] accountId, Long[] providerAccountId, VerificationType verificationType) throws ApiException {
        LOGGER.info("Verification GetVerificationDetails API execution started");
        VerificationValidator.validateGetVerificationDetails(this, ApiUtils.getMethodName(), providerAccountId, accountId, verificationType);
        CallContext callContext = this.buildGetVerificationDetailsContext(accountId, providerAccountId, verificationType);
        return callContext.getApiClient().execute(callContext.getCall(), VerificationStatusResponse.class);
    }

    public void getVerificationDetailsAsync(Long[] accountId, Long[] providerAccountId, VerificationType verificationType, ApiCallback<VerificationStatusResponse> apiCallback) throws ApiException {
        LOGGER.info("Verification GetVerificationDetailsAsync API execution started");
        VerificationValidator.validateGetVerificationDetails(this, ApiUtils.getMethodName(), providerAccountId, accountId, verificationType);
        CallContext callContext = this.buildGetVerificationDetailsContext(accountId, providerAccountId, verificationType);
        callContext.getApiClient().executeAsync(callContext.getCall(), VerificationStatusResponse.class, apiCallback);
    }

    private CallContext buildGetVerificationDetailsContext(Long[] accountId, Long[] providerAccountId, VerificationType verificationType) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/verification", HttpMethod.GET, null);
        if (accountId != null && accountId.length > 0) {
            apiContext.addQueryParam(new Pair(PARAM_ACCOUNT_ID, ApiUtils.convertArrayToString((Object[])accountId)));
        }
        if (providerAccountId != null && providerAccountId.length > 0) {
            apiContext.addQueryParam(new Pair(PARAM_PROVIDER_ACCOUNT_ID, ApiUtils.convertArrayToString((Object[])providerAccountId)));
        }
        if (verificationType != null) {
            apiContext.addQueryParam(new Pair(VERIFICATION_TYPE, verificationType.toString()));
        }
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<VerificationResponse> initiateCDVerification(@NotNull(message="{verifications.VerificationRequest.required}") VerificationRequest verificationParam) throws ApiException {
        LOGGER.info("Verification InitiateCDVerification execution started");
        VerificationValidator.validateInitiateCDVerification(this, ApiUtils.getMethodName(), verificationParam);
        CallContext callContext = this.buildInitiateCDVerificationContext(verificationParam);
        return callContext.getApiClient().execute(callContext.getCall(), VerificationResponse.class);
    }

    public void initiateCDVerificationAsync(@NotNull(message="{verifications.VerificationRequest.required}") VerificationRequest verificationParam, ApiCallback<VerificationResponse> apiCallback) throws ApiException {
        LOGGER.info("Verification InitiateCDVerificationAsync execution started");
        VerificationValidator.validateInitiateCDVerification(this, ApiUtils.getMethodName(), verificationParam);
        CallContext callContext = this.buildInitiateCDVerificationContext(verificationParam);
        callContext.getApiClient().executeAsync(callContext.getCall(), VerificationResponse.class, apiCallback);
    }

    private CallContext buildInitiateCDVerificationContext(VerificationRequest verificationParam) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/verification", HttpMethod.POST, verificationParam);
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<VerificationResponse> performMatchingVerification(@NotNull(message="{verifications.VerificationMatchingRequest.required}") VerificationMatchingRequest verificationParam) throws ApiException {
        LOGGER.info("Verification PerformMatchingVerificationAsync execution started");
        VerificationValidator.validateMatchingVerification(this, ApiUtils.getMethodName(), verificationParam);
        CallContext callContext = this.buildPerformMatchingVerificationContext(verificationParam);
        return callContext.getApiClient().execute(callContext.getCall(), VerificationResponse.class);
    }

    public void performMatchingVerificationAsync(@NotNull(message="{verifications.VerificationMatchingRequest.required}") VerificationMatchingRequest verificationParam, ApiCallback<VerificationResponse> apiCallback) throws ApiException {
        LOGGER.info("Verification PerformMatchingVerificationAsync execution started");
        VerificationValidator.validateMatchingVerification(this, ApiUtils.getMethodName(), verificationParam);
        CallContext callContext = this.buildPerformMatchingVerificationContext(verificationParam);
        callContext.getApiClient().executeAsync(callContext.getCall(), VerificationResponse.class, apiCallback);
    }

    private CallContext buildPerformMatchingVerificationContext(VerificationMatchingRequest verificationParam) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/verification", HttpMethod.POST, verificationParam);
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<VerificationResponse> performCDVerification(@NotNull(message="{verifications.UpdateVerificationRequest.required}") UpdateVerificationRequest updateVerificationRequest) throws ApiException {
        LOGGER.info("Verification PerformCDVerification API execution started");
        VerificationValidator.validatePerformCDVerification(this, ApiUtils.getMethodName(), updateVerificationRequest);
        CallContext callContext = this.buildPerformCDVerificationContext(updateVerificationRequest);
        return callContext.getApiClient().execute(callContext.getCall(), VerificationResponse.class);
    }

    public void performCDVerificationAsync(@NotNull(message="{verifications.UpdateVerificationRequest.required}") UpdateVerificationRequest updateVerificationRequest, ApiCallback<VerificationResponse> apiCallback) throws ApiException {
        LOGGER.info("Verification PerformCDVerificationAsync API execution started");
        VerificationValidator.validatePerformCDVerification(this, ApiUtils.getMethodName(), updateVerificationRequest);
        CallContext callContext = this.buildPerformCDVerificationContext(updateVerificationRequest);
        callContext.getApiClient().executeAsync(callContext.getCall(), VerificationResponse.class, apiCallback);
    }

    private CallContext buildPerformCDVerificationContext(UpdateVerificationRequest updateVerificationRequest) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/verification", HttpMethod.PUT, updateVerificationRequest);
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }

    public ApiResponse<VerifiedAccountResponse> getVerifiedAccounts(@NotNull(message="{verifications.param.providerAccountId.provided}") long providerAccountId, @Size(min=0, max=10, message="{verifications.param.accountId.length.invalid}") Long[] accountId, @Size(min=0, max=2, message="{verifications.param.verificationstatus.length.invalid}") VerifiedAccountsVerificationStatus[] verificationStatus, @Size(min=0, max=2, message="{verifications.param.isselected.length.invalid}") String[] isSelected) throws ApiException {
        LOGGER.info("Verification getVerifiedAccounts API execution started");
        VerificationValidator.validateVerifiedAccounts(this, ApiUtils.getMethodName(), providerAccountId, accountId, verificationStatus, isSelected);
        CallContext callContext = this.buildVerifiedAccountsContext(providerAccountId, accountId, verificationStatus, isSelected);
        return callContext.getApiClient().execute(callContext.getCall(), VerifiedAccountResponse.class);
    }

    public void getVerifiedAccountsAsync(@NotNull(message="{providerAccounts.param.providerAccountId.required}") long providerAccountId, Long[] accountId, VerifiedAccountsVerificationStatus[] verificationStatus, String[] isSelected, ApiCallback<VerifiedAccountResponse> apiCallback) throws ApiException {
        LOGGER.info("Verification getVerifiedAccounts API execution started");
        VerificationValidator.validateVerifiedAccounts(this, ApiUtils.getMethodName(), providerAccountId, accountId, verificationStatus, isSelected);
        CallContext callContext = this.buildVerifiedAccountsContext(providerAccountId, accountId, verificationStatus, isSelected);
        callContext.getApiClient().executeAsync(callContext.getCall(), VerifiedAccountResponse.class, apiCallback);
    }

    private CallContext buildVerifiedAccountsContext(long providerAccountId, Long[] accountId, VerifiedAccountsVerificationStatus[] verificationStatus, String[] isSelected) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        ApiContext apiContext = new ApiContext("/verification/verifiedAccounts", HttpMethod.GET, null);
        apiContext.addQueryParam(new Pair(PARAM_PROVIDER_ACCOUNT_ID, String.valueOf(providerAccountId)));
        if (null != accountId) {
            apiContext.addQueryParam(new Pair(PARAM_ACCOUNT_ID, ApiUtils.convertArrayToString((Object[])accountId)));
        }
        if (null != verificationStatus) {
            apiContext.addQueryParam(new Pair(PARAM_VERIFICATION_STATUS, ApiUtils.convertArrayToString(verificationStatus)));
        }
        if (null != isSelected) {
            apiContext.addQueryParam(new Pair(PARAM_IS_SELECTED, ApiUtils.convertArrayToString(isSelected)));
        }
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }
}

