/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.api;

import com.yodlee.api.model.verifyaccount.request.VerifyAccountRequest;
import com.yodlee.api.model.verifyaccount.response.VerifyAccountResponse;
import com.yodlee.sdk.api.AbstractApi;
import com.yodlee.sdk.api.exception.ApiException;
import com.yodlee.sdk.api.util.ApiUtils;
import com.yodlee.sdk.api.validators.VerifyAccountValidator;
import com.yodlee.sdk.client.ApiCallback;
import com.yodlee.sdk.client.ApiClient;
import com.yodlee.sdk.client.ApiContext;
import com.yodlee.sdk.client.ApiResponse;
import com.yodlee.sdk.client.CallContext;
import com.yodlee.sdk.client.HttpMethod;
import com.yodlee.sdk.context.Context;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import okhttp3.Call;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyAccountApi
extends AbstractApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(VerifyAccountApi.class);
    private static final String PROVIDER_ACCOUNT_ID = "providerAccountId";

    public VerifyAccountApi(Context<?> context) {
        super(context);
    }

    public ApiResponse<VerifyAccountResponse> verifyAccounts(@Digits(message="{verifyAccounts.param.providerAccountId.invalid}", fraction=0, integer=11) long providerAccountId, @NotNull(message="{verifyAccounts.verifyAccountRequest.required}") VerifyAccountRequest verificationParam) throws ApiException {
        LOGGER.info("VerifyAccounts API execution started");
        VerifyAccountValidator.validatePostVerifyAccount(this, ApiUtils.getMethodName(), providerAccountId, verificationParam);
        CallContext callContext = this.buildverifyAccountsContext(providerAccountId, verificationParam);
        return callContext.getApiClient().execute(callContext.getCall(), VerifyAccountResponse.class);
    }

    public void verifyAccountsAsync(@Digits(message="{verifyAccounts.param.providerAccountId.invalid}", fraction=0, integer=11) long providerAccountId, @NotNull(message="{verifyAccounts.verifyAccountRequest.required}") VerifyAccountRequest verificationParam, ApiCallback<VerifyAccountResponse> apiCallback) throws ApiException {
        LOGGER.info("VerifyAccountsAsync API execution started");
        VerifyAccountValidator.validatePostVerifyAccount(this, ApiUtils.getMethodName(), providerAccountId, verificationParam);
        CallContext callContext = this.buildverifyAccountsContext(providerAccountId, verificationParam);
        callContext.getApiClient().executeAsync(callContext.getCall(), VerifyAccountResponse.class, apiCallback);
    }

    private CallContext buildverifyAccountsContext(long providerAccountId, VerifyAccountRequest verificationParam) throws ApiException {
        ApiClient apiClient = this.getContext().getApiClient(this.getRequestHeaderMap());
        String apiEndPoint = this.replacePathVariable("/verifyAccount/{providerAccountId}", PROVIDER_ACCOUNT_ID, String.valueOf(providerAccountId));
        ApiContext apiContext = new ApiContext(apiEndPoint, HttpMethod.POST, verificationParam);
        this.registerResponseInterceptor(apiClient);
        Call call = apiClient.buildCall(apiContext, this.requestListener());
        return new CallContext(apiClient, call);
    }
}

