/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.api.exception;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yodlee.api.model.YodleeError;
import com.yodlee.api.model.validator.Problem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiException
extends Exception {
    private static final long serialVersionUID = 755063301177528109L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiException.class);
    private final boolean isClientSideError;
    private final int httpStatus;
    private final String responseBody;
    private final transient YodleeError serverError;
    private final transient List<Problem> problems = new ArrayList<Problem>();
    private final transient Map<String, List<String>> responseHeaders = new HashMap<String, List<String>>();

    public ApiException(Throwable throwable) {
        this(throwable.getMessage(), Collections.emptyList(), throwable, 0, Collections.emptyMap(), null, false);
    }

    public ApiException(String message) {
        this(message, Collections.emptyList(), null, 0, Collections.emptyMap(), null, false);
    }

    public ApiException(List<Problem> problems) {
        this("Validation failed.", problems, null, 0, Collections.emptyMap(), null, true);
    }

    public ApiException(List<Problem> problems, String message, boolean isClientSideError) {
        this(message, problems, null, 0, null, null, isClientSideError);
    }

    public ApiException(String message, int httpStatus, Map<String, List<String>> responseHeaders, String responseBody) {
        this(message, Collections.emptyList(), null, httpStatus, responseHeaders, responseBody, false);
    }

    public ApiException(String message, Throwable throwable, int httpStatus, Map<String, List<String>> responseHeaders) {
        this(message, Collections.emptyList(), throwable, httpStatus, responseHeaders, null, false);
    }

    public ApiException(String message, List<Problem> problems, Throwable throwable, int httpStatus, Map<String, List<String>> responseHeaders, String responseBody, boolean isClientSideError) {
        super(message, throwable);
        this.httpStatus = httpStatus;
        this.problems.addAll(problems);
        this.responseHeaders.putAll(responseHeaders);
        this.responseBody = responseBody;
        this.isClientSideError = isClientSideError;
        YodleeError yodleeError = null;
        if (responseBody != null) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                yodleeError = (YodleeError)mapper.readValue(responseBody, YodleeError.class);
            }
            catch (IOException e) {
                LOGGER.error("Exception occurred.", (Throwable)e);
            }
        }
        this.serverError = yodleeError == null ? null : yodleeError;
    }

    public List<Problem> getProblems() {
        return Collections.unmodifiableList(this.problems);
    }

    public boolean isClientSideError() {
        return this.isClientSideError;
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return Collections.unmodifiableMap(this.responseHeaders);
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public YodleeError getServerError() {
        return this.serverError;
    }

    private String isHttpCodeExist(int httpStatus) {
        return httpStatus == 0 ? "" : ", httpStatus=" + httpStatus;
    }

    @Override
    public String toString() {
        return "ApiException [problems=" + this.problems + ", isClientSideError=" + this.isClientSideError + this.isHttpCodeExist(this.httpStatus) + ", responseHeaders=" + this.responseHeaders + ", responseBody=" + this.responseBody + ", message=" + this.getMessage() + "]";
    }
}

