/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.api.util;

import com.yodlee.api.model.validator.Problem;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ApiUtils {
    private static final String VALIDATION_MESSAGES_BUNDLE = "ValidationMessages";
    private static final ConcurrentMap<Locale, ResourceBundle> resourcBundleMap = new ConcurrentHashMap<Locale, ResourceBundle>();

    private ApiUtils() {
    }

    public static String getMethodName() {
        return Thread.currentThread().getStackTrace()[2].getMethodName().replace("Async", "");
    }

    public static String getErrorMessage(String errorString, Object ... values) {
        String keyNotFound = "Error message : " + errorString + " not found.";
        String errorMessage = ((ResourceBundle)resourcBundleMap.get(Locale.getDefault())).getString(errorString);
        return ApiUtils.formattedMessage(keyNotFound, errorMessage, values);
    }

    public static String getErrorMessage(String errorString, Locale locale, Object ... values) {
        resourcBundleMap.putIfAbsent(locale, ResourceBundle.getBundle(VALIDATION_MESSAGES_BUNDLE, locale));
        ResourceBundle defaultValue = (ResourceBundle)resourcBundleMap.get(Locale.US);
        String keyNotFound = "Error message : " + errorString + " not found.";
        String errorMessage = null;
        errorMessage = resourcBundleMap.get(locale) == null ? defaultValue.getString(errorString) : ((ResourceBundle)resourcBundleMap.get(locale)).getString(errorString);
        return ApiUtils.formattedMessage(keyNotFound, errorMessage, values);
    }

    private static String formattedMessage(String keyNotFound, String errorMessage, Object ... values) {
        return errorMessage == null ? keyNotFound : MessageFormat.format(errorMessage, values);
    }

    public static String convertArrayToString(Object[] request) {
        if (request == null) {
            return "";
        }
        StringBuilder values = new StringBuilder();
        for (int i = 0; i < request.length; ++i) {
            values.append(request[i]).append(i < request.length - 1 ? "," : "");
        }
        return values.toString();
    }

    public static String convertArrayToString(long[] request) {
        if (request == null) {
            return "";
        }
        StringBuilder values = new StringBuilder();
        for (int i = 0; i < request.length; ++i) {
            values.append(request[i]).append(i < request.length - 1 ? "," : "");
        }
        return values.toString();
    }

    public static List<Problem> isConflictingParams(Object arg1, Object arg2, String errMsg) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (arg1 != null && arg2 != null) {
            problems.add(new Problem(ApiUtils.getErrorMessage(errMsg, new Object[0]), ""));
        }
        return problems;
    }

    public static List<Problem> validatePattern(String source, String pattern, String message) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (source != null && source.matches(pattern)) {
            problems.add(new Problem(ApiUtils.getErrorMessage(message, source), ""));
        }
        return problems;
    }

    static {
        resourcBundleMap.put(Locale.getDefault(), ResourceBundle.getBundle(VALIDATION_MESSAGES_BUNDLE));
    }
}

