/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.api.validators;

import com.yodlee.api.model.AbstractModelComponent;
import com.yodlee.api.model.account.CreateAccountInfo;
import com.yodlee.api.model.account.EvaluateAccountAddress;
import com.yodlee.api.model.account.UpdateAccountInfo;
import com.yodlee.api.model.account.enums.FrequencyType;
import com.yodlee.api.model.account.enums.ItemAccountStatus;
import com.yodlee.api.model.account.request.CreateAccountRequest;
import com.yodlee.api.model.account.request.EvaluateAddressRequest;
import com.yodlee.api.model.account.request.UpdateAccountRequest;
import com.yodlee.api.model.enums.Container;
import com.yodlee.api.model.validator.Problem;
import com.yodlee.sdk.api.AccountsApi;
import com.yodlee.sdk.api.exception.ApiException;
import com.yodlee.sdk.api.util.ApiUtils;
import com.yodlee.sdk.api.validators.ApiValidator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class AccountsValidator {
    public static void validateGetAccount(AccountsApi accountsApi, String methodName, Long accountId, IncludeParameterValue[] include) throws ApiException {
        Class[] argTypes = new Class[]{Long.TYPE, IncludeParameterValue[].class};
        Object[] argValues = new Object[]{accountId, include};
        List<Problem> methodProblems = ApiValidator.validate(accountsApi, methodName, argTypes, argValues);
        List<Problem> contextProblems = ApiValidator.validateUserContext(accountsApi);
        ApiValidator.collectProblems(methodProblems, contextProblems);
    }

    public static void validateGetAllAccounts(AccountsApi accountsApi, String methodName, Long[] accountId, Container container, IncludeParameterValue[] include, Long[] providerAccountId, String requestId, ItemAccountStatus[] status) throws ApiException {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        problems.addAll(AccountsValidator.validateGetAllAccountRequest(accountId, providerAccountId, status));
        Class[] argTypes = new Class[]{Long[].class, Container.class, IncludeParameterValue[].class, Long[].class, String.class, ItemAccountStatus[].class};
        Object[] argValues = new Object[]{accountId, container, include, providerAccountId, requestId, status};
        List<Problem> methodProblems = ApiValidator.validate(accountsApi, methodName, argTypes, argValues);
        List<Problem> contextProblems = ApiValidator.validateUserContext(accountsApi);
        ApiValidator.collectProblems(problems, methodProblems, contextProblems);
    }

    public static void validateGetHistoricalBalances(AccountsApi accountsApi, String methodName, Long accountId, Date toDate, Date fromDate, Boolean includeCF, HistoricalBalancesIntervalValue interval, Integer skip, Integer top) throws ApiException {
        Class[] argTypes = new Class[]{Long.class, Date.class, Date.class, Boolean.class, HistoricalBalancesIntervalValue.class, Integer.class, Integer.class};
        Object[] argValues = new Object[]{accountId, toDate, fromDate, includeCF, interval, skip, top};
        List<Problem> methodProblems = ApiValidator.validate(accountsApi, methodName, argTypes, argValues);
        ArrayList<Problem> problems = new ArrayList<Problem>();
        problems.addAll(ApiValidator.isValidDateRange(fromDate, toDate, "accounts.param.dateRange.invalid"));
        List<Problem> contextProblems = ApiValidator.validateUserContext(accountsApi);
        ApiValidator.collectProblems(problems, methodProblems, contextProblems);
    }

    public static void validateDeleteAccount(AccountsApi accountsApi, String methodName, long accountId) throws ApiException {
        Class[] argTypes = new Class[]{Long.TYPE};
        Object[] argValues = new Object[]{accountId};
        List<Problem> methodProblems = ApiValidator.validate(accountsApi, methodName, argTypes, argValues);
        List<Problem> contextProblems = ApiValidator.validateUserContext(accountsApi);
        ApiValidator.collectProblems(methodProblems, contextProblems);
    }

    public static void validateCreateManualAccount(AccountsApi accountsApi, String methodName, CreateAccountRequest accountParam) throws ApiException {
        Class[] argTypes = new Class[]{CreateAccountRequest.class};
        Object[] argValues = new Object[]{accountParam};
        List<Problem> methodProblems = ApiValidator.validate(accountsApi, methodName, argTypes, argValues);
        List<Problem> modelProblems = ApiValidator.validate((AbstractModelComponent)accountParam);
        List<Problem> contextProblems = ApiValidator.validateUserContext(accountsApi);
        List<Problem> problems = AccountsValidator.validateCreateManualAccount(accountParam);
        ApiValidator.collectProblems(problems, methodProblems, modelProblems, contextProblems);
    }

    public static void validateUpdateAccount(AccountsApi accountsApi, String methodName, long accountId, UpdateAccountRequest accountRequest) throws ApiException {
        Class[] argTypes = new Class[]{Long.TYPE, UpdateAccountRequest.class};
        Object[] argValues = new Object[]{accountId, accountRequest};
        List<Problem> methodProblems = ApiValidator.validate(accountsApi, methodName, argTypes, argValues);
        List<Problem> modelProblems = ApiValidator.validate((AbstractModelComponent)accountRequest);
        List<Problem> contextProblems = ApiValidator.validateUserContext(accountsApi);
        List<Problem> problems = AccountsValidator.validateUpdateAccount(accountRequest);
        ApiValidator.collectProblems(problems, methodProblems, modelProblems, contextProblems);
    }

    private static List<Problem> validateCreateManualAccount(CreateAccountRequest accountParam) {
        CreateAccountInfo accountInfo;
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (accountParam != null && (accountInfo = accountParam.getAccountInfo()) != null) {
            AccountsValidator.processAccounts(problems, accountInfo);
        }
        return problems;
    }

    private static void processAccounts(List<Problem> problems, CreateAccountInfo accountInfo) {
        String accountType = accountInfo.getAccountType();
        if ("REAL_ESTATE".equalsIgnoreCase(accountType)) {
            AccountsValidator.processRealEstateAccounts(problems, accountInfo);
        }
        if ("OTHER_ASSETS".equalsIgnoreCase(accountType) || "OTHER_LIABILITIES".equalsIgnoreCase(accountType)) {
            AccountsValidator.processAssetLiabilityAccounts(problems, accountInfo);
        }
        if ("BILLS".equalsIgnoreCase(accountType) || "CREDIT".equalsIgnoreCase(accountType) || "LOAN".equalsIgnoreCase(accountType) || "HOME_LOAN".equalsIgnoreCase(accountType) || "PERSONAL_LOAN".equalsIgnoreCase(accountType) || "INSURANCE".equalsIgnoreCase(accountType)) {
            AccountsValidator.processOtherAccounts(problems, accountInfo);
        } else {
            FrequencyType frequency = accountInfo.getFrequency();
            problems.addAll(AccountsValidator.isFrequencyExist(frequency));
        }
        String includeInNetWorth = accountInfo.getIncludeInNetWorth();
        problems.addAll(AccountsValidator.isValidIncludeInNetworth(includeInNetWorth));
    }

    private static void processOtherAccounts(List<Problem> problems, CreateAccountInfo accountInfo) {
        if (accountInfo.getDueDate() == null) {
            problems.add(new Problem(ApiUtils.getErrorMessage("accounts.manualAccountInfo.dueDate.required", new Object[0]), ""));
        }
    }

    private static void processAssetLiabilityAccounts(List<Problem> problems, CreateAccountInfo accountInfo) {
        if (accountInfo.getBalance() == null) {
            problems.add(new Problem(ApiUtils.getErrorMessage("accounts.manualAccountInfo.balance.required", new Object[0]), ""));
        }
    }

    private static void processRealEstateAccounts(List<Problem> problems, CreateAccountInfo accountInfo) {
        if (accountInfo.getValuationType() == null) {
            problems.add(new Problem(ApiUtils.getErrorMessage("accounts.manualAccountInfo.valuationType.required", new Object[0]), ""));
        }
    }

    private static List<Problem> validateUpdateAccount(UpdateAccountRequest accountRequest) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        UpdateAccountInfo accountInfo = accountRequest.getAccountInfo();
        if (accountInfo != null) {
            Container container = accountInfo.getContainer();
            if (container != null && container != Container.creditCard && container != Container.loan && container != Container.insurance) {
                FrequencyType frequency = accountInfo.getFrequency();
                problems.addAll(AccountsValidator.isFrequencyExist(frequency));
            }
            String includeInNetWorth = accountInfo.getIncludeInNetWorth();
            problems.addAll(AccountsValidator.isValidIncludeInNetworth(includeInNetWorth));
            problems.addAll(AccountsValidator.validAccountStatus(accountInfo));
            problems.addAll(ApiUtils.validatePattern(accountInfo.getAccountName(), "^\\s+.*", "accounts.accountName.space"));
        }
        return problems;
    }

    private static List<Problem> validAccountStatus(UpdateAccountInfo accountInfo) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        ItemAccountStatus accountStatus = accountInfo.getAccountStatus();
        if (accountStatus != null && !ItemAccountStatus.getUpdateAccountApplicableStatusTypes().contains(accountStatus)) {
            problems.add(new Problem(ApiUtils.getErrorMessage("accounts.accountInfo.accountStatus.invalid", accountStatus.name()), ""));
        }
        return problems;
    }

    private static List<Problem> isFrequencyExist(FrequencyType frequency) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (frequency != null) {
            problems.add(new Problem(ApiUtils.getErrorMessage("accounts.accountInfo.frequency.notSupported", new Object[0]), ""));
        }
        return problems;
    }

    private static List<Problem> isValidIncludeInNetworth(String includeInNetWorth) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (includeInNetWorth != null && !"TRUE".equalsIgnoreCase(includeInNetWorth) && !"FALSE".equalsIgnoreCase(includeInNetWorth)) {
            problems.add(new Problem(ApiUtils.getErrorMessage("accounts.accountInfo.includeInNetWorth.invalid", new Object[0]), ""));
        }
        return problems;
    }

    private static List<Problem> validateGetAllAccountRequest(Long[] accountId, Long[] providerAccountId, ItemAccountStatus[] status) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        problems.addAll(AccountsValidator.validateAccountStatus(status));
        problems.addAll(ApiValidator.validateId(accountId, "accounts.param.accountId.invalid"));
        problems.addAll(ApiValidator.validateId(providerAccountId, "accounts.param.providerAccountId.invalid"));
        return problems;
    }

    private static List<Problem> validateAccountStatus(ItemAccountStatus[] status) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (status != null && status.length > 0) {
            for (ItemAccountStatus statusValue : status) {
                if (ItemAccountStatus.getAccountApplicableStatusTypes().contains(statusValue)) continue;
                problems.add(new Problem(ApiUtils.getErrorMessage("accounts.param.status.invalid", statusValue.name()), ""));
            }
        }
        return problems;
    }

    public static void validateEvaluateAddress(AccountsApi accountsApi, String methodName, EvaluateAddressRequest evaluateAddressRequest) throws ApiException {
        Class[] argTypes = new Class[]{EvaluateAddressRequest.class};
        Object[] argValues = new Object[]{evaluateAddressRequest};
        List<Problem> methodProblems = ApiValidator.validate(accountsApi, methodName, argTypes, argValues);
        List<Problem> contextProblems = ApiValidator.validateUserContext(accountsApi);
        List modelProblems = evaluateAddressRequest.validate();
        List<Problem> cityStateOrZipPresentProblems = AccountsValidator.validateCityStateOrZipPresent(evaluateAddressRequest.getAddress());
        ApiValidator.collectProblems(methodProblems, contextProblems, modelProblems, cityStateOrZipPresentProblems);
    }

    private static List<Problem> validateCityStateOrZipPresent(EvaluateAccountAddress evaluateAccountAddress) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (evaluateAccountAddress != null && AccountsValidator.isZipEmpty(evaluateAccountAddress)) {
            boolean isCityEmpty = AccountsValidator.isCityEmpty(evaluateAccountAddress);
            boolean isStateEmpty = AccountsValidator.isStateEmpty(evaluateAccountAddress);
            if (isCityEmpty && isStateEmpty) {
                problems.add(new Problem(ApiUtils.getErrorMessage("evaluateAddress.address.zip.required", new Object[0]), ""));
            } else if (isCityEmpty) {
                problems.add(new Problem(ApiUtils.getErrorMessage("evaluateAddress.address.city.required", new Object[0]), ""));
            } else if (isStateEmpty) {
                problems.add(new Problem(ApiUtils.getErrorMessage("evaluateAddress.address.state.required", new Object[0]), ""));
            }
        }
        return problems;
    }

    private static boolean isZipEmpty(EvaluateAccountAddress evaluateAccountAddress) {
        return StringUtils.isEmpty((CharSequence)evaluateAccountAddress.getZip());
    }

    private static boolean isCityEmpty(EvaluateAccountAddress evaluateAccountAddress) {
        return StringUtils.isEmpty((CharSequence)evaluateAccountAddress.getCity());
    }

    private static boolean isStateEmpty(EvaluateAccountAddress evaluateAccountAddress) {
        return StringUtils.isEmpty((CharSequence)evaluateAccountAddress.getState());
    }

    public static void validateMigrateAccounts(AccountsApi accountsApi, String methodName, long providerAccountId) throws ApiException {
        Class[] argTypes = new Class[]{Long.TYPE};
        Object[] argValues = new Object[]{providerAccountId};
        List<Problem> methodProblems = ApiValidator.validate(accountsApi, methodName, argTypes, argValues);
        List<Problem> contextProblems = ApiValidator.validateUserContext(accountsApi);
        ApiValidator.collectProblems(methodProblems, contextProblems);
    }

    public static void validateAssociatedAccounts(AccountsApi accountsApi, String methodName, long providerAccountId) throws ApiException {
        Class[] argTypes = new Class[]{Long.TYPE};
        Object[] argValues = new Object[]{providerAccountId};
        List<Problem> methodProblems = ApiValidator.validate(accountsApi, methodName, argTypes, argValues);
        List<Problem> contextProblems = ApiValidator.validateUserContext(accountsApi);
        ApiValidator.collectProblems(methodProblems, contextProblems);
    }

    public static void validateAccountBalance(AccountsApi accountsApi, String methodName, Long[] accountIds, long providerAccountId) throws ApiException {
        Class[] argTypes = new Class[]{Long[].class, Long.TYPE};
        Object[] argValues = new Object[]{accountIds, providerAccountId};
        List<Problem> methodProblems = ApiValidator.validate(accountsApi, methodName, argTypes, argValues);
        List<Problem> contextProblems = ApiValidator.validateUserContext(accountsApi);
        ApiValidator.collectProblems(methodProblems, contextProblems);
    }

    public static enum HistoricalBalancesIntervalValue {
        D,
        W,
        M;

    }

    public static enum IncludeParameterValue {
        profile,
        holder,
        fullAccountNumber,
        fullAccountNumberList,
        paymentProfile,
        autoRefresh;

    }
}

