/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.api.validators;

import com.yodlee.api.model.AbstractModelComponent;
import com.yodlee.api.model.validator.Problem;
import com.yodlee.api.model.validator.Validator;
import com.yodlee.sdk.api.AbstractApi;
import com.yodlee.sdk.api.exception.ApiException;
import com.yodlee.sdk.api.util.ApiUtils;
import com.yodlee.sdk.context.ContextType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.executable.ExecutableValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiValidator {
    private static final long MAX_ID = 99999999999L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiValidator.class);

    private ApiValidator() {
    }

    public static List<Problem> validate(AbstractModelComponent modelComponent) {
        ArrayList problems = new ArrayList();
        return modelComponent == null ? problems : modelComponent.validate();
    }

    public static List<Problem> validate(Object o, String methodName, Class<?>[] types, Object ... vars) {
        ExecutableValidator executablesValidator = Validator.APIModelValidatorFactory.SINGLE_INSTANCE.getValidator().forExecutables();
        ArrayList<Problem> problems = new ArrayList<Problem>();
        try {
            Set violations = executablesValidator.validateParameters(o, o.getClass().getMethod(methodName, types), vars, new Class[0]);
            for (ConstraintViolation constraintViolation : violations) {
                Problem problem = new Problem(constraintViolation.getMessage(), constraintViolation.getPropertyPath().toString());
                problems.add(problem);
            }
        }
        catch (NoSuchMethodException | SecurityException e) {
            LOGGER.error("Exception in method validation", (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        return problems;
    }

    public static List<Problem> validateContextType(ContextType expectedContext, ContextType currentContext) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (expectedContext == ContextType.COBRAND && ContextType.USER == currentContext) {
            return problems;
        }
        if (expectedContext != currentContext) {
            Problem problem = new Problem("Y008 - User specific authentication required.", "");
            problems.add(problem);
        }
        return problems;
    }

    @SafeVarargs
    public static void collectProblems(List<? extends Problem> ... problemList) throws ApiException {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        for (List<? extends Problem> problem : problemList) {
            if (problem == null) continue;
            problems.addAll(problem);
        }
        if (!problems.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Problem problem : problems) {
                sb.append(problem.toString()).append('\n');
            }
            if (sb.length() > 0) {
                String msg = sb.toString();
                LOGGER.error(msg);
            }
            throw new ApiException(problems);
        }
    }

    public static List<Problem> isValidDateRange(Date fromDate, Date toDate, String errMsgKey) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (fromDate != null && toDate != null && fromDate.after(toDate)) {
            problems.add(new Problem(ApiUtils.getErrorMessage(errMsgKey, new Object[0]), ""));
        }
        return problems;
    }

    public static List<Problem> validateId(Long[] ids, String errorMessage) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (ids != null) {
            for (Long id : ids) {
                if (id >= 1L && id <= 99999999999L) continue;
                problems.add(new Problem(ApiUtils.getErrorMessage(errorMessage, new Object[0]), ""));
                return problems;
            }
        }
        return problems;
    }

    public static List<Problem> validateCobrandContext(AbstractApi api) {
        return ApiValidator.validateContextType(ContextType.COBRAND, api.getContext().getContextType());
    }

    public static List<Problem> validateUserContext(AbstractApi api) {
        return ApiValidator.validateContextType(ContextType.USER, api.getContext().getContextType());
    }
}

