/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.api.validators;

import com.yodlee.api.model.enums.Container;
import com.yodlee.api.model.validator.Problem;
import com.yodlee.sdk.api.DerivedApi;
import com.yodlee.sdk.api.exception.ApiException;
import com.yodlee.sdk.api.util.ApiUtils;
import com.yodlee.sdk.api.validators.ApiValidator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DerivedValidator {
    private static final String CATEGORY_TYPE = "CATEGORY_TYPE";
    private static final String HIGH_LEVEL_CATEGORY = "HIGH_LEVEL_CATEGORY";
    private static final String CATEGORY = "CATEGORY";

    public static void validateTransactionSummary(DerivedApi derivedApi, String methodName, GroupType groupBy, Long[] accountId, Long[] categoryId, CategoryType[] categoryType, Date fromDate, DerivedInclude include, Boolean includeUserCategory, DataPointInterval interval, Date toDate) throws ApiException {
        Class[] argTypes = new Class[]{GroupType.class, Long[].class, Long[].class, CategoryType[].class, Date.class, DerivedInclude.class, Boolean.class, DataPointInterval.class, Date.class};
        Object[] argValues = new Object[]{groupBy, accountId, categoryId, categoryType, fromDate, include, includeUserCategory, interval, toDate};
        List<Problem> methodProblems = ApiValidator.validate(derivedApi, methodName, argTypes, argValues);
        List<Problem> contextProblems = ApiValidator.validateUserContext(derivedApi);
        methodProblems.addAll(ApiValidator.isValidDateRange(fromDate, toDate, "derived.param.date.range.invalid"));
        methodProblems.addAll(ApiValidator.validateId(accountId, "derived.param.accountId.invalid"));
        methodProblems.addAll(ApiValidator.validateId(categoryId, "derived.param.categoryId.invalid"));
        methodProblems.addAll(DerivedValidator.validateCategoryType(groupBy, categoryType));
        methodProblems.addAll(DerivedValidator.validateCategoryId(groupBy, categoryId));
        ApiValidator.collectProblems(methodProblems, contextProblems);
    }

    private static List<Problem> validateCategoryId(GroupType groupBy, Long[] categoryId) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (groupBy != null && groupBy.toString().equalsIgnoreCase(CATEGORY_TYPE) && categoryId != null) {
            problems.add(new Problem(ApiUtils.getErrorMessage("derived.param.categoryId.groupBy.invalid", new Object[0]), ""));
        }
        return problems;
    }

    private static List<Problem> validateCategoryType(GroupType groupBy, CategoryType[] categoryType) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (groupBy != null && (groupBy.toString().equalsIgnoreCase(CATEGORY) || groupBy.toString().equalsIgnoreCase(HIGH_LEVEL_CATEGORY)) && (categoryType == null || categoryType.length < 1)) {
            problems.add(new Problem(ApiUtils.getErrorMessage("derived.param.categoryType.required", new Object[0]), ""));
        }
        return problems;
    }

    public static void validateHoldingSummary(DerivedApi derivedApi, String methodName, Long[] accountIds, String classificationType, DerivedInclude include) throws ApiException {
        Class[] argTypes = new Class[]{Long[].class, String.class, DerivedInclude.class};
        Object[] argValues = new Object[]{accountIds, classificationType, include};
        List<Problem> methodProblems = ApiValidator.validate(derivedApi, methodName, argTypes, argValues);
        methodProblems.addAll(ApiValidator.validateId(accountIds, "derived.param.accountIds.invalid"));
        List<Problem> contextProblems = ApiValidator.validateUserContext(derivedApi);
        ApiValidator.collectProblems(methodProblems, contextProblems);
    }

    public static void validateNetworth(DerivedApi derivedApi, String methodName, Long[] accountIds, Date fromDate, DerivedInclude include, DataPointInterval interval, Integer skip, Date toDate, Integer top, Container container) throws ApiException {
        Class[] argTypes = new Class[]{Long[].class, Date.class, DerivedInclude.class, DataPointInterval.class, Integer.class, Date.class, Integer.class, Container.class};
        Object[] argValues = new Object[]{accountIds, fromDate, include, interval, skip, toDate, top, container};
        List<Problem> methodProblems = ApiValidator.validate(derivedApi, methodName, argTypes, argValues);
        List<Problem> contextProblems = ApiValidator.validateUserContext(derivedApi);
        methodProblems.addAll(ApiValidator.isValidDateRange(fromDate, toDate, "derived.param.date.range.invalid"));
        methodProblems.addAll(ApiValidator.validateId(accountIds, "derived.param.accountIds.invalid"));
        ApiValidator.collectProblems(methodProblems, contextProblems);
    }

    public static enum DerivedInclude {
        details;

    }

    public static enum DataPointInterval {
        D,
        W,
        M,
        Y;

    }

    public static enum CategoryType {
        INCOME,
        EXPENSE,
        TRANSFER,
        UNCATEGORIZE,
        DEFERRED_COMPENSATION;

    }

    public static enum GroupType {
        CATEGORY_TYPE,
        HIGH_LEVEL_CATEGORY,
        CATEGORY;

    }
}

