/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.api.validators;

import com.yodlee.api.model.validator.Problem;
import com.yodlee.sdk.api.HoldingsApi;
import com.yodlee.sdk.api.exception.ApiException;
import com.yodlee.sdk.api.validators.ApiValidator;
import java.util.ArrayList;
import java.util.List;

public class HoldingsValidator {
    public static void validateGetSecurities(HoldingsApi holdingsApi, String methodName, Long[] holdingId) throws ApiException {
        Class[] argTypes = new Class[]{Long[].class};
        Object[] argValues = new Object[]{holdingId};
        List<Problem> methodProblems = ApiValidator.validate(holdingsApi, methodName, argTypes, argValues);
        methodProblems.addAll(ApiValidator.validateId(holdingId, "holdings.param.holdingId.invalid"));
        List<Problem> contextProblems = ApiValidator.validateUserContext(holdingsApi);
        ApiValidator.collectProblems(methodProblems, contextProblems);
    }

    public static void validateGetHoldings(HoldingsApi holdingsApi, String methodName, Long[] accountId, String assetClassificationClassificationType, String classificationValue, HoldingInclude include, Long providerAccountId) throws ApiException {
        Class[] argTypes = new Class[]{Long[].class, String.class, String.class, HoldingInclude.class, Long.class};
        Object[] argValues = new Object[]{accountId, assetClassificationClassificationType, classificationValue, include, providerAccountId};
        List<Problem> methodProblems = ApiValidator.validate(holdingsApi, methodName, argTypes, argValues);
        List<Problem> contextProblems = ApiValidator.validateUserContext(holdingsApi);
        ArrayList<Problem> problems = new ArrayList<Problem>();
        problems.addAll(ApiValidator.validateId(accountId, "holdings.param.accountId.invalid"));
        ApiValidator.collectProblems(problems, methodProblems, contextProblems);
    }

    public static void validateHoldingsContext(HoldingsApi holdingsApi) throws ApiException {
        List<Problem> contextProblems = ApiValidator.validateCobrandContext(holdingsApi);
        ApiValidator.collectProblems(contextProblems);
    }

    public static enum HoldingInclude {
        isAssetTransferEligible,
        assetClassification;

    }
}

