/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.api.validators;

import com.yodlee.api.model.AbstractModelComponent;
import com.yodlee.api.model.Field;
import com.yodlee.api.model.ProvidersDataset;
import com.yodlee.api.model.provideraccounts.request.ProviderAccountPreferencesRequest;
import com.yodlee.api.model.provideraccounts.request.ProviderAccountRequest;
import com.yodlee.api.model.provideraccounts.request.RefreshProviderAccountRequest;
import com.yodlee.api.model.validator.Problem;
import com.yodlee.sdk.api.ProviderAccountsApi;
import com.yodlee.sdk.api.exception.ApiException;
import com.yodlee.sdk.api.util.ApiUtils;
import com.yodlee.sdk.api.validators.ApiValidator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ProviderAccountsValidator {
    private static final String CONFLICTING_DATASET_ERROR_MSG = "providerAccounts.param.dataset.datasetName.invalid";

    public static void validateDeleteProviderAccount(ProviderAccountsApi providerAccountsApi, String methodName, long providerAccountId) throws ApiException {
        Class[] argTypes = new Class[]{Long.TYPE};
        Object[] argValues = new Object[]{providerAccountId};
        List<Problem> methodProblems = ApiValidator.validate(providerAccountsApi, methodName, argTypes, argValues);
        List<Problem> contextProblems = ApiValidator.validateUserContext(providerAccountsApi);
        ApiValidator.collectProblems(methodProblems, contextProblems);
    }

    public static void validateGetProviderAccount(ProviderAccountsApi providerAccountsApi, String methodName, long providerAccountId, ProviderAccountInclude[] include, String requestId) throws ApiException {
        Class[] argTypes = new Class[]{Long.TYPE, ProviderAccountInclude[].class, String.class};
        Object[] argValues = new Object[]{providerAccountId, include, requestId};
        List<Problem> methodProblems = ApiValidator.validate(providerAccountsApi, methodName, argTypes, argValues);
        List<Problem> contextProblems = ApiValidator.validateUserContext(providerAccountsApi);
        ApiValidator.collectProblems(methodProblems, contextProblems);
    }

    public static void validateGetAllProviderAccounts(ProviderAccountsApi providerAccountsApi, String methodName, ProviderAccountDetailsInclude include, Long[] providerIds) throws ApiException {
        Class[] argTypes = new Class[]{ProviderAccountDetailsInclude.class, Long[].class};
        Object[] argValues = new Object[]{include, providerIds};
        List<Problem> contextProblems = ApiValidator.validateUserContext(providerAccountsApi);
        List<Problem> methodProblems = ApiValidator.validate(providerAccountsApi, methodName, argTypes, argValues);
        methodProblems.addAll(ApiValidator.validateId(providerIds, "providerAccounts.param.providerIds.invalid"));
        ApiValidator.collectProblems(methodProblems, contextProblems);
    }

    public static void validateLinkProviderAccount(ProviderAccountsApi providerAccountsApi, String methodName, long providerId, ProviderAccountRequest providerAccountRequest) throws ApiException {
        Class[] argTypes = new Class[]{ProviderAccountRequest.class, Long.TYPE};
        Object[] argValues = new Object[]{providerAccountRequest, providerId};
        List<Problem> contextProblems = ApiValidator.validateUserContext(providerAccountsApi);
        List<Problem> modelproblems = ApiValidator.validate((AbstractModelComponent)providerAccountRequest);
        List<Problem> methodProblems = ApiValidator.validate(providerAccountsApi, methodName, argTypes, argValues);
        if (providerAccountRequest != null) {
            methodProblems.addAll(ProviderAccountsValidator.validateDatasetDuplication(providerAccountRequest.getDatasets()));
            methodProblems.addAll(ApiUtils.isConflictingParams(providerAccountRequest.getDatasets(), providerAccountRequest.getDatasetName(), CONFLICTING_DATASET_ERROR_MSG));
            methodProblems.addAll(ProviderAccountsValidator.validateFields(providerAccountRequest.getField()));
        }
        ApiValidator.collectProblems(methodProblems, contextProblems, modelproblems);
    }

    private static List<Problem> validateFields(List<Field> fields) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (fields == null) {
            return problems;
        }
        if (fields.size() == 1 && !fields.get(0).getId().equalsIgnoreCase("authResponse")) {
            problems.add(new Problem(ApiUtils.getErrorMessage("providerAccounts.param.field.id.authResponse.required", new Object[0]), ""));
        }
        if (fields.size() < 2 && !fields.get(0).getId().equalsIgnoreCase("authResponse")) {
            problems.add(new Problem(ApiUtils.getErrorMessage("providerAccounts.param.field.required", new Object[0]), ""));
        }
        return problems;
    }

    private static List<Problem> validateDatasetDuplication(List<ProvidersDataset> datasets) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (datasets == null || datasets.isEmpty()) {
            return problems;
        }
        HashSet<ProvidersDataset> providerSet = new HashSet<ProvidersDataset>();
        for (ProvidersDataset providersDataset : datasets) {
            if (providerSet.add(providersDataset)) continue;
            problems.add(new Problem(ApiUtils.getErrorMessage("providerAccounts.param.dataset.invalid", new Object[0]), ""));
            return problems;
        }
        return problems;
    }

    public static void validateGetProviderAccountProfiles(ProviderAccountsApi providerAccountsApi, String methodName, Long[] providerAccountId) throws ApiException {
        Class[] argTypes = new Class[]{Long[].class};
        Object[] argValues = new Object[]{providerAccountId};
        List<Problem> contextProblems = ApiValidator.validateUserContext(providerAccountsApi);
        List<Problem> methodProblems = ApiValidator.validate(providerAccountsApi, methodName, argTypes, argValues);
        methodProblems.addAll(ApiValidator.validateId(providerAccountId, "providerAccounts.param.providerAccountIds.invalid"));
        ApiValidator.collectProblems(methodProblems, contextProblems);
    }

    public static void validateUpdatePreferences(ProviderAccountsApi providerAccountsApi, String methodName, ProviderAccountPreferencesRequest preferences, Long providerAccountId) throws ApiException {
        Class[] argTypes = new Class[]{ProviderAccountPreferencesRequest.class, Long.class};
        Object[] argValues = new Object[]{preferences, providerAccountId};
        List<Problem> methodProblems = ApiValidator.validate(providerAccountsApi, methodName, argTypes, argValues);
        List<Problem> contextProblems = ApiValidator.validateUserContext(providerAccountsApi);
        List<Problem> modelproblems = ApiValidator.validate((AbstractModelComponent)preferences);
        ApiValidator.collectProblems(methodProblems, contextProblems, modelproblems);
    }

    public static void validateMFAProviderAccount(ProviderAccountsApi providerAccountsApi, String methodName, long providerAccountId, Field[] mfaFields) throws ApiException {
        Class[] argTypes = new Class[]{Long.TYPE, Field[].class};
        Object[] argValues = new Object[]{providerAccountId, mfaFields};
        List<Problem> methodProblems = ApiValidator.validate(providerAccountsApi, methodName, argTypes, argValues);
        ArrayList modelProblems = new ArrayList();
        if (mfaFields != null) {
            for (Field field : mfaFields) {
                if (field == null) continue;
                modelProblems.addAll(field.validate());
            }
        }
        List<Problem> contextProblems = ApiValidator.validateUserContext(providerAccountsApi);
        ApiValidator.collectProblems(methodProblems, modelProblems, contextProblems);
    }

    public static void validateUpdateProviderAccount(ProviderAccountsApi providerAccountsApi, String methodName, long providerAccountId, ProviderAccountRequest providerAccountRequest) throws ApiException {
        Class[] argTypes = new Class[]{Long.TYPE, ProviderAccountRequest.class};
        Object[] argValues = new Object[]{providerAccountId, providerAccountRequest};
        List<Problem> modelProblems = ApiValidator.validate((AbstractModelComponent)providerAccountRequest);
        List<Problem> contextProblems = ApiValidator.validateUserContext(providerAccountsApi);
        List<Problem> methodProblems = ApiValidator.validate(providerAccountsApi, methodName, argTypes, argValues);
        if (providerAccountRequest != null) {
            methodProblems.addAll(ProviderAccountsValidator.validateDatasetDuplication(providerAccountRequest.getDatasets()));
            methodProblems.addAll(ApiUtils.isConflictingParams(providerAccountRequest.getDatasets(), providerAccountRequest.getDatasetName(), CONFLICTING_DATASET_ERROR_MSG));
            methodProblems.addAll(ProviderAccountsValidator.validateFields(providerAccountRequest.getField()));
        }
        ApiValidator.collectProblems(methodProblems, modelProblems, contextProblems);
    }

    public static void validateRefreshAllProviderAccounts(ProviderAccountsApi providerAccountsApi, String methodName) throws ApiException {
        Class[] argTypes = new Class[]{};
        Object[] argValues = new Object[]{};
        List<Problem> methodProblems = ApiValidator.validate(providerAccountsApi, methodName, argTypes, argValues);
        List<Problem> contextProblems = ApiValidator.validateUserContext(providerAccountsApi);
        ApiValidator.collectProblems(methodProblems, contextProblems);
    }

    public static void validateRefreshProviderAccount(ProviderAccountsApi providerAccountsApi, String methodName, long providerAccountId, RefreshProviderAccountRequest refreshProviderAccountRequest) throws ApiException {
        Class[] argTypes = new Class[]{Long.TYPE, RefreshProviderAccountRequest.class};
        Object[] argValues = new Object[]{providerAccountId, refreshProviderAccountRequest};
        List<Problem> methodProblems = ApiValidator.validate(providerAccountsApi, methodName, argTypes, argValues);
        List<Problem> contextProblems = ApiValidator.validateUserContext(providerAccountsApi);
        if (refreshProviderAccountRequest != null) {
            methodProblems.addAll(ProviderAccountsValidator.validateDatasetDuplication(refreshProviderAccountRequest.getDatasets()));
            methodProblems.addAll(ApiUtils.isConflictingParams(refreshProviderAccountRequest.getDatasets(), refreshProviderAccountRequest.getDatasetName(), CONFLICTING_DATASET_ERROR_MSG));
        }
        ApiValidator.collectProblems(methodProblems, contextProblems);
    }

    public static enum ProviderAccountDetailsInclude {
        preferences;

    }

    public static enum ProviderAccountInclude {
        credentials,
        questions,
        preferences;

    }
}

