/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.api.validators;

import com.yodlee.api.model.validator.Problem;
import com.yodlee.sdk.api.ProvidersApi;
import com.yodlee.sdk.api.exception.ApiException;
import com.yodlee.sdk.api.util.ApiUtils;
import com.yodlee.sdk.api.validators.ApiValidator;
import java.util.List;

public class ProvidersValidator {
    private ProvidersValidator() {
    }

    public static void validateGetProviders(ProvidersApi providersApi, String method, ProvidersCapability capability, String datasetFilter, String name, ProvidersPriorityType priority, Integer skip, Integer top, String fullAccountNumberFields) throws ApiException {
        Class[] argTypes = new Class[]{ProvidersCapability.class, String.class, String.class, ProvidersPriorityType.class, Integer.class, Integer.class, String.class};
        Object[] argValues = new Object[]{capability, datasetFilter, name, priority, skip, top, fullAccountNumberFields};
        List<Problem> methodProblems = ApiValidator.validate(providersApi, method, argTypes, argValues);
        List<Problem> contextProblems = ApiValidator.validateCobrandContext(providersApi);
        methodProblems.addAll(ApiUtils.isConflictingParams(name, top, "providers.param.name.top.invalid"));
        methodProblems.addAll(ApiUtils.isConflictingParams(name, skip, "providers.param.name.skip.invalid"));
        ApiValidator.collectProblems(methodProblems, contextProblems);
    }

    public static void validateGetProviderDetails(ProvidersApi providersApi, String method, Long providerId) throws ApiException {
        Class[] argTypes = new Class[]{Long.class};
        Object[] argValues = new Object[]{providerId};
        List<Problem> methodProblems = ApiValidator.validate(providersApi, method, argTypes, argValues);
        List<Problem> contextProblems = ApiValidator.validateCobrandContext(providersApi);
        ApiValidator.collectProblems(methodProblems, contextProblems);
    }

    public static void validateGetProvidersCount(ProvidersApi providersApi, String method, ProvidersCapability capability, String datasetFilter, String name, ProvidersPriorityType priority, String fullAccountNumberFields) throws ApiException {
        Class[] argTypes = new Class[]{ProvidersCapability.class, String.class, String.class, ProvidersPriorityType.class, String.class};
        Object[] argValues = new Object[]{capability, datasetFilter, name, priority, fullAccountNumberFields};
        List<Problem> methodProblems = ApiValidator.validate(providersApi, method, argTypes, argValues);
        List<Problem> contextProblems = ApiValidator.validateCobrandContext(providersApi);
        ApiValidator.collectProblems(methodProblems, contextProblems);
    }

    public static enum ProvidersCapability {
        CHALLENGE_DEPOSIT_VERIFICATION;

    }

    public static enum ProvidersPriorityType {
        SUGGESTED("suggested"),
        POPULAR("popular"),
        COBRAND("cobrand");

        private String type;

        private ProvidersPriorityType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

