/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.api.validators;

import com.yodlee.api.model.AbstractModelComponent;
import com.yodlee.api.model.enums.AggregationSource;
import com.yodlee.api.model.enums.BaseType;
import com.yodlee.api.model.enums.Container;
import com.yodlee.api.model.transaction.FieldOperation;
import com.yodlee.api.model.transaction.enums.MeerkatTxnType;
import com.yodlee.api.model.transaction.enums.Operation;
import com.yodlee.api.model.transaction.enums.TransactionCategoryType;
import com.yodlee.api.model.transaction.enums.TransactionClauseType;
import com.yodlee.api.model.transaction.enums.TransactionType;
import com.yodlee.api.model.transaction.request.TransactionCategorizationRuleRequest;
import com.yodlee.api.model.transaction.request.TransactionCategoryRequest;
import com.yodlee.api.model.transaction.request.TransactionRequest;
import com.yodlee.api.model.transaction.request.UpdateCategoryRequest;
import com.yodlee.api.model.validator.Problem;
import com.yodlee.sdk.api.TransactionsApi;
import com.yodlee.sdk.api.exception.ApiException;
import com.yodlee.sdk.api.util.ApiUtils;
import com.yodlee.sdk.api.validators.ApiValidator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TransactionsValidator {
    private TransactionsValidator() {
    }

    public static void validateGetTransactions(TransactionsApi transactionsApi, String methodName, Long[] accountId, BaseType baseType, Long[] categoryId, TransactionCategoryType categoryType, Container container, Long[] detailCategoryId, Date fromDate, Long[] highLevelCategoryId, String keyword, Integer skip, Date toDate, Integer top, String type) throws ApiException {
        Class[] argTypes = new Class[]{Long[].class, BaseType.class, Long[].class, TransactionCategoryType.class, Container.class, Long[].class, Date.class, Long[].class, String.class, Integer.class, Date.class, Integer.class, String.class};
        Object[] argValues = new Object[]{accountId, baseType, categoryId, categoryType, container, detailCategoryId, fromDate, highLevelCategoryId, keyword, skip, toDate, top, type};
        List<Problem> methodProblems = ApiValidator.validate(transactionsApi, methodName, argTypes, argValues);
        List<Problem> problems = TransactionsValidator.validateTransactionRequest(accountId, categoryId, container, detailCategoryId, fromDate, highLevelCategoryId, toDate, type);
        List<Problem> contextProblems = ApiValidator.validateUserContext(transactionsApi);
        ApiValidator.collectProblems(problems, methodProblems, contextProblems);
    }

    public static void validateGetTransactionsCount(TransactionsApi transactionsApi, String methodName, Long[] accountId, BaseType baseType, Long[] categoryId, TransactionCategoryType categoryType, Container container, Long[] detailCategoryId, Date fromDate, Long[] highLevelCategoryId, String keyword, Date toDate, String type) throws ApiException {
        Class[] argTypes = new Class[]{Long[].class, BaseType.class, Long[].class, TransactionCategoryType.class, Container.class, Long[].class, Date.class, Long[].class, String.class, Date.class, String.class};
        Object[] argValues = new Object[]{accountId, baseType, categoryId, categoryType, container, detailCategoryId, fromDate, highLevelCategoryId, keyword, toDate, type};
        List<Problem> methodProblems = ApiValidator.validate(transactionsApi, methodName, argTypes, argValues);
        List<Problem> problems = TransactionsValidator.validateTransactionRequest(accountId, categoryId, container, detailCategoryId, fromDate, highLevelCategoryId, toDate, type);
        List<Problem> contextProblems = ApiValidator.validateUserContext(transactionsApi);
        ApiValidator.collectProblems(problems, methodProblems, contextProblems);
    }

    public static void validateUpdateTransaction(TransactionsApi transactionsApi, String methodName, long transactionId, TransactionRequest transactionRequest) throws ApiException {
        Class[] argTypes = new Class[]{Long.TYPE, TransactionRequest.class};
        Object[] argValues = new Object[]{transactionId, transactionRequest};
        List<Problem> methodProblems = ApiValidator.validate(transactionsApi, methodName, argTypes, argValues);
        List<Problem> modelProblems = ApiValidator.validate((AbstractModelComponent)transactionRequest);
        Container container = null;
        if (transactionRequest != null && transactionRequest.getTransaction() != null) {
            container = transactionRequest.getTransaction().getContainer();
        }
        List<Problem> problems = TransactionsValidator.validateTransactionContainer(container, "transactions.container.invalid");
        List<Problem> contextProblems = ApiValidator.validateUserContext(transactionsApi);
        ApiValidator.collectProblems(problems, methodProblems, modelProblems, contextProblems);
    }

    public static void validateCreateTransactionCategory(TransactionsApi transactionsApi, String methodName, TransactionCategoryRequest transactionCategoryRequest) throws ApiException {
        Class[] argTypes = new Class[]{TransactionCategoryRequest.class};
        Object[] argValues = new Object[]{transactionCategoryRequest};
        List<Problem> methodProblems = ApiValidator.validate(transactionsApi, methodName, argTypes, argValues);
        List<Problem> modelProblems = ApiValidator.validate((AbstractModelComponent)transactionCategoryRequest);
        List<Problem> contextProblems = ApiValidator.validateUserContext(transactionsApi);
        ApiValidator.collectProblems(methodProblems, modelProblems, contextProblems);
    }

    public static void validateCreateTransactionCategorizationRules(TransactionsApi transactionsApi, String methodName, TransactionCategorizationRuleRequest transactionCategorizationRuleRequest) throws ApiException {
        Class[] argTypes = new Class[]{TransactionCategorizationRuleRequest.class};
        Object[] argValues = new Object[]{transactionCategorizationRuleRequest};
        List<Problem> methodProblems = ApiValidator.validate(transactionsApi, methodName, argTypes, argValues);
        List<Problem> modelProblems = ApiValidator.validate((AbstractModelComponent)transactionCategorizationRuleRequest);
        List<Problem> problems = TransactionsValidator.validateTranscationCategoryRuleRequest(transactionCategorizationRuleRequest, true);
        List<Problem> contextProblems = ApiValidator.validateUserContext(transactionsApi);
        ApiValidator.collectProblems(problems, methodProblems, modelProblems, contextProblems);
    }

    public static void validateUpdateTransactionCategorizationRule(TransactionsApi transactionsApi, String methodName, long ruleId, TransactionCategorizationRuleRequest transactionCategorizationRuleRequest) throws ApiException {
        Class[] argTypes = new Class[]{Long.TYPE, TransactionCategorizationRuleRequest.class};
        Object[] argValues = new Object[]{ruleId, transactionCategorizationRuleRequest};
        List<Problem> methodProblems = ApiValidator.validate(transactionsApi, methodName, argTypes, argValues);
        List<Problem> modelProblems = ApiValidator.validate((AbstractModelComponent)transactionCategorizationRuleRequest);
        List<Problem> problems = TransactionsValidator.validateTranscationCategoryRuleRequest(transactionCategorizationRuleRequest, false);
        List<Problem> contextProblems = ApiValidator.validateUserContext(transactionsApi);
        ApiValidator.collectProblems(problems, methodProblems, modelProblems, contextProblems);
    }

    public static void validateRunOrDeleteTransactionCategorizationRule(TransactionsApi transactionsApi, String methodName, long ruleId) throws ApiException {
        Class[] argTypes = new Class[]{Long.TYPE};
        Object[] argValues = new Object[]{ruleId};
        List<Problem> methodProblems = ApiValidator.validate(transactionsApi, methodName, argTypes, argValues);
        List<Problem> contextProblems = ApiValidator.validateUserContext(transactionsApi);
        ApiValidator.collectProblems(methodProblems, contextProblems);
    }

    public static void validateDeleteTransactionCategory(TransactionsApi transactionsApi, String methodName, long categoryId) throws ApiException {
        Class[] argTypes = new Class[]{Long.TYPE};
        Object[] argValues = new Object[]{categoryId};
        List<Problem> methodProblems = ApiValidator.validate(transactionsApi, methodName, argTypes, argValues);
        List<Problem> contextProblems = ApiValidator.validateUserContext(transactionsApi);
        ApiValidator.collectProblems(methodProblems, contextProblems);
    }

    public static void validateUpdateTransactionCategory(TransactionsApi transactionsApi, String methodName, UpdateCategoryRequest updateCategoryRequest) throws ApiException {
        Class[] argTypes = new Class[]{UpdateCategoryRequest.class};
        Object[] argValues = new Object[]{updateCategoryRequest};
        List<Problem> methodProblems = ApiValidator.validate(transactionsApi, methodName, argTypes, argValues);
        List<Problem> modelProblems = ApiValidator.validate((AbstractModelComponent)updateCategoryRequest);
        List<Problem> problems = TransactionsValidator.validateUpdateCategoryRequest(updateCategoryRequest);
        List<Problem> contextProblems = ApiValidator.validateUserContext(transactionsApi);
        ApiValidator.collectProblems(problems, methodProblems, modelProblems, contextProblems);
    }

    public static void validateContext(TransactionsApi transactionsApi) throws ApiException {
        List<Problem> contextProblems = ApiValidator.validateUserContext(transactionsApi);
        ApiValidator.collectProblems(contextProblems);
    }

    public static void validateCobrandContext(TransactionsApi transactionsApi) throws ApiException {
        List<Problem> contextProblems = ApiValidator.validateCobrandContext(transactionsApi);
        ApiValidator.collectProblems(contextProblems);
    }

    private static List<Problem> validateTransactionContainer(Container container, String messageKey) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (container != null && !Container.getTransactionContainers().contains(container)) {
            problems.add(new Problem(ApiUtils.getErrorMessage(messageKey, container), ""));
        }
        return problems;
    }

    private static List<Problem> validateUpdateCategoryRequest(UpdateCategoryRequest updateCategoryRequest) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (updateCategoryRequest != null && updateCategoryRequest.getCategoryName() == null && updateCategoryRequest.getHighLevelCategoryName() == null) {
            String errorMessage = ApiUtils.getErrorMessage("transactions.updateCategory.categoryName.or.highLevelCategoryName.required", new Object[0]);
            problems.add(new Problem(errorMessage, ""));
        }
        return problems;
    }

    private static List<Problem> validateTranscationCategoryRuleRequest(TransactionCategorizationRuleRequest transactionCategorizationRuleRequest, boolean createRequest) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (transactionCategorizationRuleRequest != null && transactionCategorizationRuleRequest.getRule() != null) {
            AggregationSource source = transactionCategorizationRuleRequest.getRule().getSource();
            if (createRequest && source == null) {
                problems.add(new Problem(ApiUtils.getErrorMessage("transactions.rule.source.required", new Object[0]), ""));
            }
            List ruleClauses = transactionCategorizationRuleRequest.getRule().getRuleClauses();
            for (FieldOperation ruleClause : ruleClauses) {
                TransactionClauseType field = ruleClause.field();
                Object value = ruleClause.getValue();
                Operation operation = ruleClause.getOperation();
                if (TransactionClauseType.amount == field && value != null && operation != null) {
                    problems.addAll(TransactionsValidator.validateTransactionClauseTypeAmount(value, operation));
                }
                if (!TransactionClauseType.description.equals((Object)field) || value == null) continue;
                problems.addAll(TransactionsValidator.validateTransactionClauseTypeDesc(value, operation));
            }
        }
        return problems;
    }

    private static List<Problem> validateTransactionClauseTypeDesc(Object value, Operation operation) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (StringUtils.isEmpty((CharSequence)value.toString())) {
            problems.add(new Problem(ApiUtils.getErrorMessage("transactions.rule.ruleClauses.description.value.invalid", new Object[0]), ""));
        }
        if (operation != null && !operation.isStringOperation()) {
            String errorMessage = ApiUtils.getErrorMessage("transactions.rule.ruleClauses.description.operation.invalid", new Object[0]);
            problems.add(new Problem(errorMessage, ""));
        }
        return problems;
    }

    private static List<Problem> validateTransactionClauseTypeAmount(Object value, Operation operation) {
        String errorMessage;
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (!value.toString().matches("[0-9]+(\\.[0-9]{1,4})?$")) {
            errorMessage = ApiUtils.getErrorMessage("transactions.rule.ruleClauses.amount.value.invalid", new Object[0]);
            problems.add(new Problem(errorMessage, ""));
        }
        if (!operation.isNumericOperation()) {
            errorMessage = ApiUtils.getErrorMessage("transactions.rule.ruleClauses.amount.operation.invalid", new Object[0]);
            problems.add(new Problem(errorMessage, ""));
        }
        return problems;
    }

    private static List<Problem> validateTransactionRequest(Long[] accountId, Long[] categoryId, Container container, Long[] detailCategoryId, Date fromDate, Long[] highLevelCategoryId, Date toDate, String type) {
        List<Problem> problems = TransactionsValidator.validateTransactionContainer(container, "transactions.param.container.invalid");
        problems.addAll(ApiValidator.isValidDateRange(fromDate, toDate, ApiUtils.getErrorMessage("transactions.param.dateRange.invalid", new Object[0])));
        problems.addAll(ApiValidator.validateId(accountId, "transactions.param.accountId.invalid"));
        problems.addAll(ApiValidator.validateId(categoryId, "transactions.param.categoryId.invalid"));
        problems.addAll(ApiValidator.validateId(detailCategoryId, "transactions.param.detailCategoryId.invalid"));
        problems.addAll(ApiValidator.validateId(highLevelCategoryId, "transactions.param.highLevelCategoryId.invalid"));
        problems.addAll(TransactionsValidator.validateTransactionType(container, type));
        return problems;
    }

    private static List<Problem> validateTransactionType(Container container, String type) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (!StringUtils.isEmpty((CharSequence)type)) {
            StringBuilder sbType = new StringBuilder();
            sbType.append(Character.isDigit(type.charAt(0)) ? "_" : "").append(type);
            String processedType = sbType.toString();
            if (TransactionType.exists((String)processedType) && MeerkatTxnType.exists((String)processedType)) {
                TransactionsValidator.containerBelongsToTransactionTypeAndMeerkatTxnType(container, problems);
            } else if (TransactionType.exists((String)processedType)) {
                TransactionsValidator.containerBelongsToTransactionTypeOnly(container, problems);
            } else if (MeerkatTxnType.exists((String)processedType)) {
                TransactionsValidator.containerBelongsToMeerkatTxnTypeOnly(container, problems);
            } else {
                TransactionsValidator.createProblemForInvalidType(problems);
            }
        }
        return problems;
    }

    private static void containerBelongsToMeerkatTxnTypeOnly(Container container, List<Problem> problems) {
        if (container != null && container != Container.creditCard && container != Container.bank && container != Container.investment && container != Container.loan) {
            TransactionsValidator.createProblemIfTypeNotSupportedTypeForContainer(container, problems);
        }
    }

    private static void containerBelongsToTransactionTypeOnly(Container container, List<Problem> problems) {
        if (container != null && (container == Container.bank || container == Container.creditCard)) {
            TransactionsValidator.createProblemForInvalidType(problems);
        }
    }

    private static void containerBelongsToTransactionTypeAndMeerkatTxnType(Container container, List<Problem> problems) {
        if (container != null && container != Container.bank && container != Container.creditCard && container != Container.investment && container != Container.loan) {
            TransactionsValidator.createProblemIfTypeNotSupportedTypeForContainer(container, problems);
        }
    }

    private static void createProblemForInvalidType(List<Problem> problems) {
        problems.add(new Problem(ApiUtils.getErrorMessage("transactions.param.type.invalid", new Object[0]), ""));
    }

    private static void createProblemIfTypeNotSupportedTypeForContainer(Container container, List<Problem> problems) {
        problems.add(new Problem(ApiUtils.getErrorMessage("transactions.param.type.notSupported", container), ""));
    }
}

