/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.api.validators;

import com.yodlee.api.model.AbstractModelComponent;
import com.yodlee.api.model.account.enums.BankTransferCodeType;
import com.yodlee.api.model.validator.Problem;
import com.yodlee.api.model.verification.MatchingVerification;
import com.yodlee.api.model.verification.UpdateVerification;
import com.yodlee.api.model.verification.Verification;
import com.yodlee.api.model.verification.VerificationAccount;
import com.yodlee.api.model.verification.VerificationBankTransferCode;
import com.yodlee.api.model.verification.VerificationTransaction;
import com.yodlee.api.model.verification.enums.VerificationType;
import com.yodlee.api.model.verification.enums.VerifiedAccountsVerificationStatus;
import com.yodlee.api.model.verification.request.UpdateVerificationRequest;
import com.yodlee.api.model.verification.request.VerificationMatchingRequest;
import com.yodlee.api.model.verification.request.VerificationRequest;
import com.yodlee.sdk.api.VerificationApi;
import com.yodlee.sdk.api.exception.ApiException;
import com.yodlee.sdk.api.util.ApiUtils;
import com.yodlee.sdk.api.validators.ApiValidator;
import java.util.ArrayList;
import java.util.List;

public class VerificationValidator {
    private static final String VERIFICATIONS_VERIFICATION_TYPE_INVALID = "verifications.verificationType.invalid";
    private static final String PARAM_TRUE = "true";
    private static final String PARAM_FALSE = "false";

    private VerificationValidator() {
    }

    public static void validateGetVerificationDetails(VerificationApi verificationApi, String methodName, Long[] providerAccountId, Long[] accountId, VerificationType verificationType) throws ApiException {
        Class[] argTypes = new Class[]{Long[].class, Long[].class, VerificationType.class};
        Object[] argValues = new Object[]{providerAccountId, accountId, verificationType};
        List<Problem> methodProblems = ApiValidator.validate(verificationApi, methodName, argTypes, argValues);
        List<Problem> verificationInputProblems = VerificationValidator.validateVerificationInput(providerAccountId, accountId);
        List<Problem> contextProblems = ApiValidator.validateUserContext(verificationApi);
        methodProblems.addAll(ApiValidator.validateId(accountId, "verifications.param.accountId.invalid"));
        methodProblems.addAll(ApiValidator.validateId(providerAccountId, "verifications.param.providerAccountId.invalid"));
        ApiValidator.collectProblems(methodProblems, contextProblems, verificationInputProblems);
    }

    private static List<Problem> validateVerificationInput(Long[] providerAccountId, Long[] accountId) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (providerAccountId != null && providerAccountId.length > 0 || accountId != null && accountId.length > 0) {
            return problems;
        }
        problems.add(new Problem(ApiUtils.getErrorMessage("verifications.param.id.required", new Object[0]), ""));
        return problems;
    }

    private static List<Problem> validateInput(Long providerAccountId, Long accountId) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (providerAccountId == null && accountId == null) {
            problems.add(new Problem(ApiUtils.getErrorMessage("verifications.param.id.required", new Object[0]), ""));
        }
        return problems;
    }

    public static void validateInitiateCDVerification(VerificationApi verificationApi, String methodName, VerificationRequest verificationParam) throws ApiException {
        Class[] argTypes = new Class[]{VerificationRequest.class};
        Object[] argValues = new Object[]{verificationParam};
        List<Problem> methodProblems = ApiValidator.validate(verificationApi, methodName, argTypes, argValues);
        List<Problem> modelProblems = ApiValidator.validate((AbstractModelComponent)verificationParam);
        List<Problem> contextProblems = ApiValidator.validateUserContext(verificationApi);
        List<Problem> cdvInputProblems = VerificationValidator.validateCDVInput(verificationParam);
        ApiValidator.collectProblems(methodProblems, modelProblems, contextProblems, cdvInputProblems);
    }

    public static void validateMatchingVerification(VerificationApi verificationApi, String methodName, VerificationMatchingRequest verificationParam) throws ApiException {
        Class[] argTypes = new Class[]{VerificationMatchingRequest.class};
        Object[] argValues = new Object[]{verificationParam};
        List<Problem> methodProblems = ApiValidator.validate(verificationApi, methodName, argTypes, argValues);
        List<Problem> contextProblems = ApiValidator.validateUserContext(verificationApi);
        List<Problem> modelProblems = ApiValidator.validate((AbstractModelComponent)verificationParam);
        List<Problem> matchingInputProblems = VerificationValidator.validateMatchingInput(verificationParam);
        ApiValidator.collectProblems(methodProblems, modelProblems, contextProblems, matchingInputProblems);
    }

    private static List<Problem> validateCDVInput(VerificationRequest verificationParam) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Verification verification = verificationParam.getVerification();
        VerificationType verType = verification.getVerificationType();
        if (!verType.equals((Object)VerificationType.CHALLENGE_DEPOSIT)) {
            problems.add(new Problem(ApiUtils.getErrorMessage(VERIFICATIONS_VERIFICATION_TYPE_INVALID, new Object[0]), ""));
        } else {
            VerificationAccount accountVo = verification.getAccount();
            if (accountVo == null) {
                problems.add(new Problem(ApiUtils.getErrorMessage("verifications.account.details.required", new Object[0]), ""));
            } else {
                VerificationBankTransferCode bankTransferCodeVo = accountVo.getBankTransferCode();
                if (bankTransferCodeVo != null && bankTransferCodeVo.getType() != BankTransferCodeType.ROUTING_NUMBER) {
                    problems.add(new Problem(ApiUtils.getErrorMessage("verifications.banktransfercode.type.invalid", new Object[0]), ""));
                }
            }
        }
        return problems;
    }

    private static List<Problem> validateMatchingInput(VerificationMatchingRequest verificationParam) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        MatchingVerification verification = verificationParam.getVerification();
        VerificationType verType = verification.getVerificationType();
        if (!verType.equals((Object)VerificationType.MATCHING)) {
            problems.add(new Problem(ApiUtils.getErrorMessage(VERIFICATIONS_VERIFICATION_TYPE_INVALID, new Object[0]), ""));
        } else {
            Long accountId = verification.getAccountId();
            Long providerAccountId = verification.getProviderAccountId();
            problems.addAll(VerificationValidator.validateInput(providerAccountId, accountId));
        }
        return problems;
    }

    public static void validatePerformCDVerification(VerificationApi verificationApi, String methodName, UpdateVerificationRequest updateVerificationRequest) throws ApiException {
        Class[] argTypes = new Class[]{UpdateVerificationRequest.class};
        Object[] argValues = new Object[]{updateVerificationRequest};
        List<Problem> methodProblems = ApiValidator.validate(verificationApi, methodName, argTypes, argValues);
        List<Problem> modelProblems = ApiValidator.validate((AbstractModelComponent)updateVerificationRequest);
        List<Problem> contextProblems = ApiValidator.validateUserContext(verificationApi);
        List<Problem> validateVerificationRequestProblems = VerificationValidator.validateUpdateVerificationRequest(updateVerificationRequest);
        ApiValidator.collectProblems(methodProblems, modelProblems, contextProblems, validateVerificationRequestProblems);
    }

    private static List<Problem> validateUpdateVerificationRequest(UpdateVerificationRequest updateVerificationRequest) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        UpdateVerification verification = updateVerificationRequest.getVerification();
        VerificationType verificationType = verification.getVerificationType();
        if (!verificationType.equals((Object)VerificationType.CHALLENGE_DEPOSIT)) {
            problems.add(new Problem(ApiUtils.getErrorMessage(VERIFICATIONS_VERIFICATION_TYPE_INVALID, new Object[0]), ""));
        } else {
            List verificationTransactions = verification.getTransactions();
            if (verificationTransactions != null) {
                for (VerificationTransaction txn : verificationTransactions) {
                    if (txn.getAmount() == null) continue;
                    VerificationValidator.processVerificationTxn(problems, txn);
                }
            }
        }
        return problems;
    }

    private static void processVerificationTxn(List<Problem> problems, VerificationTransaction txn) {
        String amountSplit;
        String amount;
        if (txn.getAmount().getCurrency() == null) {
            String errorMessage = ApiUtils.getErrorMessage("verifications.transaction.currency.required", new Object[0]);
            problems.add(new Problem(errorMessage, ""));
        }
        if ((amount = String.valueOf(txn.getAmount().getAmount())).contains(".") && (amountSplit = amount.substring(amount.indexOf(46) + 1)).length() > 2) {
            String errorMessage = ApiUtils.getErrorMessage("verifications.transaction.amount.invalid.length", new Object[0]);
            problems.add(new Problem(errorMessage, ""));
        }
    }

    private static void validateIsSelected(List<Problem> problems, String[] isSelected) {
        if (isSelected == null) {
            return;
        }
        for (String isSelectedValue : isSelected) {
            if (PARAM_TRUE.equals(isSelectedValue) || PARAM_FALSE.equals(isSelectedValue)) continue;
            problems.add(new Problem(ApiUtils.getErrorMessage("verifications.param.isselected.invalid", new Object[0]), ""));
        }
    }

    public static void validateVerifiedAccounts(VerificationApi verificationApi, String methodName, long providerAccountId, Long[] accountId, VerifiedAccountsVerificationStatus[] verificationStatus, String[] isSelected) throws ApiException {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        VerificationValidator.validateIsSelected(problems, isSelected);
        Class[] argTypes = new Class[]{Long.TYPE, Long[].class, VerifiedAccountsVerificationStatus[].class, String[].class};
        Object[] argValues = new Object[]{providerAccountId, accountId, verificationStatus, isSelected};
        List<Problem> methodProblems = ApiValidator.validate(verificationApi, methodName, argTypes, argValues);
        List<Problem> contextProblems = ApiValidator.validateUserContext(verificationApi);
        ApiValidator.collectProblems(problems, methodProblems, contextProblems);
    }
}

