/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.builder;

import com.yodlee.api.model.AbstractModelComponent;
import com.yodlee.api.model.cobrand.request.CobrandLoginRequest;
import com.yodlee.sdk.api.CobrandApi;
import com.yodlee.sdk.api.exception.ApiException;
import com.yodlee.sdk.api.validators.ApiValidator;
import com.yodlee.sdk.builder.Builder;
import com.yodlee.sdk.builder.ConfigValidationUtil;
import com.yodlee.sdk.configuration.cobrand.CobrandConfiguration;
import com.yodlee.sdk.context.CobrandContext;
import com.yodlee.sdk.context.Context;

public class CobrandContextBuilder
implements Builder<CobrandConfiguration, CobrandContext> {
    @Override
    public CobrandContext build(CobrandConfiguration cobrandConfiguration) throws ApiException {
        ConfigValidationUtil.validateConfig(cobrandConfiguration);
        CobrandApi cobrandApi = new CobrandApi(cobrandConfiguration);
        CobrandLoginRequest cobrandLoginRequest = new CobrandLoginRequest();
        CobrandLoginRequest.Cobrand cobrand = new CobrandLoginRequest.Cobrand();
        cobrand.setCobrandLogin(cobrandConfiguration.getLoginName());
        cobrand.setCobrandPassword(cobrandConfiguration.getPassword());
        cobrand.setLocale(cobrandConfiguration.getLocale());
        cobrandLoginRequest.setCobrand(cobrand);
        ApiValidator.validate((AbstractModelComponent)cobrandLoginRequest);
        cobrandApi.cobrandLogin(cobrandLoginRequest);
        Context<?> context = cobrandApi.getContext();
        return (CobrandContext)context;
    }
}

