/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.builder;

import com.yodlee.sdk.api.exception.ApiException;
import com.yodlee.sdk.builder.Builder;
import com.yodlee.sdk.builder.ConfigValidationUtil;
import com.yodlee.sdk.builder.JWTUtil;
import com.yodlee.sdk.configuration.user.JWTUserConfiguration;
import com.yodlee.sdk.context.JWTUserContext;

public class JWTUserContextBuilder
implements Builder<JWTUserConfiguration, JWTUserContext> {
    @Override
    public JWTUserContext build(JWTUserConfiguration jwtConfiguration) throws ApiException {
        ConfigValidationUtil.validateConfig(jwtConfiguration);
        String jwtToken = JWTUtil.getJWTToken(jwtConfiguration.getApiKey(), jwtConfiguration.getPrivateKey(), jwtConfiguration.getUser(), jwtConfiguration.getExpiresIn(), jwtConfiguration.getLocale());
        return new JWTUserContext(jwtToken, jwtConfiguration);
    }
}

